/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface RecoveryReentrantChecker {
    public DrmEnumDefine.RecoveryPlanExecuteTypeE getProcessorType();

    default public List<String> getCheckProcessors() {
        return Collections.emptyList();
    }

    default public void checkProcessorsLogSuccess(List<RecoveryProcessorDetail> details, List<String> succeedProcessors) {
        for (RecoveryProcessorDetail detail : details) {
            List childDetails;
            if (this.getCheckProcessors().contains(detail.getProcessName())) {
                if (detail.getProcessStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
                    return;
                }
                succeedProcessors.add(detail.getProcessName());
            }
            if (VerifyUtil.isEmpty((Collection)(childDetails = detail.getChildDetails()))) continue;
            this.checkProcessorsLogSuccess(childDetails, succeedProcessors);
        }
    }

    default public void checkIfExecutedSpecificProcessor(List<RecoveryProcessorDetail> details, String processorName, List<Boolean> checkResult) {
        for (RecoveryProcessorDetail detail : details) {
            if (StringUtils.equals((CharSequence)processorName, (CharSequence)detail.getProcessName())) {
                checkResult.add(true);
                return;
            }
            List childDetails = detail.getChildDetails();
            if (VerifyUtil.isEmpty((Collection)childDetails)) continue;
            this.checkIfExecutedSpecificProcessor(childDetails, processorName, checkResult);
        }
    }

    default public boolean checkReentrantAble(RecoveryPlan recoveryPlan) {
        ArrayList<String> succeedProcessors = new ArrayList<String>();
        List<RecoveryProcessorDetail> details = this.getRecentProcessorDetails(recoveryPlan);
        if (VerifyUtil.isEmpty(details)) {
            return false;
        }
        this.checkProcessorsLogSuccess(details, succeedProcessors);
        return succeedProcessors.size() == this.getCheckProcessors().size();
    }

    default public boolean hasExecutedSpecificProcessor(RecoveryPlan recoveryPlan, String processorName) {
        List<RecoveryProcessorDetail> details = this.getRecentProcessorDetails(recoveryPlan);
        if (VerifyUtil.isEmpty(details)) {
            return false;
        }
        ArrayList<Boolean> checkResult = new ArrayList<Boolean>();
        this.checkIfExecutedSpecificProcessor(details, processorName, checkResult);
        return !VerifyUtil.isEmpty(checkResult);
    }

    default public List<RecoveryProcessorDetail> getRecentProcessorDetails(RecoveryPlan recoveryPlan) {
        IRecoveryPlanBaseService rpService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        List recoveryLogs = rpService.getHistoryReocveryLogsByPlanId(recoveryPlan.getUuid());
        if (VerifyUtil.isEmpty((Collection)recoveryLogs)) {
            return Collections.emptyList();
        }
        List sortedLogs = recoveryLogs.stream().sorted(Comparator.comparing(e -> Long.parseLong(e.getEndTime()), Comparator.reverseOrder())).collect(Collectors.toList());
        RecoveryLog recoveryLog = (RecoveryLog)sortedLogs.get(0);
        if (recoveryLog.getLogType() != this.getProcessorType().getValue()) {
            return Collections.emptyList();
        }
        return rpService.getRecoveryProcessorDetailsByLogId(recoveryPlan.getUuid(), recoveryLog.getLogId());
    }
}

