/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class KubeReprotectCheckResourceProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = -3448170255707884318L;
    private static final Log LOGGER = LogFactory.getInstance(KubeReprotectCheckResourceProcessor.class);

    public KubeReprotectCheckResourceProcessor() {
        this.setProcName(this.getName());
        this.setIsNeedSave(false);
    }

    private void lockProtectGroup(RecoveryProcessorContext recoveryProcessorContext) {
        ProtectGroup protectGroup = this.getContextRef().getProtectGroup();
        String pgid = protectGroup.getUuid();
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        protectGroupService.lockProtectGroup(new String[]{pgid});
        recoveryProcessorContext.setAttribute("LockProtectGroup", (Object)true);
    }

    protected boolean execute(RecoveryProcessorContext recoveryProcessorContext) {
        this.lockProtectGroup(recoveryProcessorContext);
        String[] deviceSns = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)this.getRecoveryPlan());
        boolean isClusterConnectable = this.checkKubeClusterAvailable(deviceSns);
        if (!isClusterConnectable) {
            return false;
        }
        ProtectGroup protectGroup = this.getContextRef().getProtectGroup();
        String[] backends = (String[])Stream.of("sourceStorageBackendName", "targetStorageBackendName").map(arg_0 -> ((ProtectGroup)protectGroup).getProperty(arg_0)).toArray(String[]::new);
        boolean isBackendAvailable = this.checkStorageBackendAvailable(deviceSns, backends);
        if (!isBackendAvailable) {
            return false;
        }
        int templateType = this.getRecoveryPlan().getProtectGroup().getTemplate().getType();
        if (!PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(templateType)) {
            return true;
        }
        return this.checkHyperMetroDomainNormal(protectGroup);
    }

    private boolean checkHyperMetroDomainNormal(ProtectGroup protectGroup) {
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        String domainName = protectGroup.getProperty("domainName");
        if (KubeRefreshResourceUtils.checkHyperMetroDomainNormal(schedule.getSourceSn(), domainName) && KubeRefreshResourceUtils.checkHyperMetroDomainNormal(schedule.getTargetSn(), domainName)) {
            return this.success();
        }
        return this.failure("ism.drm.recovery.k8s.reprotect.domain.unavailable", new String[]{domainName});
    }

    private boolean checkKubeClusterAvailable(String[] kubeDevSnLists) {
        IKubeHandler kubeHandler = KubeReprotectCheckResourceProcessor.getKubeHandler();
        for (String kubeDevSn : kubeDevSnLists) {
            if (this.checkKubeClusterAvailable(kubeHandler, kubeDevSn)) continue;
            return false;
        }
        return true;
    }

    private boolean checkKubeClusterAvailable(IKubeHandler kubeHandler, String kubeSn) {
        boolean isConnectable = kubeHandler.checkConnectionBySN(kubeSn);
        if (isConnectable) {
            return true;
        }
        return this.failure("ism.drm.recovery.k8s.reprotect.cluster.unavailable", new String[]{KubeReprotectCheckResourceProcessor.getKubeName(kubeSn)});
    }

    private static DrResource getKube(String kubeSn) {
        return ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(kubeSn);
    }

    private static String getKubeName(String kubeSn) {
        return KubeReprotectCheckResourceProcessor.getKube(kubeSn).getName();
    }

    private boolean checkStorageBackendAvailable(String[] kubeSnList, String[] backendList) {
        int limit = backendList.length;
        for (int index = 0; index < limit; ++index) {
            if (this.checkStorageBackendAvailable(kubeSnList[index], backendList[index])) continue;
            return false;
        }
        return this.success();
    }

    private boolean checkStorageBackendAvailable(String kubeSn, String storageName) {
        IKubeHandler kubeHandler = KubeReprotectCheckResourceProcessor.getKubeHandler();
        Optional<KubeStorage> optional = kubeHandler.getStorageBackendClaims(kubeSn).stream().filter(sbc -> Objects.equals(sbc.getName(), storageName)).filter(KubeStorage::isOnline).findAny();
        if (optional.isPresent()) {
            return true;
        }
        return this.failure("ism.drm.recovery.k8s.reprotect.backend.unavailable", new String[]{KubeReprotectCheckResourceProcessor.getKubeName(kubeSn), storageName});
    }
}

