/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro;

import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro.KubeHyperMetroCdrRefactorSubProcessor;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public class KubeHyperMetroCdrRefactorProcessor
extends BaseKubeRecoveryProcessor {
    private static final long serialVersionUID = -24482124286624230L;
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroCdrRefactorProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start to execute KubeHyperMetroCdrRefactorProcessor");
        ArrayList<BaseRecoveryProcessor> processors = new ArrayList<BaseRecoveryProcessor>();
        processors.add(this.createSubProcessor(KubeHyperMetroCdrRefactorSubProcessor::new, processor -> {
            processor.setProcName(KubeHyperMetroCdrRefactorSubProcessor.class.getName() + ".target");
            processor.setProduct(false);
        }));
        processors.add(this.createSubProcessor(KubeHyperMetroCdrRefactorSubProcessor::new, processor -> {
            processor.setProcName(KubeHyperMetroCdrRefactorSubProcessor.class.getName() + ".source");
            processor.setProduct(true);
        }));
        this.saveSubProcessors(processors);
        boolean isExecSuccess = this.invoke(context);
        if (isExecSuccess) {
            ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
            String domainName = protectGroup.getProperty("domainName");
            boolean isProductionDomainNormal = KubeRefreshResourceUtils.checkHyperMetroDomainNormal(this.getDevSn(0), domainName);
            boolean isDisasterDomainNormal = KubeRefreshResourceUtils.checkHyperMetroDomainNormal(this.getDevSn(1), domainName);
            if (!isProductionDomainNormal || !isDisasterDomainNormal) {
                LOGGER.error((Object)"Status of the hyper metro domain ( %s ) is Unavailable", new Object[]{domainName});
                throw new LegoCheckedException(1073947765L, new String[]{domainName});
            }
        }
        return isExecSuccess;
    }

    @Override
    protected List<Object> hashData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.getProcId());
        return data;
    }
}

