/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.kube.model.KubeJobListenerExecuteParam;
import com.huawei.ism.drm.kube.recovery.model.KubeRecoveryExecuteRecord;
import com.huawei.ism.drm.kube.recovery.process.BaseKubeRecoveryEventProcessor;
import com.huawei.ism.drm.kube.recovery.process.reprotect.hypermetro.KubeHyperMetroCdrRefactorProcessor;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventKeywords;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobOperation;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRecoveryJobType;
import com.huawei.ism.drm.kube.service.KubeHyperMetroProtectGroupRefreshWatcher;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class KubeHyperMetroRefactorConfigurationProcessor
extends BaseKubeRecoveryEventProcessor {
    private static final long serialVersionUID = -4597747006288082052L;
    private static final Log LOGGER = LogFactory.getInstance(KubeHyperMetroRefactorConfigurationProcessor.class);

    @Override
    protected String getStage() {
        return "Resources";
    }

    @Override
    protected KubeRecoveryJobType getJobType() {
        return KubeRecoveryJobType.PLAN_MIGRATION;
    }

    @Override
    protected KubeJobType getJobSubType() {
        return KubeJobType.RECOVERY_JOB;
    }

    @Override
    protected String getStartKeyword() {
        return KubeEventKeywords.HyperMetroVolumeRecoveryJob.FAIL_OVER_DOMAIN_START.getValue();
    }

    @Override
    protected String getEndKeyword() {
        return KubeEventKeywords.HyperMetroVolumeRecoveryJob.FAIL_OVER_DOMAIN_END.getValue();
    }

    @Override
    protected KubeRecoveryJobOperation getCurrentJobOperation() {
        return KubeRecoveryJobOperation.FAIL_OVER_DOMAIN;
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start execute KubeHyperMetroRefactorConfigurationProcessor");
        boolean isRecoverySuccess = this.executeRecoveryOperation(context);
        if (!isRecoverySuccess) {
            LOGGER.error((Object)"Execute recovery operation failed.");
            return false;
        }
        boolean isReprotectSuccess = this.executeReProtectionOperation(context);
        if (isReprotectSuccess) {
            KubeHyperMetroProtectGroupRefreshWatcher hyperMetroWatcher = (KubeHyperMetroProtectGroupRefreshWatcher)ServiceLocator.getInstance().getService(KubeHyperMetroProtectGroupRefreshWatcher.class);
            ProtectGroup protectGroup = this.getRecoveryPlan().getProtectGroup();
            hyperMetroWatcher.register(protectGroup.getUuid(), protectGroup.getProperty("domainName"));
        }
        return isReprotectSuccess;
    }

    private boolean executeRecoveryOperation(RecoveryProcessorContext context) {
        if (this.checkOperationAlreadySucceed(KubeRecoveryJobOperation.FAIL_OVER_DOMAIN.getValue()) && this.checkOperationAlreadySucceed(KubeRecoveryJobOperation.RECOVER_RESOURCES.getValue())) {
            return true;
        }
        if (!this.switchApSite(context)) {
            return false;
        }
        return this.recoveryDisasterVolume(context);
    }

    private boolean switchApSite(RecoveryProcessorContext context) {
        String domainType = this.getHyperMetroDomainType(this.getRecoveryPlan());
        if (!StringUtils.equals((CharSequence)domainType, (CharSequence)KubeEnumDefine.DomainType.AA_TYPE.getValue())) {
            return this.success();
        }
        LOGGER.info((Object)"Start execute kube job.DeviceSn: %s, jobType: %s, jobName: %s, jobOperation: %s", new Object[]{this.getDevSn(), this.getJobType().getValue(), this.getJobName(), this.getCurrentJobOperation().getValue()});
        this.createRecoveryJob();
        boolean isExecuteSuccess = this.listenEvent();
        this.updateExecuteRecord(KubeRecoveryJobOperation.FAIL_OVER_DOMAIN.getValue(), isExecuteSuccess);
        return isExecuteSuccess;
    }

    private boolean recoveryDisasterVolume(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start execute kube job.DeviceSn: %s, jobType: %s, jobName: %s, jobOperation: %s", new Object[]{this.getDevSn(), this.getJobType().getValue(), this.getJobName(), KubeRecoveryJobOperation.RECOVER_RESOURCES.getValue()});
        this.modifyRecoveryJob(KubeRecoveryJobOperation.RECOVER_RESOURCES.getValue());
        KubeJobListenerExecuteParam param = new KubeJobListenerExecuteParam();
        param.setDevSn(this.getDevSn());
        param.setJobType(this.getJobSubType());
        param.setJobName(this.getJobName());
        param.setStartKeyword(KubeEventKeywords.HyperMetroVolumeRecoveryJob.RECOVER_START.getValue());
        param.setEndKeyword(KubeEventKeywords.HyperMetroVolumeRecoveryJob.RECOVER_END.getValue());
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("lastUpdateTimestamp", this.getLastUpdateTimeStamp());
        extendParams.put("stage", this.getStage());
        param.setExtend(extendParams);
        boolean isExecuteSuccess = this.listenEvent(param);
        this.updateExecuteRecord(KubeRecoveryJobOperation.RECOVER_RESOURCES.getValue(), isExecuteSuccess);
        return isExecuteSuccess;
    }

    private boolean executeReProtectionOperation(RecoveryProcessorContext context) {
        ArrayList<BaseRecoveryProcessor> processors = new ArrayList<BaseRecoveryProcessor>();
        processors.add(this.createSubProcessor(KubeHyperMetroCdrRefactorProcessor::new, processor -> processor.setReentrantable(false)));
        processors.add(this.createSubProcessor(RefactorProtectRelationProcessor::new, processor -> {
            processor.setProcName(RefactorProtectRelationProcessor.class.getName() + "2");
            processor.setReentrantable(false);
        }));
        this.saveSubProcessors(processors);
        boolean isExecSuccess = this.invoke(context);
        if (isExecSuccess) {
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            RecoveryPlan recoveryPlan = this.getRecoveryPlan();
            String pgId = recoveryPlan.getProtectGroup().getUuid();
            pgService.resetProtectGroupStatus(pgId);
            KubeRecoveryExecuteRecord record = (KubeRecoveryExecuteRecord)context.getAttribute("executeRecord", KubeRecoveryExecuteRecord.class);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)record);
        }
        return isExecSuccess;
    }
}

