/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.recovery.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.PodResource;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.utils.KubeRecoveryUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KubeRecoveryProcessProvider
extends BaseRecoveryProcessProvider {
    private static final Log LOGGER = LogFactory.getInstance(KubeRecoveryProcessProvider.class);
    private static final Map<String, Boolean> HYPER_METRO_OPERATION_STATUS_MAP = new HashMap<String, Boolean>();

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>(2);
        appTypes.add(DrmEnumDefine.AppType.KUBE_RESOURCE_SET.name());
        appTypes.add(DrmEnumDefine.AppType.KUBE_PERSISTENT_VOLUME.name());
        return appTypes;
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        String[] sites = RecoveryPlanUtil.getDeviceSiteFromRecovery((RecoveryPlan)recoveryPlan);
        return sites[1];
    }

    public void checkOperation(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        ProtectObject protectObject = (ProtectObject)protectGroup.getPolist().iterator().next();
        String poSubType = protectObject.getProperty("poSubType");
        if ("HyperMetro".equals(poSubType)) {
            this.checkHyperMetroOperation(status, operation);
            if (protectGroup.getStatus() == DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus()) {
                LOGGER.error((Object)"Protect group %s is locked. Can not execute recovery plan.", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073948196L);
            }
        } else {
            super.checkOperation(recoveryPlan, status, operation);
        }
    }

    private void checkHyperMetroOperation(DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        if (status == null || operation == null) {
            LOGGER.error((Object)"RecoveryPlan status or operation is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String key = KubeRecoveryProcessProvider.generateKey(status, operation);
        if (!Boolean.TRUE.equals(HYPER_METRO_OPERATION_STATUS_MAP.get(key))) {
            LOGGER.error((Object)"Current operation ( %s ) is not allowed for the RecoveryPlan status ( %s )", new Object[]{operation.getValue(), status.getValue()});
            throw new LegoCheckedException(1073948693L);
        }
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)planId) || procType == null) {
            LOGGER.error((Object)"Execute recovery plan failed,cause param is invalid.planId=%s, procType=%s", new Object[]{planId, procType});
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        String[] kubeSns = RecoveryPlanUtil.getDeviceSnFromRecovery((RecoveryPlan)recoveryPlan);
        String productionSn = kubeSns[0];
        String disasterSn = kubeSns[1];
        HashMap<String, Object> settings = new HashMap<String, Object>();
        int policyTemplate = RecoveryPlanUtil.getPolicyTemplateFromRecovery((RecoveryPlan)recoveryPlan).getType();
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(policyTemplate)) {
            this.checkBackupRecoveryContext(recoveryContext, recoveryPlan, productionSn);
            List<String> contextKeys = Arrays.asList("execNamespace", "restorePrefix", "execPostHook", "preserveClusterIpAddr", "preserveNodePort", "REPLICA_ID", "ROLLBACK_RATE");
            contextKeys.forEach(key -> this.buildRecoverySettings(recoveryPlan.getGlobalSettings(), recoveryContext, (Map<String, Object>)settings, (String)key));
            this.updateRecoveryPlan(recoveryPlan);
        } else if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(policyTemplate)) {
            String[] sites = RecoveryPlanUtil.getDeviceSiteFromRecovery((RecoveryPlan)recoveryPlan);
            settings.put("DISASTER_SITE_ID", sites[1]);
            String postHook = recoveryContext.get("execPostHook");
            if (VerifyUtil.isEmpty((String)postHook)) {
                recoveryContext.put("execPostHook", "");
            }
            this.buildRecoverySettings(recoveryPlan.getGlobalSettings(), recoveryContext, settings, "execPostHook");
            recoveryPlan.getGlobalSettings().put("RECOVERY_EXTEND_ATTRIBUTES", "-1");
            this.updateRecoveryPlan(recoveryPlan);
            String planName = (String)recoveryPlan.getGlobalSettings().get("cdrRecoveryName");
            if (!DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.equals((Object)procType) && KubeRecoveryProcessProvider.getKubeHandler().getKubeRecoveryPlan(productionSn, planName).isPresent()) {
                KubeRecoveryProcessProvider.getKubeHandler().modifyRecoveryPlan(productionSn, planName, postHook);
            }
            KubeRecoveryProcessProvider.getKubeHandler().modifyRecoveryPlan(disasterSn, planName, postHook);
        } else {
            LOGGER.error((Object)"Check recovery context error,cause policy template [ %s ] is invalid.", new Object[]{policyTemplate});
            throw new LegoCheckedException(1073947393L);
        }
        return settings;
    }

    private void checkBackupRecoveryContext(Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String productionSn) {
        String nameSpace = recoveryContext.get("execNamespace");
        KubeRecoveryUtils.checkNamespace(productionSn, nameSpace);
        String restorePrefix = recoveryContext.get("restorePrefix");
        KubeRecoveryUtils.checkPrefix(restorePrefix);
        this.checkBackupResources(recoveryPlan, restorePrefix);
        String postHook = recoveryContext.get("execPostHook");
        KubeRecoveryUtils.checkHook(productionSn, postHook);
        KubeRecoveryUtils.checkBoolSetting(recoveryContext, "preserveClusterIpAddr", false);
        KubeRecoveryUtils.checkBoolSetting(recoveryContext, "preserveNodePort", false);
    }

    private void checkBackupResources(RecoveryPlan recoveryPlan, String restorePrefix) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (pg == null) {
            LOGGER.error((Object)"Check backup resources error, target protect group is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)pg.getPolist());
        if (po == null) {
            LOGGER.error((Object)"Check backup resources error, target protect object is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Optional optional = KubeRecoveryProcessProvider.getKubeHandler().getResourceSetInfo(po.getProviderSN(), po.getName());
        if (!optional.isPresent()) {
            LOGGER.error((Object)"Check backup resources error, target resource set (%s) is not exist.", new Object[]{po.getName()});
            throw new LegoCheckedException(2117645L);
        }
        ResourceSetInfo resourceSet = (ResourceSetInfo)optional.get();
        List details = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)resourceSet.getProtectResources()), PodResource.class);
        for (PodResource detail : details) {
            KubeRecoveryUtils.checkResourceName(detail.getName(), restorePrefix);
        }
    }

    private void buildRecoverySettings(Map<String, String> globalSetting, Map<String, String> recoveryContext, Map<String, Object> settings, String settingKey) {
        String settingValue = recoveryContext.get(settingKey);
        if (VerifyUtil.isEmpty((String)settingValue)) {
            globalSetting.remove(settingKey);
        } else {
            globalSetting.put(settingKey, settingValue);
            settings.put(settingKey, settingValue);
        }
    }

    private RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(recoveryPlanId);
        if (recoveryPlan == null) {
            LOGGER.error((Object)"Execute recovery plan failed,cause target recovery plan of id [%s] is not exist.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        return recoveryPlan;
    }

    private void updateRecoveryPlan(RecoveryPlan recoveryPlan) {
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        planService.saveOrUpdateRecoveryPlan(recoveryPlan);
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    private static String generateKey(DrmEnumDefine.RecoveryPlanStatusE status, DrmEnumDefine.RecoveryPlanOperationType operation) {
        return status.getValue() + ":" + operation.getValue();
    }

    static {
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.READY, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.DELETE_RECOVERY_PLAN), true);
        HYPER_METRO_OPERATION_STATUS_MAP.put(KubeRecoveryProcessProvider.generateKey(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_FAILED, DrmEnumDefine.RecoveryPlanOperationType.REPROTECT), true);
    }
}

