/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.utils;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.Domain;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class KubeRefreshResourceUtils {
    private static final Log LOGGER = LogFactory.getInstance(KubeRefreshResourceUtils.class);
    private static final int REFRESH_DOMAIN_QUERY_TIMES = 60;
    private static final int REFRESH_DOMAIN_QUERY_DURATION = 5;
    private static final String DOMAIN_STATUS_NORMAL = "Normal";

    public static void refreshResourceSet(String kubeSn, String resourceSetName) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        kubeHandler.refreshKubeResourceSet(kubeSn, resourceSetName, resourceSet -> KubeRefreshResourceUtils.saveOrUpdateOrDeleteResourceSet(kubeSn, Collections.singletonList(resourceSet), false));
    }

    public static void saveOrUpdateOrDeleteResourceSet(String deviceSn, List<ResourceSetInfo> newResourceSetList, boolean isFullRefresh) {
        IKubeService kubeService = (IKubeService)ServiceLocator.getInstance().getService(IKubeService.class);
        if (VerifyUtil.isEmpty(newResourceSetList)) {
            LOGGER.warn((Object)"[kubernetes]Cancel save or update resource set, cause resource set is empty.");
            if (isFullRefresh) {
                kubeService.removeLocalKubeResourceSets(kubeService.getResourceSets(deviceSn));
            }
            return;
        }
        kubeService.batchSaveOrUpdateResourceSet(newResourceSetList);
        if (isFullRefresh) {
            List oldResourceSetInfoList = kubeService.getResourceSets(deviceSn);
            HashMap newResourceSetInfoMap = new HashMap();
            newResourceSetList.forEach(resourceSetInfo -> newResourceSetInfoMap.put(resourceSetInfo.getKubeId() + resourceSetInfo.getId(), resourceSetInfo));
            kubeService.removeLocalKubeResourceSets(oldResourceSetInfoList.stream().filter(resourceSetInfo -> !newResourceSetInfoMap.containsKey(resourceSetInfo.getKubeId() + resourceSetInfo.getId())).collect(Collectors.toList()));
        }
    }

    public static void checkProtectPlanStatusNormalOrPending(String devSn, String name) {
        block3: {
            Optional opt;
            long curTime;
            long startTime = System.currentTimeMillis();
            do {
                CommUtil.pauseThread((long)10000L);
                opt = ((IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class)).getProtectionPlan(devSn, name);
                if (!opt.isPresent()) {
                    LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                    throw new LegoCheckedException(2117645L);
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.ERROR) {
                    LOGGER.error((Object)"The protect cdr PP is Error, can not create recovery.");
                    throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.NORMAL || ((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.PENDING) break block3;
            } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
            LOGGER.error((Object)"Get PP status: %s by max wait time on %s.", new Object[]{((KubeProtectionPlan)opt.get()).getStatus().getValue(), devSn});
            throw new LegoCheckedException(1073947433L);
        }
        LOGGER.info((Object)"The protect cdr protection plan is normal or pending.");
    }

    public static void checkProtectPlanStatusNormalOrError(ProtectGroup protectGroup, String devSn, String name) {
        KubeProtectionPlan plan;
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        do {
            String planStatusInProtectGroup;
            CommUtil.pauseThread((long)10000L);
            Optional opt = kubeHandler.getProtectionPlan(devSn, name);
            if (!opt.isPresent()) {
                LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                throw new LegoCheckedException(2117645L);
            }
            plan = (KubeProtectionPlan)opt.get();
            String string = planStatusInProtectGroup = protectGroup.getPoProviderSN().equals(devSn) ? (String)protectGroup.getProps().get("sourceProtectionPlanStatus") : (String)protectGroup.getProps().get("targetProtectionPlanStatus");
            if (!plan.getStatus().getValue().equals(planStatusInProtectGroup)) {
                KubeRefreshResourceUtils.updateProtectionPlanStatusInProps(protectGroup, devSn, plan);
            }
            if (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.ERROR) continue;
            LOGGER.error((Object)"The protect cdr PP on %s is Error, can not create recovery.", new Object[]{devSn});
            throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
        } while (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.NORMAL);
        LOGGER.info((Object)"The protect cdr PP is normal, can create recovery.");
    }

    private static void updateProtectionPlanStatusInProps(ProtectGroup protectGroup, String devSn, KubeProtectionPlan plan) {
        ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        protectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        curProtectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
    }

    public static boolean checkHyperMetroDomainNormal(String kubeSn, String domainName) {
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        kubeHandler.refreshHyperMetroDomain(kubeSn, domainName);
        for (int i = 0; i < 60; ++i) {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Optional opt = kubeHandler.getHyperMetroDomain(kubeSn, domainName);
            if (!opt.isPresent()) {
                LOGGER.error((Object)"The HyperMetroDomain (%s) is not present.", new Object[]{domainName});
                throw new LegoCheckedException(2117645L);
            }
            Domain domain = (Domain)opt.get();
            if (!StringUtils.equals((CharSequence)domain.getStatus(), (CharSequence)DOMAIN_STATUS_NORMAL)) continue;
            return true;
        }
        return false;
    }
}

