/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.utils;

import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeReProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryJob;
import com.huawei.ism.drm.kube.sdk.model.KubeResource;
import com.huawei.ism.drm.kube.sdk.model.KubeRestoreJob;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeRestoreJobStatus;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class KubeResourceUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeResourceUtil.class);
    private static final String KUBE_RESOURCE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String KUBE_RESOURCE_TIME_CONCATENATION_DAY = "T";
    private static final String KUBE_RESOURCE_TIME_CONCATENATION_SECOND = "Z";

    public static void sort(List<KubeResource> resources) {
        List<String> list = Arrays.asList("Deployment", "ReplicaSet", "DaemonSet", "StatefulSet", "Pod", "Service", "Secret", "ConfigMap", "ServiceAccount", "ClusterRole", "ClusterRoleBinding");
        resources.sort(Comparator.comparing(resource -> list.indexOf(resource.getKind())));
    }

    public static String transKubeTime(String time) {
        if (VerifyUtil.isEmpty((String)time)) {
            throw new LegoCheckedException(1073947393L);
        }
        String result = time.replace(KUBE_RESOURCE_TIME_CONCATENATION_DAY, " ");
        result = result.replace(KUBE_RESOURCE_TIME_CONCATENATION_SECOND, "");
        return result;
    }

    public static boolean checkIfProtectionJobComplete(String kubeSn, String jobName) {
        Optional optional = KubeResourceUtil.getKubeHandler().getProtectionJobByName(kubeSn, jobName);
        if (optional.isPresent()) {
            KubeProtectionJob job = (KubeProtectionJob)optional.get();
            return StringUtils.equals((CharSequence)job.getStage(), (CharSequence)"Finished") && StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Completed") || StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Failed");
        }
        return false;
    }

    public static boolean checkIfBackupJobComplete(String kubeSn, String jobName) {
        Optional optional = KubeResourceUtil.getKubeHandler().getBackupJobByName(kubeSn, jobName);
        if (optional.isPresent()) {
            KubeBackupJob job = (KubeBackupJob)optional.get();
            return StringUtils.equals((CharSequence)job.getStage(), (CharSequence)"Finished") && StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Completed") || StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Failed");
        }
        return false;
    }

    public static boolean checkIfRestoreJobComplete(String kubeSn, String jobName) {
        Optional optional = KubeResourceUtil.getKubeHandler().getKubeRestoreJob(kubeSn, jobName);
        if (optional.isPresent()) {
            KubeRestoreJob job = (KubeRestoreJob)optional.get();
            return KubeRestoreJobStatus.State.COMPLETED.equals((Object)job.getState()) && KubeRestoreJobStatus.Stage.FINISHED.equals((Object)job.getStage()) || KubeRestoreJobStatus.State.FAILED.equals((Object)job.getState());
        }
        return false;
    }

    public static boolean checkIfRecoveryJobComplete(String kubeSn, String jobName, Map<String, Object> extend) {
        String lastUpdateTimestamp = null;
        Object lastUpdateTimestampObj = extend.get("lastUpdateTimestamp");
        if (lastUpdateTimestampObj instanceof String) {
            lastUpdateTimestamp = (String)lastUpdateTimestampObj;
        }
        String stage = null;
        Object stageObj = extend.get("stage");
        if (stageObj instanceof String) {
            stage = (String)stageObj;
        }
        LOGGER.info((Object)"Start check if recovery job completed,kubeSn: %s, jobName: %s, lastUpdateTimestamp: %s, stage: %s", new Object[]{kubeSn, jobName, lastUpdateTimestamp, stage});
        Optional optional = KubeResourceUtil.getKubeHandler().getKubeRecoveryJobByName(kubeSn, jobName);
        if (optional.isPresent()) {
            KubeRecoveryJob job = (KubeRecoveryJob)optional.get();
            if (StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Failed")) {
                LOGGER.warn((Object)"Recovery job failed. kubeSn: %s, job info: %s", new Object[]{kubeSn, job});
                return true;
            }
            if (StringUtils.equals((CharSequence)job.getStatus(), (CharSequence)"Completed") && StringUtils.equals((CharSequence)job.getStage(), (CharSequence)stage) && !StringUtils.equals((CharSequence)lastUpdateTimestamp, (CharSequence)job.getLastUpdateTimestamp())) {
                LOGGER.info((Object)"Recovery job completed. kubeSn: %s, jobName: %s, lastUpdateTimestamp: %s, stage: %s, new stage: %s, new state: %s", new Object[]{kubeSn, jobName, lastUpdateTimestamp, stage, job.getStage(), job.getStatus()});
                return true;
            }
            LOGGER.info((Object)"Recovery job is still processing. kubeSn: %s, jobName: %s, lastUpdateTimestamp: %s, stage: %s, job info: %s", new Object[]{kubeSn, jobName, lastUpdateTimestamp, stage, job});
        }
        return false;
    }

    public static boolean checkIfReProtectionJobComplete(String kubeSn, String jobName) {
        Optional optional = KubeResourceUtil.getKubeHandler().getKubeReProtectionJob(kubeSn, jobName);
        if (optional.isPresent()) {
            KubeReProtectionJob job = (KubeReProtectionJob)optional.get();
            return StringUtils.equals((CharSequence)job.getStage(), (CharSequence)"Finished") && StringUtils.equals((CharSequence)job.getState(), (CharSequence)"Completed") || StringUtils.equals((CharSequence)job.getState(), (CharSequence)"Failed");
        }
        return false;
    }

    private static IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }
}

