/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Arrays;

public class CertificateOperateStatus
implements Serializable {
    public static final String SUCCESS_STATUS = "00000000";
    public static final String FAILED_STATUS = "11111111";
    public static final String RUNNING_STATUS = "22222222";
    public static final String ERROR_PARAM = "00000005";
    public static final String ERROR_TOKEN = "00000009";
    private static final long serialVersionUID = 4222606984463645100L;
    private static final Log logger = LogFactory.getInstance(CertificateOperateStatus.class);
    private String resultCode;
    private String errorMsg;
    @JsonIgnore
    private String certName;

    public CertificateOperateStatus() {
    }

    public CertificateOperateStatus(String resultCode, String errorMsg) {
        this.resultCode = resultCode;
        this.errorMsg = errorMsg;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getCertName() {
        return this.certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public CertificateOperateStatus name(String name) {
        this.certName = name;
        return this;
    }

    public boolean failure() {
        return !Arrays.asList(SUCCESS_STATUS, RUNNING_STATUS).contains(this.resultCode);
    }

    public LegoCheckedException exception() {
        return new LegoCheckedException(-1L, this.errorMsg);
    }

    public static CertificateOperateStatus success() {
        return new CertificateOperateStatus(SUCCESS_STATUS, null);
    }

    public static CertificateOperateStatus failed(String message) {
        CertificateOperateStatus.error(message);
        return new CertificateOperateStatus(FAILED_STATUS, message);
    }

    public static CertificateOperateStatus running(String message) {
        CertificateOperateStatus.log(message);
        return new CertificateOperateStatus(RUNNING_STATUS, message);
    }

    public static CertificateOperateStatus errorParam(String message) {
        CertificateOperateStatus.error(message);
        return new CertificateOperateStatus(ERROR_PARAM, message);
    }

    public static CertificateOperateStatus errorToken(String message) {
        CertificateOperateStatus.error(message);
        return new CertificateOperateStatus(ERROR_TOKEN, message);
    }

    private static void log(String message) {
        if (message != null) {
            logger.info((Object)message);
        }
    }

    private static void error(String message) {
        if (message != null) {
            logger.error((Object)message);
        }
    }
}

