/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant;

import java.util.Optional;

public final class AntiBlackMailEnumDefine {
    private AntiBlackMailEnumDefine() {
    }

    public static enum DetectionStatus {
        NO_DETECT(-1),
        PREPARING(0),
        DETECTING(1),
        UN_INFECTED(2),
        INFECTED(3),
        ABNORMAL(4);

        private final int value;

        private DetectionStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Optional<DetectionStatus> getDetectionStatus(int value) {
            for (DetectionStatus detectionStatus : DetectionStatus.values()) {
                if (detectionStatus.getValue() != value) continue;
                return Optional.of(detectionStatus);
            }
            return Optional.empty();
        }
    }

    public static enum ReplicaDetectionStatusEnum {
        NOT_SUPPORT(-1, "replica.detection.status.not.support"),
        ABNORMAL(0, "replica.detection.status.abnormal"),
        READY(1, "replica.detection.status.ready.detection"),
        SCANNING(2, "replica.detection.status.scanning"),
        PARTIALLY_INFECTED(3, "replica.detection.status.partially.infected"),
        ALL_INFECTED(4, "replica.detection.status.all.infected"),
        UNINFECTED(5, "replica.detection.status.uninfected"),
        NO_DETECT(6, "replica.detection.status.not.detection"),
        QUEUING(7, "replica.detection.status.queuing"),
        UNKNOWN(8, "replica.detection.status.unknown");

        private final int value;
        private final String desc;

        private ReplicaDetectionStatusEnum(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }

        public static Optional<ReplicaDetectionStatusEnum> getDetectionStatusEnum(int value) {
            for (ReplicaDetectionStatusEnum detectionStatusEnum : ReplicaDetectionStatusEnum.values()) {
                if (detectionStatusEnum.getValue() != value) continue;
                return Optional.of(detectionStatusEnum);
            }
            return Optional.empty();
        }

        public static String getDetectionStatusEnumDesc(int value) {
            Optional<ReplicaDetectionStatusEnum> detectionStatusEnum = ReplicaDetectionStatusEnum.getDetectionStatusEnum(value);
            if (detectionStatusEnum.isPresent()) {
                return detectionStatusEnum.get().getDesc();
            }
            return String.valueOf(value);
        }
    }

    public static enum OceanProtectTaskTypeEnum {
        COPY_DELETE("COPY_DELETE"),
        MANUAL_SCAN_ENVIRONMENT("ManualScanEnvironment"),
        MANUAL_SCAN_RESOURCE("job_type_manual_scan_resource");

        private final String value;

        private OceanProtectTaskTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Optional<OceanProtectTaskTypeEnum> getTaskType(String value) {
            for (OceanProtectTaskTypeEnum type : OceanProtectTaskTypeEnum.values()) {
                if (!type.getValue().equals(value)) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }
    }

    public static enum OceanProtectTaskStatusEnum {
        RUNNING("RUNNING"),
        PENDING("PENDING"),
        READY("READY"),
        ABORTING("ABORTING"),
        SUCCESS("SUCCESS"),
        PARTIAL_SUCCESS("PARTIAL_SUCCESS"),
        FAIL("FAIL"),
        CANCELLED("CANCELLED"),
        ABORT_FAILED("ABORT_FAILED"),
        ABORTED("ABORTED"),
        ABNORMAL("ABNORMAL");

        private final String value;

        private OceanProtectTaskStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum PlatformType {
        OCEAN_PROTECT("Ocean Protect");

        private final String value;

        private PlatformType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

