/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.detect;

import com.huawei.ism.drm.site.sdk.model.DrResource;

public class ResourceDetectedEvent<R extends DrResource, D> {
    private R resource;
    private long timestamp;
    private D data;

    ResourceDetectedEvent(R resource, long timestamp, D data) {
        this.resource = resource;
        this.timestamp = timestamp;
        this.data = data;
    }

    public static <R extends DrResource, D> ResourceDetectedEventBuilder<R, D> builder() {
        return new ResourceDetectedEventBuilder();
    }

    public R getResource() {
        return this.resource;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public D getData() {
        return this.data;
    }

    public void setResource(R resource) {
        this.resource = resource;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setData(D data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceDetectedEvent)) {
            return false;
        }
        ResourceDetectedEvent other = (ResourceDetectedEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        R this$resource = this.getResource();
        R other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        D this$data = this.getData();
        D other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceDetectedEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        R $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        D $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceDetectedEvent(resource=" + this.getResource() + ", timestamp=" + this.getTimestamp() + ", data=" + this.getData() + ")";
    }

    public static class ResourceDetectedEventBuilder<R extends DrResource, D> {
        private R resource;
        private long timestamp;
        private D data;

        ResourceDetectedEventBuilder() {
        }

        public ResourceDetectedEventBuilder<R, D> resource(R resource) {
            this.resource = resource;
            return this;
        }

        public ResourceDetectedEventBuilder<R, D> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ResourceDetectedEventBuilder<R, D> data(D data) {
            this.data = data;
            return this;
        }

        public ResourceDetectedEvent<R, D> build() {
            return new ResourceDetectedEvent<R, D>(this.resource, this.timestamp, this.data);
        }

        public String toString() {
            return "ResourceDetectedEvent.ResourceDetectedEventBuilder(resource=" + this.resource + ", timestamp=" + this.timestamp + ", data=" + this.data + ")";
        }
    }
}

