/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.replica.sdk.service;

import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaStorageConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReplicaStorageConverterManager {
    private static ReplicaStorageConverterManager instance;
    private Map<String, IReplicaStorageConverter> converterMap = new ConcurrentHashMap<String, IReplicaStorageConverter>();

    private ReplicaStorageConverterManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicaStorageConverterManager getInstance() {
        Class<ReplicaStorageConverterManager> clazz = ReplicaStorageConverterManager.class;
        synchronized (ReplicaStorageConverterManager.class) {
            if (instance == null) {
                instance = new ReplicaStorageConverterManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addConverter(IReplicaStorageConverter converter) {
        String key = converter.getReplicaStorageClasss().getSimpleName();
        if (this.converterMap.containsKey(key)) {
            this.converterMap.remove(key);
        }
        this.converterMap.put(key, converter);
    }

    public void removerConverter(IReplicaStorageConverter converter) {
        this.converterMap.remove(converter.getReplicaStorageClasss().getSimpleName());
    }

    public IReplicaStorageConverter getConverter(String convertName) {
        IReplicaStorageConverter converter = this.converterMap.get(convertName);
        if (converter == null) {
            String errorMsg = "connot get converter by " + convertName;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return converter;
    }
}

