/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RecoveryProcessResult {
    private Map<String, Boolean> processesData = new ConcurrentHashMap<String, Boolean>();

    public static String getSyncProcessResultKey(String replicationId, String srcDeviceId, String tgtDeviceId, int relationType) {
        StringBuilder builder = new StringBuilder();
        builder.append("Sync:");
        builder.append("ReplicationId=");
        builder.append(replicationId);
        builder.append(";");
        builder.append("SrcDeviceId=");
        builder.append(srcDeviceId);
        builder.append(";");
        builder.append("TgtDeviceId=");
        builder.append(tgtDeviceId);
        builder.append(";");
        builder.append("RelationType=");
        builder.append(relationType);
        return builder.toString();
    }

    public static String getSwapProcessResultKey(String replicationId, String srcDeviceId, String tgtDeviceId, int relationType) {
        StringBuilder builder = new StringBuilder();
        builder.append("Swap:");
        builder.append("ReplicationId=");
        builder.append(replicationId);
        builder.append(";");
        builder.append("SrcDeviceId=");
        builder.append(srcDeviceId);
        builder.append(";");
        builder.append("TgtDeviceId=");
        builder.append(tgtDeviceId);
        builder.append(";");
        builder.append("RelationType=");
        builder.append(relationType);
        return builder.toString();
    }

    public static String getDisableTargetResourceProcResultKey(String replicationId, String srcDeviceId, String tgtDeviceId, int relationType) {
        StringBuilder builder = new StringBuilder();
        builder.append("DisableTgtReource:");
        builder.append("ReplicationId=");
        builder.append(replicationId);
        builder.append(";");
        builder.append("SrcDeviceId=");
        builder.append(srcDeviceId);
        builder.append(";");
        builder.append("TgtDeviceId=");
        builder.append(tgtDeviceId);
        builder.append(";");
        builder.append("RelationType=");
        builder.append(relationType);
        return builder.toString();
    }

    public static String getMappingLunProcResultKey(String lunId, String lunWWN, String hostMoId, String deviceId) {
        StringBuilder builder = new StringBuilder();
        builder.append("Mapping:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append("null");
        builder.append(";");
        builder.append("WWN=");
        builder.append(lunWWN);
        builder.append(";");
        builder.append("HostMOId=");
        builder.append(hostMoId);
        return builder.toString();
    }

    public static String getMappingLunProcResultKey(String lunId, String snapshotId, String snapshotWWN, String hostMoId, String deviceId) {
        StringBuilder builder = new StringBuilder();
        builder.append("Mapping:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append(snapshotId);
        builder.append(";");
        builder.append("WWN=");
        builder.append(snapshotWWN);
        builder.append(";");
        builder.append("HostMOId=");
        builder.append(hostMoId);
        return builder.toString();
    }

    public static String getStartupDBProcResultKey(String poId) {
        StringBuilder builder = new StringBuilder();
        builder.append("StartupDB:");
        builder.append("poId=");
        builder.append(poId);
        return builder.toString();
    }

    public static String getTestConnDBProcResultKey(String instanceName) {
        StringBuilder builder = new StringBuilder();
        builder.append("TestConnDB:");
        builder.append("InstanceName=");
        builder.append(instanceName);
        return builder.toString();
    }

    public static String getMountFilePorcResultKey(String hostSN, String lunId, String storageSN, String mountPoint) {
        StringBuilder builder = new StringBuilder();
        builder.append("MountLUN:");
        builder.append("LUNId=");
        builder.append(lunId);
        builder.append(";StorageSN=");
        builder.append(storageSN);
        builder.append(";HostSN=");
        builder.append(hostSN);
        builder.append(";MountPoint=");
        builder.append(mountPoint);
        return builder.toString();
    }

    public static String getUmountFilePorcResultKey(String hostSN, String lunId, String storageSN, String mountPoint) {
        StringBuilder builder = new StringBuilder();
        builder.append("UmountLUN:");
        builder.append("LUNId=");
        builder.append(lunId);
        builder.append(";StorageSN=");
        builder.append(storageSN);
        builder.append(";hostSN=");
        builder.append(hostSN);
        builder.append(";MountPoint=");
        builder.append(mountPoint);
        return builder.toString();
    }

    public boolean getUmountFilePorcResultByLunId(String hostSN, String lunId, String storageSN) {
        StringBuilder builder = new StringBuilder();
        builder.append("UmountLUN:");
        builder.append("LUNId=");
        builder.append(lunId);
        builder.append(";StorageSN=");
        builder.append(storageSN);
        builder.append(";hostSN=");
        builder.append(hostSN);
        String preKey = builder.toString();
        int matchedCount = 0;
        if (VerifyUtil.isEmpty(this.processesData)) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : this.processesData.entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.startsWith(preKey)) continue;
            if (!entry.getValue().booleanValue()) {
                return false;
            }
            ++matchedCount;
        }
        return matchedCount != 0;
    }

    public static String getCopySnapshotProcResultkey(String deviceId, String lunId) {
        StringBuilder builder = new StringBuilder();
        builder.append("CopySnapshot:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        return builder.toString();
    }

    public static String getActiveSnapshotProcResultKey(String deviceId, String pgId) {
        StringBuilder builder = new StringBuilder();
        builder.append("ActiveSnapshot:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("PgID=");
        builder.append(pgId);
        return builder.toString();
    }

    public static String getDataConsistencyCheckingResultKey(String deviceId, String lunId) {
        StringBuilder builder = new StringBuilder();
        builder.append("CheckDataConsistency:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        return builder.toString();
    }

    public static String getUnMappingSnapshotProcResultKey(String lunId, String snapshotId, String hostMoId, String deviceId) {
        StringBuilder builder = new StringBuilder();
        builder.append("UnMapping:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append(snapshotId);
        builder.append(";");
        builder.append("HostMOId=");
        builder.append(hostMoId);
        return builder.toString();
    }

    public static String getStopAppProcResultKey(String poId) {
        StringBuilder builder = new StringBuilder();
        builder.append("StopApp:");
        builder.append("PoId=");
        builder.append(poId);
        return builder.toString();
    }

    public static String getDeleteSnapshotProcResultKey(String deviceId, String lunId, String snapshotId) {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteSnapshot:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append(snapshotId);
        return builder.toString();
    }

    public Map<String, Boolean> getMappingProcessResults() {
        return this.getProcessResults("Mapping");
    }

    public Map<String, Boolean> getProcessResults(String prefix) {
        HashMap<String, Boolean> procResults = new HashMap<String, Boolean>();
        Set<String> keys = this.processesData.keySet();
        if (keys == null || keys.isEmpty()) {
            return procResults;
        }
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            procResults.put(key, this.getProcessResult(key));
        }
        return procResults;
    }

    public void addProcessResult(String key, boolean result) {
        this.processesData.put(key, result);
    }

    public boolean getSyncProcResult(String replicationId, String srcDeviceId, String tgtDeviceId, int relationType) {
        String key = RecoveryProcessResult.getSyncProcessResultKey(replicationId, srcDeviceId, tgtDeviceId, relationType);
        Boolean result = this.processesData.get(key);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean getSwapProcResult(String replicationId, String srcDeviceId, String tgtDeviceId, int relationType) {
        String key = RecoveryProcessResult.getSwapProcessResultKey(replicationId, srcDeviceId, tgtDeviceId, relationType);
        Boolean result = this.processesData.get(key);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean getMappingLunProcResult(String lunId, String lunWWN, String hostMoId, String deviceId) {
        String key = RecoveryProcessResult.getMappingLunProcResultKey(lunId, lunWWN, hostMoId, deviceId);
        Boolean result = this.processesData.get(key);
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean getStopAppProcResult(String poId) {
        String key = RecoveryProcessResult.getStopAppProcResultKey(poId);
        Boolean result = this.processesData.get(key);
        if (result == null) {
            return false;
        }
        return result;
    }

    public Map<String, Boolean> getStopAppProcResults() {
        HashMap<String, Boolean> stopAppProcResults = new HashMap<String, Boolean>();
        Set<String> keys = this.processesData.keySet();
        if (keys == null || keys.isEmpty()) {
            return stopAppProcResults;
        }
        HashSet<String> toProcessedKeySet = new HashSet<String>();
        for (String key : keys) {
            if (!key.startsWith("StopApp:")) continue;
            toProcessedKeySet.add(key);
        }
        for (String key : toProcessedKeySet) {
            this.processesData.put(key, this.getProcessResult(key));
        }
        return this.processesData;
    }

    public boolean getProcessResult(String key) {
        Boolean result = this.processesData.get(key);
        if (result == null) {
            return false;
        }
        return result;
    }

    public Boolean getValue(String key) {
        return this.processesData.get(key);
    }

    public DrmEnumDefine.RecoveryPlanExecuteResultE calcProcessResult() {
        int successCount = 0;
        Collection<Boolean> results = this.processesData.values();
        for (Boolean result : results) {
            if (!result.booleanValue()) continue;
            ++successCount;
        }
        DrmEnumDefine.RecoveryPlanExecuteResultE procResult = successCount == 0 ? DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED : (successCount == results.size() ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS);
        return procResult;
    }

    public static String getPoRecoveryStatusKey(int procType, String poId, int poType) {
        StringBuilder key = new StringBuilder();
        key.append("PoRecoveryStatus:");
        key.append(procType);
        key.append(":");
        key.append(poId);
        key.append(":");
        key.append(poType);
        return key.toString();
    }

    public static String getRollbackSnapshotResultKey(String deviceId, String lunId, String snapshotId) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rollback:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append(snapshotId);
        return builder.toString();
    }

    public static String getRollbackBackupResultKey(String deviceId, String lunId, String backupId) {
        StringBuilder builder = new StringBuilder();
        builder.append("Rollback:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("backupId=");
        builder.append(backupId);
        return builder.toString();
    }

    public static String getCheckRollbackSnapshotResultKey(String deviceId, String lunId, String snapshotId) {
        StringBuilder builder = new StringBuilder();
        builder.append("CheckRollback:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        builder.append(";");
        builder.append("SnapshotId=");
        builder.append(snapshotId);
        return builder.toString();
    }

    public Map<String, Boolean> getCheckRollbackSnapshotResult() {
        HashMap<String, Boolean> checkRollbackProcResults = new HashMap<String, Boolean>();
        Set<String> keys = this.processesData.keySet();
        if (keys == null || keys.isEmpty()) {
            return checkRollbackProcResults;
        }
        for (String key : keys) {
            if (!key.startsWith("CheckRollback:")) continue;
            checkRollbackProcResults.put(key, this.getProcessResult(key));
        }
        return checkRollbackProcResults;
    }

    public static String getRebuildOracleAppResultKey(String poId) {
        StringBuilder builder = new StringBuilder();
        builder.append("RebuildOracleApp:");
        builder.append("poId=");
        builder.append(poId);
        return builder.toString();
    }

    public static String getStopASMProcResultKey(String hostSN, String instanceName) {
        StringBuilder builder = new StringBuilder();
        builder.append("StopASM:");
        builder.append("HostSN=");
        builder.append(hostSN);
        builder.append(";");
        builder.append("InstanceName=");
        builder.append(instanceName);
        return builder.toString();
    }

    public static String getCreateSnapshotProcResultKey(String deviceId, String lunId) {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateSnapshot:");
        builder.append("DeviceId=");
        builder.append(deviceId);
        builder.append(";");
        builder.append("LunID=");
        builder.append(lunId);
        return builder.toString();
    }
}

