/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.sdk.service;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.manager.sdk.model.ControlCluster;
import com.huawei.ism.drm.storage.manager.sdk.model.StorageHyperMetroDomain;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroGroup;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.HypermetroPair;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="storageHyperMetroManagerProxy")
public interface IStorageHyperMetroBaseManager
extends IStorageManager {
    public static final Log LOGGER = LogFactory.getInstance(IStorageHyperMetroBaseManager.class);
    public static final List<Long> PAIR_NOT_EXIST_ERROR_CODE = ImmutableList.of((Object)37100039L, (Object)1077674242L);

    default public String getVersion() {
        return "";
    }

    default public HyperMetroPair queryHyperMetroPair(String devSn, String pairId, String vstoreId) {
        throw new UnsupportedOperationException();
    }

    public List<HyperMetroPair> queryHyperMetroPairsByCg(String var1, String var2);

    default public HyperMetroConsistentGroup queryHyperMetroCGroup(String devSn, String cgId) {
        throw new UnsupportedOperationException();
    }

    public List<QuorumServerLink> queryQuorumServerLinks(String var1, String var2);

    public void synchronize(String var1, String var2, boolean var3, String var4);

    public void disable(String var1, String var2, DrmEnumDefine.RoleType var3, boolean var4, String var5);

    public void swap(String var1, String var2, Integer var3, boolean var4);

    public void startup(String var1, String var2);

    public void shutdown(String var1, String var2);

    public List<HyperMetroPair> queryHyperMetroPairs(String var1, String var2);

    default public List<HypermetroPair> queryHypermetroPairs(String devSn, String controlClusterId, String domainId, Map<String, String> filters) {
        return null;
    }

    default public HypermetroPair queryHypermetroPair(String devSn, String controlClusterId, String pairId) {
        throw new UnsupportedOperationException();
    }

    default public HypermetroPair createHypermetroPair(HypermetroPair hypermetroPair) {
        throw new UnsupportedOperationException();
    }

    default public void pauseHypermetroPair(String srcDevSn, String controlClusterId, String pairId, Boolean isPrimary) {
        throw new UnsupportedOperationException();
    }

    default public void deleteHypermetroPair(String srcDevSn, String controlClusterId, String pairId, Boolean isLocalDelete) {
        throw new UnsupportedOperationException();
    }

    default public List<StorageHyperMetroDomain> queryHypermetroDomain(String devSn, String remoteSn, String controlClusterId) {
        return Collections.emptyList();
    }

    default public List<ControlCluster> queryControlClusters(String devSn) {
        return Collections.emptyList();
    }

    default public List<RemoteDevice> queryRemoteDevices(String devSn) {
        return Collections.emptyList();
    }

    default public HypermetroGroup createHypermetroCGroup(HypermetroGroup hypermetroGroup) {
        throw new UnsupportedOperationException();
    }

    default public HypermetroGroup updateHypermetroCGroup(HypermetroGroup hypermetroGroup) {
        throw new UnsupportedOperationException();
    }

    default public HypermetroGroup queryHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        throw new UnsupportedOperationException();
    }

    default public void deleteHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        throw new UnsupportedOperationException();
    }

    default public void pausedHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId, Boolean isPrimary) {
        throw new UnsupportedOperationException();
    }

    default public void startHypermetroCGroup(String srcDevSn, String controlClusterId, String cgId) {
        throw new UnsupportedOperationException();
    }

    default public void addHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        throw new UnsupportedOperationException();
    }

    default public void removeHypermetroPairs(HypermetroGroup hypermetroGroup, List<HypermetroPair> pairs) {
        throw new UnsupportedOperationException();
    }

    default public List<HypermetroPair> getHypermetroPairsByCgId(String devSn, String controlClusterId, String cgId) {
        throw new UnsupportedOperationException();
    }

    default public void swapHyperMetroPair(String devSn, String controlClusterId, String pairId) {
    }

    default public boolean isAccordantExpectForRunningStatus(String value, String key) {
        throw new UnsupportedOperationException();
    }

    default public List<HypermetroPair> getLocalHyperMetroPairs(String srcDevSn, Set<String> lunIds) {
        return new ArrayList<HypermetroPair>();
    }

    default public boolean isHypermetroPairStatusAvailable(HypermetroPair pair) {
        return false;
    }

    default public boolean isHyperMetroPairStatusAvailable(HypermetroPair pair, List<String> normalRunningStatusList, List<String> normalHealthStatusList) {
        VerifyUtil.checkObject((Object)((Object)pair));
        if (!normalRunningStatusList.contains(pair.getRunningStatus())) {
            LOGGER.error((Object)"The hyperMetroPair running status error, pairId is %s, running status is %s.", new Object[]{pair.getId(), pair.getRunningStatus()});
            return false;
        }
        if (!normalHealthStatusList.contains(pair.getHealthstatus())) {
            LOGGER.error((Object)"The hyperMetroPair health status error, pairId is %s, health status is %s.", new Object[]{pair.getId(), pair.getHealthstatus()});
            return false;
        }
        return true;
    }

    public static boolean isPairNotExistException(LegoCheckedException exception) {
        if (PAIR_NOT_EXIST_ERROR_CODE.contains(exception.getErrorCode())) {
            return true;
        }
        String errMsg = exception.getMessage();
        if (VerifyUtil.isEmpty((String)errMsg)) {
            return false;
        }
        for (Long errorCode : PAIR_NOT_EXIST_ERROR_CODE) {
            if (!errMsg.contains(String.valueOf(errorCode))) continue;
            return true;
        }
        return false;
    }
}

