/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.drm.storage.sdk.model.LicenseFunctionBaseItem;
import com.huawei.ism.drm.storage.sdk.model.LicenseUsageInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class StorageLicense
implements Serializable {
    private static final long serialVersionUID = 6394209485621768080L;
    private static final Log LOGGER = LogFactory.getInstance(StorageLicense.class);
    private static final int FEATURE_ON = 1;
    private static final int FEATURE_OFF = 0;
    @JsonProperty(value="LibVer")
    private String libVer;
    @JsonProperty(value="FileExist")
    private String fileExist;
    @JsonProperty(value="CreatedTime")
    private String createdTime;
    @JsonProperty(value="LicenseSerialNo")
    private String licenseSerialNo;
    @JsonProperty(value="licenseType")
    private String licenseType;
    @JsonProperty(value="LicenseFunction")
    private List<LicenseFunctionBaseItem> functionItemList;
    @JsonProperty(value="LicenseUsageInfo")
    private List<LicenseUsageInfo> usageInfoList;

    public String getLibVer() {
        return this.libVer;
    }

    public void setLibVer(String libVer) {
        this.libVer = libVer;
    }

    public String getFileExist() {
        return this.fileExist;
    }

    public void setFileExist(String fileExist) {
        this.fileExist = fileExist;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getLicenseSerialNo() {
        return this.licenseSerialNo;
    }

    public void setLicenseSerialNo(String licenseSerialNo) {
        this.licenseSerialNo = licenseSerialNo;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public List<LicenseFunctionBaseItem> getFunctionItemList() {
        return this.functionItemList;
    }

    public void setFunctionItemList(List<LicenseFunctionBaseItem> functionItemList) {
        this.functionItemList = functionItemList;
    }

    public List<LicenseUsageInfo> getUsageInfoList() {
        return this.usageInfoList;
    }

    public void setUsageInfoList(List<LicenseUsageInfo> usageInfoList) {
        this.usageInfoList = usageInfoList;
    }

    @JsonIgnore
    public boolean isSupportFeature(String featureId) {
        if (this.functionItemList == null || this.functionItemList.isEmpty()) {
            return false;
        }
        List items = this.functionItemList.stream().filter(item -> featureId.equals(item.getFeatureId()) && item.getFuncSwitch() == 1).collect(Collectors.toList());
        return items != null && !items.isEmpty();
    }

    @JsonIgnore
    public boolean isSupportFeatureAndInTime(String featureId) {
        if (VerifyUtil.isEmpty(this.functionItemList)) {
            return false;
        }
        List items = this.functionItemList.stream().filter(item -> featureId.equals(item.getFeatureId()) && item.getFuncSwitch() == 1 && this.checkRunTime(item.getRunTime())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(items)) {
            LOGGER.error((Object)"Current license is out time.");
            return false;
        }
        return true;
    }

    private boolean checkRunTime(String runTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String runTimeWithSecond = runTime + " 23:59:59";
        try {
            Date runTimeDate = sdf.parse(runTimeWithSecond);
            Date now = new Date();
            return runTimeDate.compareTo(now) > 0;
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Parse runTime failed, current license is out time. runTimeWithSecond =%s", new Object[]{runTimeWithSecond});
            return false;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Current license is out time. e=%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
    }

    public void disableFeature(String featureId) {
        List items = this.functionItemList.stream().filter(item -> featureId.equals(item.getFeatureId())).collect(Collectors.toList());
        if (items == null || items.isEmpty()) {
            return;
        }
        LicenseFunctionBaseItem item2 = (LicenseFunctionBaseItem)items.stream().findFirst().get();
        item2.setFuncSwitch(0);
    }

    public void addFeature(String featureId, String runTime) {
        if (this.functionItemList == null || this.functionItemList.isEmpty()) {
            this.functionItemList = new ArrayList<LicenseFunctionBaseItem>();
        }
        LicenseFunctionBaseItem item = new LicenseFunctionBaseItem();
        item.setFuncSwitch(1);
        item.setFeatureId(featureId);
        item.setRunTime(runTime);
        this.functionItemList.add(item);
    }
}

