/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ParamChecker {
    public static final String RESOURCES_SN_REGEX = "^[\\w-.:/_]+$";
    public static final int RESOURCES_SN_MAX_LENGTH = 256;
    public static final int DEFAULT_MIN_LENGTH = 1;
    public static final String GENERAL_ID_REGEX = "^[\\w-.:]+$";
    public static final int GENERAL_ID_MAX_LENGTH = 128;
    public static final String ALARM_KEY_REGEX = "^[\\w-.:/]+$";
    public static final int GENERAL_TEXT_MAX_LENGTH = 255;
    public static final int LONG_TEXT_MAX_LENGTH = 0x100000;
    public static final String UUID_REGEX = "^[0-9a-fA-F]{8}([0-9a-fA-F]{4}){3}[0-9a-fA-F]{12}$";
    public static final String BASE64_REGEX = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    public static final int BASE64_MAX_LENGTH = 0x100000;
    public static final String REGION_ID_REGEX = "^[a-zA-Z]+-[a-zA-Z]+-[1-9][0-9]*$";
    public static final int REGION_ID_MAX_LENGTH = 32;
    public static final String AZ_ID_REGEX = "^[a-z0-9]([a-z0-9-]{0,48}[a-z0-9])?(\\.[a-z0-9]([a-z0-9-]{0,48}[a-z0-9])?)?$";
    public static final int AZ_ID_MAX_LENGTH = 101;
    public static final String SESSION_ID_REGEX = "^[\\w-.:=,]+$";
    public static final int SESSION_ID_MAX_LENGTH = 512;
    public static final String VOLUME_TYPE_REGEX = "^[\\u4e00-\\u9fa5\\w-.]+$";
    public static final int VOLUME_TYPE_MAX_LENGTH = 255;
    public static final String NAME_QUERY_REGEX = "^[\\u4e00-\\u9fa5\\w-.:\\s%]+$";
    public static final int NAME_QUERY_MAX_LENGTH = 1024;
    public static final String IP_QUERY_REGEX = "^[a-fA-F0-9.:]+$";
    public static final int IP_QUERY_MAX_LENGTH = 63;
    public static final String URL_REGEX = "^[a-zA-Z]+://[^\\s]*$";
    public static final int URL_MAX_LENGTH = 2048;
    public static final String MO_NAME_REGEX = "^[\\u4e00-\\u9fa5\\w-.:\\s]*$";
    public static final int MO_NAME_MAX_LENGTH = 128;

    public static boolean checkList(String listString, Predicate<String> checker, int maxLength) {
        return VerifyUtil.isEmpty((String)listString) || ParamChecker.checkList(listString.split(","), checker, maxLength);
    }

    public static <T> boolean checkList(T[] list, Predicate<T> checker, int maxLength) {
        if (VerifyUtil.isEmpty((Object[])list)) {
            return true;
        }
        return list.length <= maxLength && Arrays.stream(list).allMatch(checker);
    }

    public static <T> boolean checkList(Collection<T> list, Predicate<T> checker, int maxLength) {
        if (VerifyUtil.isEmpty(list)) {
            return true;
        }
        return list.size() <= maxLength && list.stream().allMatch(checker);
    }

    public static <T> Optional<String> checkNotEmptyParam(Map<String, T> params, Predicate<T> checker) {
        return params.entrySet().stream().flatMap(entry -> ParamChecker.checkNotEmptyParam((String)entry.getKey(), entry.getValue(), checker).map(Stream::of).orElseGet(Stream::empty)).findFirst();
    }

    public static <T> Optional<String> checkNotEmptyParam(String paramName, T param, Predicate<T> checker) {
        if (VerifyUtil.isEmpty(param)) {
            return Optional.of(String.format(Locale.ENGLISH, "%s is empty!", paramName));
        }
        if (!checker.test(param)) {
            return Optional.of(String.format(Locale.ENGLISH, "%s is incorrect!", paramName));
        }
        return Optional.empty();
    }

    public static boolean checkAlarmKey(String param) {
        return CommUtil.checkParam(param, ALARM_KEY_REGEX, 1, 128);
    }

    public static boolean checkGeneralId(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, GENERAL_ID_REGEX, 1, 128);
    }

    public static boolean checkGeneralText(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, 255);
    }

    public static boolean checkLongText(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, 0x100000);
    }

    public static boolean checkUuid(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, UUID_REGEX);
    }

    public static boolean checkBase64(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, BASE64_REGEX, 1, 0x100000);
    }

    public static boolean checkRegionId(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, REGION_ID_REGEX, 1, 32);
    }

    public static boolean checkAzId(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, AZ_ID_REGEX, 1, 101);
    }

    public static boolean checkSessionId(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, SESSION_ID_REGEX, 1, 512);
    }

    public static boolean checkVolumeType(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, VOLUME_TYPE_REGEX, 1, 255);
    }

    public static boolean checkNameQuery(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, NAME_QUERY_REGEX, 1, 1024);
    }

    public static boolean checkIpQuery(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, IP_QUERY_REGEX, 1, 63);
    }

    public static boolean checkUrl(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, URL_REGEX, 1, 2048);
    }

    public static boolean checkMoName(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, MO_NAME_REGEX, 1, 128);
    }

    public static boolean checkResourcesSn(String param) {
        return VerifyUtil.isEmpty((String)param) || CommUtil.checkParam(param, RESOURCES_SN_REGEX, 1, 256);
    }

    public static boolean checkUuidNotNull(String param) {
        return !VerifyUtil.isEmpty((String)param) && CommUtil.checkParam(param, UUID_REGEX);
    }
}

