/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.HyperClone;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class DrmStorageUtil {
    private static final Log logger = LogFactory.getInstance(DrmStorageUtil.class);

    private DrmStorageUtil() {
    }

    public static String generateMoUuid(String id, String moType, String deviceId) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[deviceID=");
        strBuilder.append(deviceId);
        strBuilder.append(", moType=");
        strBuilder.append(moType);
        strBuilder.append(", id=");
        strBuilder.append(id);
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static String generateTargetLunMoUuid(String id, String moType, String ownerDeviceId, String tgtDeviceId, String replicationPairId) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[deviceID=");
        strBuilder.append(ownerDeviceId);
        strBuilder.append(", moType=");
        strBuilder.append(moType);
        strBuilder.append(", id=");
        strBuilder.append(id);
        strBuilder.append(", tgtDeviceId=");
        strBuilder.append(tgtDeviceId);
        strBuilder.append(", replicationPairId=");
        strBuilder.append(replicationPairId);
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static Lun getStorageLunById(String deviceId, String lunId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        props.put("lunId", lunId);
        List groups = CommonDAOLocator.getMoDao().findMoBy(Lun.class, props);
        if (null == groups || groups.isEmpty() || groups.size() != 1) {
            return null;
        }
        return (Lun)groups.get(0);
    }

    public static List<ReplicationRelation> getReplicationRelations(String deviceId, int replicationType) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceId);
        props.put("relationType", replicationType);
        List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
        return groups;
    }

    public static List<ReplicationPair> getReplicationPairs(String deviceId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceId);
        props.put("relationType", 0);
        List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        return groups;
    }

    public static List<ReplicationTargetLun> getReplicationTargetLunsByDevId(String deviceId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, props);
        return groups;
    }

    public static String generateTestSnapshotName(String planId, String lunId) {
        String planIdSuffix = planId.substring(planId.length() - 3, planId.length());
        StringBuilder builder = new StringBuilder();
        builder.append("RD_Test-");
        builder.append(System.currentTimeMillis());
        builder.append("_");
        builder.append(planIdSuffix);
        builder.append("_");
        builder.append(lunId);
        return builder.toString();
    }

    public static String generateRecoverySnapshotName(String lunId) {
        StringBuilder builder = new StringBuilder();
        builder.append("DRdata_");
        builder.append(lunId);
        builder.append("_");
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String time = df.format(new Date());
        builder.append(time);
        builder.append(UUID.randomUUID().toString(), 0, 2);
        builder.append("_BAK");
        return builder.toString();
    }

    public static void saveOrUpdateHyperClone(String deviceSn, HyperClone hyperClone) {
        if (VerifyUtil.isEmpty((String)deviceSn) || null == hyperClone) {
            logger.error((Object)"DeviceSn is null or hyperClone is null.");
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List results = moDao.find("from StorageUnit where devSn=?", new Object[]{deviceSn});
        if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) {
            logger.error((Object)("The storage unit does not exist. devSn:" + deviceSn + ",Result:" + VerifyUtil.isEmpty((Collection)results)));
            return;
        }
        StorageUnit storageUnit = (StorageUnit)results.get(0);
        hyperClone.setParentMo((ManagedObject)storageUnit);
        hyperClone.setIsTopMo(Boolean.valueOf(false));
        hyperClone.setTopMoUuid(storageUnit.getTopMoUuid());
        try {
            moDao.saveOrUpdateMo((ManagedObject)hyperClone);
        }
        catch (Exception e) {
            logger.error((Object)("Saving hyper clone failed. devSn:" + deviceSn + ",Id:" + hyperClone.getId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static void saveOrUpdateHyperCloneTargetLun(String deviceSn, HyperCloneTargetLun targetLun) {
        if (VerifyUtil.isEmpty((String)deviceSn) || null == targetLun) {
            logger.debug((Object)"deviceSn or targetlun null ,not save Or Update HyperCloneTargetLun");
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List results = moDao.find("from StorageUnit where devSn=?", new Object[]{deviceSn});
        if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) {
            logger.error((Object)("The storage unit does not exist. devSn:" + deviceSn + ",Result:" + VerifyUtil.isEmpty((Collection)results)), 90160758784001L);
            return;
        }
        StorageUnit storageUnit = (StorageUnit)results.get(0);
        String hyperCloneUuid = new XveUUID(deviceSn, XveMOType.SPLITMIRROR, targetLun.getHyperCloneId()).toString();
        results = moDao.find("from HyperClone where uuid=?", new Object[]{hyperCloneUuid});
        if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) {
            logger.error((Object)("The hyper clone does not exist. uuid:" + hyperCloneUuid + ",Result:" + VerifyUtil.isEmpty((Collection)results)), 90160758784001L);
            return;
        }
        HyperClone hyperCloneInDB = (HyperClone)results.get(0);
        targetLun.setParentMo((ManagedObject)hyperCloneInDB);
        targetLun.setIsTopMo(Boolean.valueOf(false));
        targetLun.setTopMoUuid(storageUnit.getTopMoUuid());
        try {
            moDao.saveOrUpdateMo((ManagedObject)targetLun);
        }
        catch (Exception e) {
            logger.error((Object)("Saving hyper clone targetlun failed. devSn:" + deviceSn + ",CloneId:" + targetLun.getHyperCloneId() + ",PairId:" + targetLun.getPairId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static void saveOrUpdateMoAndDeleteOldMo(IMoDao moDao, List<? extends ManagedObject> newMos, List<? extends ManagedObject> oldMos) {
        if (VerifyUtil.isEmpty(newMos) && VerifyUtil.isEmpty(oldMos)) {
            logger.debug((Object)"newMos null or oldMos null,not save Or UpdateMoAndDeleteOldMo");
            return;
        }
        HashMap<String, Long> uuidAndMoIdMap = new HashMap<String, Long>();
        if (!VerifyUtil.isEmpty(oldMos)) {
            for (ManagedObject managedObject : oldMos) {
                uuidAndMoIdMap.put(managedObject.getUuid(), managedObject.getMoId());
            }
        }
        if (!VerifyUtil.isEmpty(newMos)) {
            for (ManagedObject managedObject : newMos) {
                uuidAndMoIdMap.remove(managedObject.getUuid());
                DrmStorageUtil.saveOrUpdateMO(managedObject, moDao);
            }
        }
        if (!uuidAndMoIdMap.isEmpty()) {
            moDao.deleteMoList(new ArrayList(uuidAndMoIdMap.values()));
        }
    }

    private static void saveOrUpdateMO(ManagedObject mo, IMoDao moDao) {
        if (null == mo || null == moDao) {
            return;
        }
        mo.setRecentUpdateTime(new Timestamp(System.currentTimeMillis()));
        ManagedObject oldMo = moDao.getMoByUuid(mo.getUuid(), null);
        if (null == oldMo) {
            moDao.save((Object)mo);
        } else {
            moDao.evict((Object)oldMo);
            moDao.update((Object)mo);
        }
    }

    public static void setPropMap(Map<String, Map<String, String>> propMap, List<?> results) {
        if (!VerifyUtil.isEmpty(results)) {
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || (values = (Object[])object).length < 3) continue;
                String id = CommUtil.convertToString((Object)values[0]);
                String propName = CommUtil.convertToString((Object)values[1]);
                String propValue = CommUtil.convertToString((Object)values[2]);
                Map<String, String> map = propMap.get(id);
                if (VerifyUtil.isEmpty(map)) {
                    map = new HashMap<String, String>();
                    propMap.put(id, map);
                }
                map.put(propName, propValue);
            }
        }
    }

    public static List<ReplicationTargetLun> getTargetLunsByReplicationId(String deviceId, String replicationId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceId);
        props.put("replicationPairId", replicationId);
        List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, props);
        return groups;
    }

    public static JSONObject getJsonObject(Map<String, List<StoragePool>> deviceStoragePool, Map.Entry<String, List<DrStorage>> entry, Site site) {
        JSONObject siteObj = new JSONObject();
        siteObj.put((Object)"siteId", (Object)site.getSiteId());
        siteObj.put((Object)"siteName", (Object)site.getName());
        JSONArray storagesArray = new JSONArray();
        List<DrStorage> list = entry.getValue();
        for (DrStorage drStorage : list) {
            List<StoragePool> storagePoolList = deviceStoragePool.get(drStorage.getDeviceSn());
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(storagePoolList)) continue;
            JSONObject drStorageObject = new JSONObject();
            drStorageObject.put((Object)"deviceSn", (Object)drStorage.getDeviceSn());
            drStorageObject.put((Object)"deviceName", (Object)drStorage.getName());
            JSONArray poolsArray = new JSONArray();
            for (StoragePool storagePool : storagePoolList) {
                JSONObject poolObject = new JSONObject();
                poolObject.put((Object)"poolId", (Object)storagePool.getPoolId());
                poolObject.put((Object)"poolName", (Object)storagePool.getName());
                poolsArray.add((Object)poolObject);
            }
            drStorageObject.put((Object)"pools", (Object)poolsArray);
            storagesArray.add((Object)drStorageObject);
        }
        siteObj.put((Object)"storages", (Object)storagesArray);
        return siteObj;
    }

    public static List<ReplicationRelation> getReplicationRelationsByCgId(String deviceId, String cgId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceId);
        props.put("relationType", 1);
        props.put("replicationId", cgId);
        return CommonDAOLocator.getMoDao().findMoBy(ReplicationRelation.class, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getReplicationRelationsSrcLunIds(String deviceId, int replicationType) {
        List list;
        Session session;
        block4: {
            ArrayList<String> arrayList;
            session = null;
            try {
                session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
                String deleteSQL = "select rp.srcLunId from TI_REPLICATIONPAIR rp inner join TI_REPLICATIONRELATION rr on rp.moId = rr.moId where rr.devSn =:devSn and rr.relationType =:relationType";
                NativeQuery query = session.createNativeQuery(deleteSQL);
                query.setParameter("devSn", (Object)deviceId);
                query.setParameter("relationType", (Object)replicationType);
                list = query.list();
                if (!VerifyUtil.isEmpty((Collection)list)) break block4;
                arrayList = new ArrayList<String>();
            }
            catch (Exception e) {
                ArrayList<String> arrayList2;
                try {
                    logger.error((Object)("GetUnsynchronizedRecoveryLogs failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                    arrayList2 = new ArrayList<String>();
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
                return arrayList2;
            }
            DBOperationUtil.closeSession(session);
            return arrayList;
        }
        DBOperationUtil.closeSession(session);
        return list;
    }

    public static List<String> getReplicationTargetLunIdsByDevId(String deviceId) {
        List objects = CommonDAOLocator.getMoDao().find("from ReplicationTargetLun where devSn = ?", new Object[]{deviceId});
        if (VerifyUtil.isEmpty((Collection)objects)) {
            return new ArrayList<String>();
        }
        return objects.stream().map(ReplicationTargetLun::getTgtLunId).collect(Collectors.toList());
    }

    public static void saveAndUpdateMo(IMoDao moDao, List<? extends ManagedObject> newMos, List<? extends ManagedObject> oldMos) {
        if (VerifyUtil.isEmpty(newMos) && VerifyUtil.isEmpty(oldMos)) {
            logger.debug((Object)" newMos null or oldMos null,not save Or UpdateMoAndDeleteOldMo");
            return;
        }
        HashMap<String, Long> uuidAndMoIdMap = new HashMap<String, Long>();
        HashMap<String, ManagedObject> moMap = new HashMap<String, ManagedObject>();
        if (!VerifyUtil.isEmpty(oldMos)) {
            for (ManagedObject managedObject : oldMos) {
                uuidAndMoIdMap.put(managedObject.getUuid(), managedObject.getMoId());
                moMap.put(managedObject.getUuid(), managedObject);
            }
        }
        if (!VerifyUtil.isEmpty(newMos)) {
            for (ManagedObject managedObject : newMos) {
                DrmStorageUtil.saveOrUpdateMO(managedObject, moDao);
            }
        }
    }
}

