/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;

public class SiteUtil {
    private static final Log LOG = LogFactory.getInstance(SiteUtil.class);

    public static RestClient initClient(Site site) {
        if (site == null) {
            LOG.error((Object)"Site is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = SiteUtil.getServer(site.getServerUuid());
        RestClient client = new RestClient(server.getIp(), NumberUtil.convertToInteger((Object)server.getPort()).intValue(), server.getUser(), server.getPwd());
        if (Ipv6AddressUtil.isIPv6Address((String)client.getIp())) {
            client.setIp(Ipv6AddressUtil.convertIpv6((String)client.getIp()));
        }
        return client;
    }

    public static RestClient initClient(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            LOG.error((Object)"siteId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
        if (site == null) {
            LOG.error((Object)"site is null.");
            throw new LegoCheckedException(2117645L);
        }
        RestClient client = SiteUtil.initClient(site);
        return client;
    }

    public static RestClient initClient(ManagementServer server) {
        if (server == null) {
            LOG.error((Object)"server is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)server.getUuid());
        if (replica == null) {
            throw new LegoCheckedException(2117645L);
        }
        RestClient client = new RestClient(replica.getIp(), NumberUtil.convertToInteger((Object)replica.getPort()).intValue(), replica.getUser(), replica.getPwd());
        return client;
    }

    public static RestClient initClientByServerUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            LOG.error((Object)"uuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        if (replica == null) {
            throw new LegoCheckedException(2117645L);
        }
        RestClient client = new RestClient(replica.getIp(), NumberUtil.convertToInteger((Object)replica.getPort()).intValue(), replica.getUser(), replica.getPwd());
        return client;
    }

    private static ManagementServer getServer(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            LOG.error((Object)"uuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer server = (ManagementServer)CommonDAOLocator.getMoDao().getMo(ManagementServer.class, "uuid", (Object)uuid);
        if (server == null) {
            LOG.error((Object)"server is empty.");
            throw new LegoCheckedException(2117645L);
        }
        return server;
    }
}

