/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.concurrent;

import com.huawei.ism.drm.base.util.concurrent.ThreadPoolConfig;
import com.huawei.ism.drm.base.util.concurrent.ThreadPoolFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;

public class ThreadPoolHelper {
    private static final Log LOGGER = LogFactory.getInstance(ThreadPoolHelper.class);
    private static final int DEFAULT_KEEP_ALIVE_TIME = 60;

    public static <T> void synBatchExecute(ThreadPoolConfig config, Collection<T> source, Consumer<T> executor) {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolFactory.getThreadPool(config);
        CountDownLatch downLatch = new CountDownLatch(source.size());
        source.forEach(src -> threadPoolExecutor.submit(() -> {
            try {
                executor.accept(src);
            }
            finally {
                downLatch.countDown();
            }
        }));
        try {
            downLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Execute task error.%s", new Object[]{config.getName()});
            throw new LegoCheckedException("Execute task error." + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public static ThreadPoolConfig defaultConfig(String legoConfigName, int defaultThreadCount) {
        LegoBaseConfig.updateInstance();
        String threadCountValue = LegoBaseConfig.getInstance().getKeyValue(legoConfigName);
        int threadCount = VerifyUtil.isEmpty((String)threadCountValue) ? defaultThreadCount : Integer.parseInt(threadCountValue);
        ThreadPoolConfig config = new ThreadPoolConfig();
        config.setName(legoConfigName);
        config.setCorePoolSize(threadCount);
        config.setMaximumPoolSize(threadCount);
        config.setKeepAliveTime(60L);
        config.setAllowCoreThreadTimeOut(true);
        return config;
    }
}

