/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.dao;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.function.Consumer;
import org.hibernate.Session;

public class SessionUtil {
    private static final Log logger = LogFactory.getInstance(SessionUtil.class);

    public static void clearSessionCache(Session session, ProtectGroup pg) {
        if (session == null || pg == null) {
            return;
        }
        SessionUtil.evict(session).accept(pg);
        if (!VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            pg.getPolist().forEach(SessionUtil.evict(session));
        }
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            pg.getReplicaList().forEach(SessionUtil.evict(session));
        }
        if (!VerifyUtil.isEmpty((Collection)pg.getPgHistoryLogs())) {
            pg.getPgHistoryLogs().forEach(SessionUtil.evict(session));
        }
        if (!VerifyUtil.isEmpty((Object)pg.getTemplate())) {
            if (!VerifyUtil.isEmpty((Collection)pg.getTemplate().getSchedules())) {
                pg.getTemplate().getSchedules().forEach(SessionUtil.evict(session));
            }
            SessionUtil.evict(session).accept(pg.getTemplate());
        }
    }

    private static <T> Consumer<T> evict(Session session) {
        return item -> {
            if (session.contains(item)) {
                logger.debug((Object)"evict class :%s", new Object[]{item.getClass()});
                session.evict(item);
            }
        };
    }
}

