/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.drm.cert.sdk.service.command.INodeAgentCommand;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class NodeAgentCommand
implements INodeAgentCommand {
    private String commandName;
    private boolean crossMode;
    private long errorCode;
    private List<String> arguments = Collections.emptyList();
    private NodeAgentLocalService.Iface nodeAgentLocalService;

    public NodeAgentCommand(String commandName, boolean crossMode, long errorCode, List<String> arguments) {
        this.commandName = commandName;
        this.crossMode = crossMode;
        this.errorCode = errorCode;
        this.arguments = Optional.ofNullable(arguments).orElse(Collections.emptyList());
    }

    public String getCommandName() {
        return this.commandName;
    }

    public boolean isCrossMode() {
        return this.crossMode;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public NodeAgentLocalService.Iface getNodeAgentLocalService() {
        return this.nodeAgentLocalService;
    }

    public void setNodeAgentLocalService(NodeAgentLocalService.Iface nodeAgentLocalService) {
        this.nodeAgentLocalService = nodeAgentLocalService;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = Optional.ofNullable(arguments).orElse(Collections.emptyList());
    }

    public static NodeAgentCommand create(String config, long errorCode) {
        List<String> commandArgs;
        String commandHead;
        int index = config.indexOf(58);
        if (index < 0) {
            commandHead = config;
            commandArgs = Collections.emptyList();
        } else {
            commandHead = config.substring(0, index);
            commandArgs = Arrays.asList(config.substring(index + 1).split(","));
        }
        boolean crossMode = commandHead.startsWith("#");
        String commandName = crossMode ? commandHead.substring(1) : commandHead;
        return new NodeAgentCommand(commandName, crossMode, errorCode, commandArgs);
    }
}

