/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.detect;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.detect.ResourceEventDetector;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.query.Query;

public abstract class AbstractStorageEventDetector<D>
extends ResourceEventDetector<DrStorage, D> {
    private final String managementProtocol;

    public AbstractStorageEventDetector(String managementProtocol) {
        this.managementProtocol = Objects.requireNonNull(managementProtocol);
    }

    public boolean check(DrStorage storage) {
        return HibernateUtil.call(this::check, storage);
    }

    private boolean check(Session session, DrStorage storage) {
        Query query = session.createQuery("from StorageNE where sn=:sn", StorageNE.class);
        query.setParameter("sn", (Object)storage.getDeviceSn());
        StorageNE storageNE = (StorageNE)query.uniqueResult();
        return this.checkStorage(storageNE);
    }

    protected boolean checkStorage(StorageNE storageNE) {
        return this.managementProtocol.equals(storageNE.getManagementProtocol());
    }
}

