/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.AbstractProtectionRecoveryService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanSyncService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.recovery.framework.plugin.IRecoveryPlanPlugin;
import com.huawei.ism.drm.recovery.framework.plugin.RecoveryPlanPluginUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryPlanUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractRecoveryPlanService
extends AbstractProtectionRecoveryService
implements IRecoveryPlanBaseService {
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryPlanService.class);
    private static final long MAX_RECOVERY_PLAN_NUM = 2000L;
    private static final Object RECOVERY_PLAN_LOCK = new Object();
    protected List<IRecoveryPlanCreateEventHandler> recoveryPlanCreateEventHandlers = new ArrayList<IRecoveryPlanCreateEventHandler>();
    private IBizScopeManager bizScopeManager;
    private IRecoveryPlanSyncService recoveryPlanSyncService;

    public IBizScopeManager getBizScopeManager() {
        return this.bizScopeManager;
    }

    public void setBizScopeManager(IBizScopeManager bizScopeManager) {
        this.bizScopeManager = bizScopeManager;
    }

    public IRecoveryPlanSyncService getRecoveryPlanSyncService() {
        return this.recoveryPlanSyncService;
    }

    public void setRecoveryPlanSyncService(IRecoveryPlanSyncService recoveryPlanSyncService) {
        this.recoveryPlanSyncService = recoveryPlanSyncService;
    }

    public void addRecoveryPlanCreateEventHandler(IRecoveryPlanCreateEventHandler handler, Map<String, Object> props) {
        if (handler != null && !this.recoveryPlanCreateEventHandlers.contains(handler)) {
            this.recoveryPlanCreateEventHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryPlan(long userId, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String planId = UUIDGenerator.getUUID();
        recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue());
        recoveryPlan.setPlanId(planId);
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            planId = this.createRecoveryPlan(userId, recoveryPlan, true);
        }
        this.createRecoveryPlanAfterAction(recoveryPlan);
        return planId;
    }

    public String createRecoveryPlan(long userId, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        return this.createRecoveryPlan(userId, recoveryPlan, isNeedSyncCreate, false);
    }

    /*
     * Exception decompiling
     */
    private String createRecoveryPlan(long userId, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate, boolean supportMultiPlan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Session createRecoveryPlanMainMethod(RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        Set processes;
        IRecoveryPlanPlugin plugin = RecoveryPlanPluginUtil.getPlugin(RecoveryPlanUtil.getPoTypeFromRecovery(recoveryPlan));
        if (plugin != null) {
            plugin.beforeCreate(recoveryPlan);
        }
        if (isNeedSyncCreate) {
            processes = RecoveryServiceUtil.getInitRecoveryProcessDefinitions(recoveryPlan);
            recoveryPlan.setProcessesSerialMsg(DrmObjectSerializableUtil.serializableObj(processes));
        } else {
            String planSerialMsg = recoveryPlan.getProcessesSerialMsg();
            processes = DrmObjectSerializableUtil.reverseObj(planSerialMsg, Set.class);
        }
        this.recoveryPlanSyncService.createRecoveryPlanFromRemote(recoveryPlan, isNeedSyncCreate);
        this.initRecoveryPlan(recoveryPlan, processes);
        Session session = this.getHibernateSession();
        session.beginTransaction();
        session.save((Object)recoveryPlan);
        this.updatePoRecoveryStatus((Set<ProtectGroup>)recoveryPlan.getProtectGroups(), DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED, session);
        if (this.recoveryPlanCreateEventHandlers != null) {
            for (IRecoveryPlanCreateEventHandler handler : this.recoveryPlanCreateEventHandlers) {
                HibernateUtil.execute(() -> handler.handle(recoveryPlan), session);
            }
        }
        session.save((Object)recoveryPlan);
        session.getTransaction().commit();
        return session;
    }

    protected abstract void initRecoveryPlan(RecoveryPlan var1, Set<RecoveryProcessDefinition> var2);

    protected abstract void checkRecoveryPlanForCreate(RecoveryPlan var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMultiRecoveryPlan(long userId, RecoveryPlan recoveryPlan) {
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            String planId = UUIDGenerator.getUUID();
            recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue());
            recoveryPlan.setPlanId(planId);
            return this.createRecoveryPlan(userId, recoveryPlan, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRpBasicInfo(String planId, Integer planUse, String planName, String planDesc) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planName)) {
            logger.error((Object)"The parameter is null. PlanId:%s,PlanName:%s.", new Object[]{planId, planName, 90160758784001L});
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            RecoveryPlan recoveryPlan;
            if (this.isExistedRecoveryPlanByName(planName, planId, planUse)) {
                logger.error((Object)"The plan name already exists. PlanName:%s,PlanId:%s.", new Object[]{planName, planId, 90160758784001L});
                throw new LegoCheckedException(1073947392L);
            }
            if (this.isExistedRecoveryPlanById(planId)) {
                recoveryPlan = this.getRecoveryPlan(planId);
                if (recoveryPlan == null) {
                    logger.error((Object)"The recovery plan does not exist. PlanId:%s.", new Object[]{planId, 90160758784001L});
                    throw new LegoCheckedException(1073947394L);
                }
            } else {
                logger.error((Object)"The recovery plan does not exist. PlanId:%s,PlanName:%s.", new Object[]{planId, planName, 90160758784001L});
                throw new LegoCheckedException(201L);
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO);
            recoveryPlan.setName(planName);
            recoveryPlan.setDescription(planDesc);
            IRecoveryPlanSyncService siteService = (IRecoveryPlanSyncService)ServiceLocator.getInstance().getService(IRecoveryPlanSyncService.class);
            siteService.modifyRecoveryPlanFromRemote(recoveryPlan);
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
    }

    public void modifyRpExtendInfo(RecoveryPlan oldPlan, RecoveryPlan newPlan) {
        IRecoveryPlanPlugin plugin = RecoveryPlanPluginUtil.getPlugin(RecoveryPlanUtil.getPoTypeFromRecovery(oldPlan));
        if (plugin != null) {
            plugin.beforeModify(oldPlan, newPlan);
        }
    }

    public void saveOrUpdateGlobalSettings(String planId, Map<String, Object> globalSettings) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId) || globalSettings == null) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        this.saveOrUpdateGlobalSettings(recoveryPlan, globalSettings);
    }

    private void saveOrUpdateGlobalSettings(RecoveryPlan recoveryPlan, Map<String, Object> globalSettings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanGlobalSetting(recoveryPlan, globalSettings);
        try {
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateGlobalSettings failed.", (long)-1L, null, (Log)logger);
        }
    }

    private void resetRecoveryPlanGlobalSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        HashMap<String, String> globalSetting = recoveryPlan.getGlobalSettings();
        if (VerifyUtil.isEmpty(settings)) {
            globalSetting = new HashMap<String, String>();
            recoveryPlan.setGlobalSettings(globalSetting);
            return;
        }
        Set<Map.Entry<String, Object>> entrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            globalSetting.put(key, String.valueOf(value));
        }
    }

    public void saveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!this.checkRecoverySettings(planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)"IRecoveryProcessProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        provider.checkRecoverySettings(settings);
        RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, null);
        this.saveOrUpdateRecoverySettings(recoveryPlan, settings);
        this.recoveryPlanSyncService.syncRecoverySettingsToRemote(recoveryPlan, settings);
        IRecoveryPlanSyncService siteService = (IRecoveryPlanSyncService)ServiceLocator.getInstance().getService(IRecoveryPlanSyncService.class);
        siteService.syncRecoverySettingsToRemote(recoveryPlan, planId, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateRecoverySettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanSettings(recoveryPlan, settings);
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            for (RecoverySetting recoverySetting : recoveryPlan.getRecoverySettings()) {
                session.saveOrUpdate((Object)recoverySetting);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void resetRecoveryPlanSettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(settings)) {
            return;
        }
        Set preSettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting setting : settings) {
            boolean isExisted = false;
            for (RecoverySetting preSetting : preSettings) {
                if (!setting.getRecoveryPlan().getPlanId().equals(preSetting.getRecoveryPlan().getPlanId()) || !setting.getOwnerId().equals(preSetting.getOwnerId()) || !setting.getName().equals(preSetting.getName())) continue;
                preSetting.setValue(setting.getValue());
                isExisted = true;
            }
            if (isExisted) continue;
            preSettings.add(setting);
        }
    }

    public List<RecoveryPlan> getAllRecoveryPlan() {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList();
        try {
            recoveryPlans = this.getBaseDao().getHibernateTemplate().find("from RecoveryPlan", new Object[0]);
            return recoveryPlans;
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery plans failed,error is %s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            return recoveryPlans;
        }
    }

    public List<RecoveryPlan> getAllRecoveryPlan(long userId) {
        logger.debug((Object)"getAllRecoveryPlan");
        List recoveryPlans = this.getAllRecoveryPlan();
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(recoveryPlans)) {
            recoveryPlans = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userId), recoveryPlans);
        }
        return recoveryPlans;
    }

    public boolean isUsedProtectGroupByRp(String pgId) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"Invalid parameter,pgId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (protectGroup == null) {
            logger.error((Object)"ProtectGroup(%s) not exist", new Object[]{pgId});
            throw new LegoCheckedException(1073947394L);
        }
        String planId = this.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
        return !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId);
    }

    public boolean isUsedProtectGroupByAllRp(String pgId) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)pgId)) {
            String errMsg = "pgId is empty.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947393L, new String[]{pgId});
        }
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (protectGroup == null) {
            String errMsg = "ProtectGroup is not exist.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947394L, new String[]{pgId});
        }
        List<String> list = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroup.getUuid(), new ArrayList<Integer>());
        return !com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoverySetting> getRecoverySettings(String planId, String itemKey) {
        ArrayList<RecoverySetting> settings = new ArrayList<RecoverySetting>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHql = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.name=:itemKey";
            Query query = session.createQuery(queryHql);
            query.setParameter("planId", (Object)planId);
            query.setParameter("itemKey", (Object)itemKey);
            List results = query.list();
            if (results != null && !results.isEmpty()) {
                for (Object result : results) {
                    settings.add((RecoverySetting)result);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying recovery settings failed. Id:%s,key:%s,error :%s.", new Object[]{planId, itemKey, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverySetting getRecoverySetting(String planId, String ownerId, String itemKey) {
        RecoverySetting recoverySetting = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHql = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.ownerId=:ownerId and RS.name=:itemKey";
            Query query = session.createQuery(queryHql);
            query.setParameter("planId", (Object)planId);
            query.setParameter("ownerId", (Object)ownerId);
            query.setParameter("itemKey", (Object)itemKey);
            List results = query.list();
            if (results != null && results.size() == 1) {
                recoverySetting = (RecoverySetting)results.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying recovery settings failed. Id:%s,key:%s,error :%s.", new Object[]{planId, itemKey, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoverySetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RecoveryProcessDefinition> getRecoveryProcesses(String recoveryPlanId, int procType) {
        Set<RecoveryProcessDefinition> processes;
        Session session = null;
        try {
            session = this.getHibernateSession();
            processes = this.getRecoveryProcesses(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType), session);
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery process failed. PlanId:%s,error :%s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            processes = new HashSet<RecoveryProcessDefinition>();
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return processes;
    }

    protected Set<RecoveryProcessDefinition> getRecoveryProcesses(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, false, false);
        if (recoveryPlan == null) {
            logger.error((Object)"The recovery plan does not exist.PlanId:%s.", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcesses(session, recoveryPlan, type);
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(Session session, RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        List recoveryProcesses;
        String planId = recoveryPlan.getPlanId();
        HashSet<RecoveryProcessDefinition> processes = new HashSet<RecoveryProcessDefinition>();
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (protectGroup == null) {
            logger.error((Object)"The protectGroup does not exist.PlanId:%s.", new Object[]{planId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        if (planId == null || session == null) {
            return processes;
        }
        String queryHql = "from RecoveryProcessDefinition rproc where rproc.planId=:planId";
        if (type != null) {
            queryHql = queryHql + " and rproc.procType=:procType";
        }
        Query query = session.createQuery(queryHql);
        query.setParameter("planId", (Object)planId);
        if (type != null) {
            query.setParameter("procType", (Object)type.getValue());
        }
        if ((recoveryProcesses = query.list()) != null && !recoveryProcesses.isEmpty()) {
            for (Object obj : recoveryProcesses) {
                RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)obj;
                Set<RecoveryProcessor> recoveryProcessors = AbstractRecoveryPlanService.getRecoveryProcessors(rpDefinition.getProcessId(), type, session);
                for (RecoveryProcessor processor : recoveryProcessors) {
                    processor.resetEnableStatus(recoveryPlan, type);
                }
                rpDefinition.setRecoveryProcessors(recoveryProcessors);
                processes.add(rpDefinition);
            }
        }
        return processes;
    }

    public List<RecoveryProcessor> getRecoveryProcessors(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryProcessDefinition rpDefinition;
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId) || procType == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Set<RecoveryProcessDefinition> rpDefinitions = this.getRecoveryProcesses(planId, procType.getValue());
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(rpDefinitions)) {
            IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
            RecoveryPlan plan = this.getRecoveryPlanWithProcess(planId);
            rpDefinition = recoveryManager.createRecoveryProcessDefinition(plan, procType);
        } else {
            Iterator<RecoveryProcessDefinition> iterator = rpDefinitions.iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            rpDefinition = iterator.next();
        }
        if (rpDefinition == null) {
            logger.error((Object)"The process definition does not exist.");
            throw new LegoCheckedException(1073947394L);
        }
        List<RecoveryProcessor> sortedProcessors = RecoveryServiceUtil.sortRecoveryProcessors(rpDefinition.getRecoveryProcessors());
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor processor : sortedProcessors) {
            RecoveryProcessor newProcessor = this.getRecoveryProcessor(processor);
            processors.add(newProcessor);
        }
        return processors;
    }

    protected static Set<RecoveryProcessor> getRecoveryProcessors(String processId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        List recoveryProcessors;
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (processId == null || session == null) {
            return processors;
        }
        String queryHql = "from RecoveryProcessor rProcessor where rProcessor.processId=:processId and rProcessor.parentProc is null";
        if (type != null) {
            queryHql = queryHql + " and rProcessor.procType=:procType";
        }
        Query query = session.createQuery(queryHql);
        query.setParameter("processId", (Object)processId);
        if (type != null) {
            query.setParameter("procType", (Object)type.getValue());
        }
        if ((recoveryProcessors = query.list()) != null && !recoveryProcessors.isEmpty()) {
            for (Object obj : recoveryProcessors) {
                processors.add((RecoveryProcessor)obj);
            }
        }
        return processors;
    }

    protected abstract RecoveryProcessor getRecoveryProcessor(RecoveryProcessor var1);

    protected void constructionBaseProcessor(RecoveryProcessor newProcessor, RecoveryProcessor processor) {
        if (newProcessor == null) {
            newProcessor = new RecoveryProcessor();
        }
        newProcessor.setPlanId(processor.getPlanId());
        newProcessor.setProcId(processor.getProcId());
        newProcessor.setProcType(processor.getProcType());
        newProcessor.setIsEditable(processor.getIsEditable());
        newProcessor.setIsEnabled(processor.getIsEnabled());
        newProcessor.setIsPreset(processor.getIsPreset());
        processor.updateProcessName();
        processor.updateDescription();
        newProcessor.setProcName(processor.getProcName());
        newProcessor.setDescription(processor.getDescription());
        newProcessor.setProcessId(processor.getProcessId());
    }

    public String getAssociatedRecoveryPlanWithProtectGroup(String protectGroupId) {
        ArrayList<Integer> planUseNotIn = new ArrayList<Integer>();
        planUseNotIn.add(RecoveryPlanUse.INTERNAL_USE.getValue());
        List<String> planIds = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroupId, planUseNotIn);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(planIds)) {
            return null;
        }
        return planIds.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAssociatedRecoveryPlanListWithProtectGroup(String protectGroupId, List<Integer> planUseNotIn) {
        Session session = null;
        try {
            List planIds;
            session = this.getHibernateSession();
            String querySql = "select PLANID from ti_drp_r_pg where PGID=:pgId";
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(planUseNotIn)) {
                querySql = "select r.PLANID from ti_drp_r_pg r left join ti_recoveryplan l  on r.PLANID = l.PLANID where r.PGID=:pgId";
                StringBuilder sb = new StringBuilder();
                sb.append(" and l.PLANUSE not in(");
                for (int index = 0; index < planUseNotIn.size(); ++index) {
                    sb.append(planUseNotIn.get(index));
                    if (index >= planUseNotIn.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(") ");
                querySql = querySql + sb.toString();
            }
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("pgId", (Object)protectGroupId);
            List list = planIds = query.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery plan associated with pg failed. PgId:%s,error :%s.", new Object[]{protectGroupId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public void setPoRepToRecoveryPlan(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"setPoRepToRecoveryPlan");
        Set pgSet = recoveryPlan.getProtectGroups();
        IReplicaBaseService replicaService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
        for (ProtectGroup pg : pgSet) {
            List queryProtectGroupReplicaByGroup = replicaService.queryProtectGroupReplicaByGroup(pg.getUuid(), "", true, null);
            pg.getReplicaList().clear();
            pg.getReplicaList().addAll(queryProtectGroupReplicaByGroup);
        }
    }

    protected Session getHibernateSession() {
        HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        return session;
    }

    public void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, Session session) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(protectGroups) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(poRecoveryStatusMap) || session == null) {
            logger.debug((Object)"not need updatePoRecoveryStatus exit null param.");
            return;
        }
        String updateSql = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where POID in (:poIds)";
        HashMap<Integer, List> groups = new HashMap<Integer, List>();
        for (ProtectGroup protectGroup : protectGroups) {
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatus = poRecoveryStatusMap.get(protectObject.getUuid());
                if (poRecoveryStatus == null) continue;
                List group = groups.computeIfAbsent(poRecoveryStatus.getValue(), k -> new ArrayList());
                group.add(protectObject.getUuid());
            }
        }
        for (Map.Entry entry : groups.entrySet()) {
            Integer poRecoveryStatus = (Integer)entry.getKey();
            List poIds = (List)entry.getValue();
            NativeQuery query = session.createSQLQuery(updateSql);
            query.setParameter("poRecoveryStatus", (Object)poRecoveryStatus);
            query.setParameterList("poIds", (Collection)poIds);
            query.executeUpdate();
        }
    }

    private void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatus, Session session) {
        String updateSql = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where PGID=:pgId";
        for (ProtectGroup pg : protectGroups) {
            NativeQuery query = session.createSQLQuery(updateSql);
            query.setParameter("poRecoveryStatus", (Object)poRecoveryStatus.getValue());
            query.setParameter("pgId", (Object)pg.getUuid());
            query.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        Session session = null;
        try {
            HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            session.beginTransaction();
            for (RecoveryLog recoveryLog : recoveryLogs) {
                recoveryLog.setIsSynchronized(Boolean.valueOf(true));
                session.saveOrUpdate((Object)recoveryLog);
                for (RecoveryProcessorDetail detail : recoveryLog.getRecoveryProcessDetails()) {
                    session.saveOrUpdate((Object)detail);
                }
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    protected Set<RecoveryProcessDefinition> constructRecoveryProcessDefinitions(List<?> result) {
        HashSet<RecoveryProcessDefinition> rpDefinitions = new HashSet<RecoveryProcessDefinition>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 6) continue;
            RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
            rpDefinition.setProcessId(CommUtil.convertToString((Object)values[0]));
            rpDefinition.setProcType(CommUtil.convertToInteger((Object)values[1]).intValue());
            rpDefinition.setAppType(CommUtil.convertToInteger((Object)values[2]).intValue());
            rpDefinition.setProtectionType(CommUtil.convertToInteger((Object)values[3]).intValue());
            rpDefinition.setPlanId(CommUtil.convertToString((Object)values[4]));
            rpDefinition.setDisasterSiteId(CommUtil.convertToString((Object)values[5]));
            rpDefinitions.add(rpDefinition);
        }
        return rpDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecoveryPlanExisted(String planId) {
        Session session;
        boolean isExsited;
        block4: {
            isExsited = false;
            session = null;
            try {
                String querySql = "select count(*) from ti_recoveryplan where planid=:planId";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySql);
                query.setParameter("planId", (Object)planId);
                List results = query.list();
                if (results == null || results.isEmpty()) break block4;
                isExsited = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Querying recovery plan failed. Id:%s,error :%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return isExsited;
    }

    private boolean checkRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(settings)) {
            return false;
        }
        for (RecoverySetting setting : settings) {
            RecoveryPlan plan = setting.getRecoveryPlan();
            if (plan != null && plan.getPlanId() != null && plan.getPlanId().equals(planId)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanById(String recoveryPlanId) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select PLANID from ti_recoveryplan where PLANID=:planId";
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("planId", (Object)recoveryPlanId);
            List recoveryPlans = query.list();
            if (recoveryPlans != null && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Checking whether the recovery plan existed failed. PlanId:%s,error :%s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRecoveryPlan(RecoveryPlan recoveryPlan) {
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            String deleteDetailSql = "delete from ti_recoveryprocessordetail where logid in (select logid from ti_recoverylog where planid=:planid)";
            NativeQuery sqlQuery = session.createSQLQuery(deleteDetailSql);
            sqlQuery.setString("planid", recoveryPlan.getPlanId());
            sqlQuery.executeUpdate();
            long startB = System.currentTimeMillis();
            session.delete((Object)recoveryPlan);
            long startC = System.currentTimeMillis();
            session.getTransaction().commit();
            long startD = System.currentTimeMillis();
            long startA = System.currentTimeMillis();
            logger.info((Object)"delete detail cost time:%s, delete cost time:%s, commit cost time:%s.", new Object[]{String.valueOf(startB - startA), String.valueOf(startC - startB), String.valueOf(startD - startC)});
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)("Deleting recovery plan failed. Id:" + recoveryPlan.getPlanId()), (long)1073948688L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    public void deleteRecoveryPlan(String recoveryPlanId, boolean isNeedSyncRemove) {
        long startA = System.currentTimeMillis();
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId, false, false);
        if (recoveryPlan == null) {
            logger.error((Object)"The recovery plan does not exist.PlanId:%s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        long startB = System.currentTimeMillis();
        logger.info((Object)"getRecoveryPlan cost time:%s", new Object[]{String.valueOf(startB - startA)});
        this.deleteRecoveryPlanExtendAction(recoveryPlan, isNeedSyncRemove);
        this.deleteRecoveryPlan(recoveryPlan);
        this.deleteRecoveryPlanAfterAction(recoveryPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExistedAssociatedRecoveryPlan(Set<ProtectGroup> protectGroups) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(protectGroups)) {
            logger.error((Object)"The parameter is invalid.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select a.PLANID from ti_drp_r_pg a left join ti_recoveryplan b on a.PLANID=b.PLANID where a.PGID=:pgId and b.PLANUSE !=" + RecoveryPlanUse.INTERNAL_USE.getValue();
            for (ProtectGroup protectGroup : protectGroups) {
                NativeQuery query = session.createSQLQuery(querySql);
                query.setParameter("pgId", (Object)protectGroup.getUuid());
                List results = query.list();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)results)) continue;
                isExisted = true;
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Getting associated recovery plan failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExisted;
    }

    protected void checkRecoveryPlanNumLimit(RecoveryPlan recoveryPlan) {
        int count = this.getValidRecoveryPlanNum();
        if ((long)count < 2000L) {
            return;
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (pg == null) {
            logger.error((Object)"ProtectGroup is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = pg.getProductSiteId();
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        List localSites = siteService.getAllLocalSites();
        Site productSite = siteService.getSiteById(productSiteId);
        boolean isProductLocal = localSites.contains(productSite);
        long errorCode = 1073948715L;
        if (isProductLocal) {
            errorCode = 1073948714L;
        }
        throw new LegoCheckedException(errorCode, new String[]{String.valueOf(2000L)});
    }

    protected void checkParameterValidityForCreate(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)recoveryPlan.getName()) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"ProtectGroup is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IProtectGroupBaseService protectGroupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        ProtectGroup persistentPg = protectGroupService.getProtectGroupByID(protectGroup.getUuid(), false);
        if (persistentPg.isInvalid()) {
            logger.error((Object)"Protect Group has been invalid. Id:%s.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073948693L);
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(persistentPg);
        if (provider == null) {
            logger.error((Object)"There is no matched provider. Id:%s.", new Object[]{protectGroup.getUuid()});
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isSanHyperVaultPolicytemplate(protectGroup)) {
            return;
        }
        boolean isMatched = provider.isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE.getType((int)recoveryPlan.getPlanType()), persistentPg);
        if (!isMatched) {
            logger.error((Object)"Protect Group is not matched for the specified plan type. Id:%s,PlanType:%s.", new Object[]{protectGroup.getUuid(), recoveryPlan.getPlanType()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected boolean isSanHyperVaultPolicytemplate(ProtectGroup protectGroup) {
        return PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValidRecoveryPlanNum() {
        Session session;
        int count;
        block4: {
            count = 0;
            session = null;
            try {
                Object obj;
                String querySql = "select count(*) from ti_recoveryplan where PLANSTATUS != -1 and PLANUSE = 0 ";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySql);
                List recoveryPlans = query.list();
                if (recoveryPlans == null || recoveryPlans.isEmpty() || !((obj = recoveryPlans.get(0)) instanceof BigInteger)) break block4;
                count = ((BigInteger)obj).intValue();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Checking back recovery task count failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return count;
    }

    public boolean checkNasRecoveryPlanInit() {
        return true;
    }

    public void saveOrUpdateRecoveryPlan(RecoveryPlan recoveryPlan) {
        try {
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateGlobalSettings failed.", (long)-1L, null, (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoveryPlan(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"Invalid parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)"begin to delete recovery plan %s.", new Object[]{recoveryPlanId});
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId, false, false);
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            IRecoveryPlanPlugin plugin = RecoveryPlanPluginUtil.getPlugin(RecoveryPlanUtil.getPoTypeFromRecovery(recoveryPlan));
            if (plugin != null) {
                plugin.beforeDelete(recoveryPlan);
            }
            this.deleteRecoveryPlan(recoveryPlanId, true);
        }
        this.bizScopeManager.deleteScopeObject(recoveryPlanId);
        logger.info((Object)"delete recovery plan %s success.", new Object[]{recoveryPlanId});
    }

    protected abstract void deleteRecoveryPlanExtendAction(RecoveryPlan var1, boolean var2);

    private void deleteRecoveryPlanAfterAction(RecoveryPlan recoveryPlan) {
        if (recoveryPlan.getPlanStatus() != DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue()) {
            return;
        }
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        protectGroup.setProperty("recovery_plan_abnormal_end", (Object)true);
        ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
    }

    private void createRecoveryPlanAfterAction(RecoveryPlan recoveryPlan) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        protectGroup.setProperty("recovery_plan_abnormal_end", (Object)false);
        ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).saveOrUpdateProtectGroupProps(protectGroup.getUuid(), protectGroup.getProps());
    }
}

