/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.LicenseOverflowStackControl;
import com.huawei.ism.drm.license.RDLicenseFactory;
import com.huawei.ism.drm.license.sdk.IDRVMPlatinicInter;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.license.sdk.ILicenseUseInter;
import com.huawei.ism.drm.license.sdk.LicenseBuffer;
import com.huawei.ism.drm.license.sdk.LicenseCalcBean;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.cbb.license.sdk.model.po.LicenseInfo;
import com.huawei.lego.cbb.license.util.LicensePolicyUtil;
import com.huawei.lego.cbb.license.util.TranslateLicenseModel;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.nodeagent.thrift.Command;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public abstract class AbstractLicManSdp
extends DrmBaseService
implements ILicenseInter {
    private static final Log logger = LogFactory.getInstance(AbstractLicManSdp.class);
    protected Map<String, List<ILicenseUseInter>> useServiceMap = new HashMap<String, List<ILicenseUseInter>>();
    private ISiteBaseService siteService = null;
    private IDRVMPlatinicInter vmPlatinicService = null;
    private NodeAgentLocalService.Iface nodeAgentAccessClient;

    public void onBindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = service;
        logger.info((Object)"onBindDRVMPlatinic->%s", new Object[]{this.vmPlatinicService});
    }

    public void onUnbindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = null;
        logger.info((Object)"onUnbindDRVMPlatinic->%s", new Object[]{service});
    }

    public boolean isDRVMPlatinic() {
        if (null == this.vmPlatinicService) {
            logger.debug((Object)"param is null");
            return false;
        }
        return this.vmPlatinicService.isDRVMPlatinic();
    }

    public String adaptiveLMHashEx(String src) {
        return null;
    }

    public LicenseInfoBo convert2LicBo(byte[] licFile) {
        logger.debug((Object)"convert2LicBo");
        return RDLicenseFactory.getInstance().convert2LicBo(licFile);
    }

    public void activateLic(byte[] licFile) {
        logger.debug((Object)"activateLic, param is licFile.");
        LicenseInfo licenseInfo = RDLicenseFactory.getInstance().activateLic(licFile);
        this.activateLic(licenseInfo);
        this.updateLicenseBuff(false);
        LicenseOverflowStackControl.getInstance().resetLicenseUsedItem();
        logger.debug((Object)"Clear alarm , alarm id:%s", new Object[]{String.valueOf(52625481L)});
        AlarmReporter.restoreAlarm(52625481L, "FLAG_SYSTEM_PROBATION_TIMEOUT_ALARM");
        ILicenseBaseControl licenseControl = (ILicenseBaseControl)ServiceLocator.getInstance().getService(ILicenseBaseControl.class);
        licenseControl.checkLicenseOutOfControlAlarm(true);
    }

    private void activateLic(LicenseInfo curLic) {
        logger.debug((Object)"activateLic, param is LicenseInfo.");
        Transaction tx = null;
        Session session = null;
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            if (session != null) {
                tx = session.beginTransaction();
                Query query = session.createQuery("delete from LicenseInfo");
                query.executeUpdate();
                session.save((Object)curLic);
                tx.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Exception", (Throwable)e, 90160758787071L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    private List<LicenseInfo> getAllLicense() {
        String queryString = "from LicenseInfo where inUse = ?";
        Boolean inUse = true;
        List licenseList = null;
        Session session = null;
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            if (session != null) {
                Transaction tx = session.beginTransaction();
                licenseList = session.createQuery(queryString).setBoolean(0, inUse.booleanValue()).list();
                tx.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Exception", (Throwable)e, 90160758787071L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return licenseList;
    }

    public LicenseInfoBo getLicenseNotUpdateUseNum() {
        LicenseInfoBo temp = LicenseBuffer.getInstance().getLicenseBuff();
        if (temp == null) {
            logger.debug((Object)"temp is null");
            this.updateLicenseBuff(true);
            temp = LicenseBuffer.getInstance().getLicenseBuff();
        }
        return temp;
    }

    public LicenseInfoBo getLicense() {
        LicenseInfoBo temp = this.getLicenseNotUpdateUseNum();
        if (temp == null) {
            logger.debug((Object)"temp is null");
            return temp;
        }
        if (temp.getFeaBolst() != null && !temp.getFeaBolst().isEmpty()) {
            for (FeatureBo fitem : temp.getFeaBolst()) {
                List resList = fitem.getReslst();
                this.countResUseNum(resList);
            }
        }
        return temp;
    }

    public void countResUseNum(List<ResourceItemBo> resList) {
        if (resList == null || resList.isEmpty()) {
            logger.error((Object)"resList is null.");
            return;
        }
        List<String> resTypeList = this.getResTypeList(resList);
        LicenseCalcBean bean = this.calcLicenseConsume(new ArrayList(), resTypeList);
        for (ResourceItemBo item : resList) {
            String useCount = "0";
            if (bean.getErrorCode() != 0L) {
                useCount = "--";
            } else if (bean.getResConsumeMap().containsKey(item.getItemName())) {
                useCount = ((Integer)bean.getResConsumeMap().get(item.getItemName())).toString();
            }
            item.setErrorCode(bean.getErrorCode());
            item.setParameters(bean.getParameters());
            item.setConsumeNum(useCount);
            logger.info((Object)"res item name=%s; value=%s.", new Object[]{item.getItemName(), useCount});
        }
    }

    private List<String> getResTypeList(List<ResourceItemBo> resList) {
        ArrayList<String> resTypeList = new ArrayList<String>();
        for (ResourceItemBo item : resList) {
            resTypeList.add(item.getItemName());
        }
        return resTypeList;
    }

    private void updateLicenseBuff(boolean needActive) {
        List<LicenseInfo> licList = this.getAllLicense();
        if (licList != null && !licList.isEmpty()) {
            LicenseInfo tmpLicInfo = licList.get(0);
            byte[] byFile = TranslateLicenseModel.getByteByBlob((Blob)tmpLicInfo.getFile());
            if (needActive) {
                RDLicenseFactory.getInstance().activateLic(byFile);
            }
            LicenseInfoBo temp = this.convert2LicBo(byFile);
            temp.setId(tmpLicInfo.getId());
            temp.setInUse(Boolean.valueOf(tmpLicInfo.isInUse()));
            temp.setProductESN(tmpLicInfo.getProductESN());
            temp.setProductName(tmpLicInfo.getProductName());
            temp.setUploadTime(Long.valueOf(tmpLicInfo.getUploadTime()));
            temp.setSoftId(tmpLicInfo.getSoftId());
            LicenseBuffer.getInstance().updateLicenseBuff(temp);
        }
    }

    public long getSysInstallTime() {
        LicensePolicyUtil policy = new LicensePolicyUtil();
        long sysInstallTime = policy.getSystemInstalledTime();
        logger.debug((Object)"install Time: %s", new Object[]{String.valueOf(sysInstallTime)});
        return sysInstallTime;
    }

    public void onBindLicenseUse(ILicenseUseInter service, Map<?, ?> properties) {
        if (service != null) {
            if (!this.useServiceMap.containsKey(service.getType())) {
                this.useServiceMap.put(service.getType(), new ArrayList());
            }
            this.useServiceMap.get(service.getType()).add(service);
        }
        logger.info((Object)"onBindLicenseUse->%s", new Object[]{service});
    }

    public void onUnbindLicenseUse(ILicenseUseInter service, Map<?, ?> properties) {
        if (service != null && this.useServiceMap.containsKey(service.getType())) {
            this.useServiceMap.get(service.getType()).remove(service);
        }
        logger.info((Object)"onUnbindLicenseUse->%s", new Object[]{service});
    }

    protected int getCloudConsumeNum() {
        ArrayList<String> cloudType = new ArrayList<String>();
        cloudType.add("LSTQCSDR");
        cloudType.add("LSTQCSHA");
        cloudType.add("LSTQVHA");
        int res = 0;
        for (String type : cloudType) {
            List<ILicenseUseInter> licenseUseInters = this.useServiceMap.get(type);
            if (VerifyUtil.isEmpty(licenseUseInters)) {
                res += 0;
                continue;
            }
            for (ILicenseUseInter licenseUseInter : licenseUseInters) {
                res += licenseUseInter.getUseCount();
            }
        }
        return res;
    }

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public boolean isLicenseProbationTimeout() {
        long sysInstallTime = this.getSysInstallTime();
        long curTime = System.currentTimeMillis();
        boolean expire = curTime - sysInstallTime > 7776000000L;
        logger.debug((Object)("installTime->" + sysInstallTime + "; curTime->" + curTime + "; expire->" + expire), 90160758787071L);
        return expire;
    }

    public boolean isBasicVersion() {
        LicenseInfoBo bo = this.getLicense();
        return bo == null && this.isLicenseProbationTimeout();
    }

    public boolean checkLicItemValid(String feaName, String itemName) {
        logger.debug((Object)"feaName=%s", new Object[]{feaName});
        return RDLicenseFactory.getInstance().checkLicItemValid(feaName, itemName);
    }

    public long isLicExpired() {
        return RDLicenseFactory.getInstance().isLicExpired();
    }

    public List<String> getEsnInfo() {
        ArrayList<String> esnList = new ArrayList<String>();
        if (VerifyUtil.isEmpty((Object)this.nodeAgentAccessClient)) {
            return esnList;
        }
        try {
            List nodeList = this.nodeAgentAccessClient.getNodeList();
            Map esnResultList = this.nodeAgentAccessClient.execute(new Command("query_esn"), nodeList, null);
            if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Map)esnResultList)) {
                logger.error((Object)"get esn empty.");
                return Collections.emptyList();
            }
            boolean hasError = false;
            for (Map.Entry responseEntry : esnResultList.entrySet()) {
                Response response = (Response)responseEntry.getValue();
                Node key = (Node)responseEntry.getKey();
                long code = response.getCode();
                if (code != 0L) {
                    logger.error((Object)"get esn info failed: address=%s, code=%s, detail=%s", new Object[]{key.getAddresses(), response.getCode(), response.getDetails()});
                    hasError = true;
                    break;
                }
                String details = response.getDetails();
                if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)details)) {
                    logger.error((Object)"get esn info empty: address=%s, code=%s", new Object[]{key.getAddresses(), response.getCode()});
                    hasError = true;
                    break;
                }
                String[] split = details.split(",");
                esnList.addAll(Arrays.asList(split));
            }
            if (hasError) {
                return Collections.singletonList("--");
            }
        }
        catch (TException e) {
            logger.error((Object)"get esn info failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.emptyList();
        }
        return esnList;
    }

    public void setNodeAgentAccessClient(NodeAgentLocalService.Iface nodeAgentAccessClient) {
        this.nodeAgentAccessClient = nodeAgentAccessClient;
    }
}

