/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.job;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.AbstractDrmQuartzJob;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.checker.task.ProtectionCheckerConcurrentExecutor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ProtectionCheckerJob
extends AbstractDrmQuartzJob {
    private static final Log logger = LogFactory.getInstance(ProtectionCheckerJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug((Object)"Start to excute protectionCheckerJob.");
        List<ProtectGroup> protectGroups = this.queryProtectGroups();
        if (VerifyUtil.isEmpty(protectGroups)) {
            logger.warn((Object)"There is no protectgroups.");
            return;
        }
        try {
            ProtectionCheckerConcurrentExecutor executor = ProtectionCheckerConcurrentExecutor.createExecutor(protectGroups);
            executor.process();
        }
        catch (Exception e) {
            logger.error((Object)"Executing protection checker job failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ProtectGroup> queryProtectGroups() {
        List list;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String queryHql = "from ProtectGroup pg where pg.primary=:isPrimary and pg.status !=:status";
            Query query = session.createQuery(queryHql);
            query.setBoolean("isPrimary", true);
            query.setInteger("status", DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            List results = query.list();
            List pgs = null;
            if (!VerifyUtil.isEmpty((Collection)results)) {
                pgs = results;
            }
            list = pgs;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"Querying pg failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
            return new ArrayList<ProtectGroup>();
        }
        DBOperationUtil.closeSession(session);
        return list;
    }
}

