/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.xml.XmlParser;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.framework.engine.action.ProtectActionFlowDefine;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class ProtectActionFlowDefineParaser {
    private static final String TEMPLATE = "templateType";
    private static final String APP = "appType";
    private static final String INDEX = "currentIndex";
    private XmlParser xmlParser = new XmlParser();
    private List<Document> templateDocuments = new ArrayList<Document>();

    public void readTemplateFile(URL processFileUrl) {
        Document document = this.xmlParser.init(processFileUrl);
        if (document != null) {
            this.templateDocuments.add(document);
        }
    }

    public List<ProtectActionFlowDefine> parseTemplateFile() {
        ArrayList<ProtectActionFlowDefine> templates = new ArrayList<ProtectActionFlowDefine>();
        for (Document document : this.templateDocuments) {
            Element rootElement = this.xmlParser.getRootElement(document);
            if (rootElement == null) continue;
            List<Node> actionFlowNodes = this.xmlParser.getNodes(rootElement, "/actions/actionFlowDefine");
            for (Node actionFlowNode : actionFlowNodes) {
                Element actionFlowElement = (Element)actionFlowNode;
                List<Node> flowNodes = this.xmlParser.getNodes(actionFlowElement, "flow");
                for (Node flowNode : flowNodes) {
                    ProtectActionFlowDefine flowDefine = new ProtectActionFlowDefine();
                    String template = this.xmlParser.getAttribute(actionFlowElement, TEMPLATE);
                    String app = this.xmlParser.getAttribute(actionFlowElement, APP);
                    flowDefine.setAppType(NumberUtil.convertToInteger((Object)app).intValue());
                    flowDefine.setTemplateType(NumberUtil.convertToInteger((Object)template).intValue());
                    Element flowNodeElement = (Element)flowNode;
                    String index = this.xmlParser.getAttribute(flowNodeElement, INDEX);
                    flowDefine.setCurrentIndex(NumberUtil.convertToInteger((Object)index).intValue());
                    List<Node> actionNodes = this.xmlParser.getNodes(flowNodeElement, "action");
                    for (Node actionNode : actionNodes) {
                        Element actionElement = (Element)actionNode;
                        flowDefine.addAction(this.buildDefaultActionVo(actionElement));
                    }
                    templates.add(flowDefine);
                }
            }
        }
        return templates;
    }

    private ProtectActionVo buildDefaultActionVo(Element actionElement) {
        String className = this.xmlParser.getAttribute(actionElement, "className");
        ProtectActionVo vo = new ProtectActionVo();
        if (VerifyUtil.isEmpty((String)className)) {
            String actionName = actionElement.getText();
            vo.setName(actionName);
            vo.setActionType("Ordinary");
            vo.setEnable(true);
            vo.setEditable(false);
        } else {
            vo.setName(className);
            String actionType = this.xmlParser.getAttribute(actionElement, "actionType");
            vo.setActionType(VerifyUtil.isEmpty((String)actionType) ? "Ordinary" : actionType);
            String editable = this.xmlParser.getAttribute(actionElement, "editable");
            vo.setEditable(VerifyUtil.isEmpty((String)editable) ? false : Boolean.valueOf(editable));
            String defaultEnable = this.xmlParser.getAttribute(actionElement, "enable");
            vo.setEnable(VerifyUtil.isEmpty((String)defaultEnable) ? true : Boolean.valueOf(defaultEnable));
        }
        return vo;
    }
}

