/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectObjectTransaction;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.support.TransactionCallback;

public class DeleteProtectObjectTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DeleteProtectObjectTask.class);
    private IProtectGroupBaseService service;
    private ProtectGroup protectGroup;
    private Set<ProtectObject> protectObjectSet;
    private ProtectGroupHelper helper = ProtectGroupHelper.getInstance();

    public DeleteProtectObjectTask(IProtectGroupBaseService service, ProtectGroup protectGroup, Set<ProtectObject> protectObjectSet) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.protect.element.delete", (String)"System", (String)"", null), true);
        this.service = service;
        this.protectGroup = protectGroup;
        this.protectObjectSet = protectObjectSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        logger.info((Object)"enter deletepotask");
        String protectGroupId = this.protectGroup.getUuid();
        Set<TaskResultItem> resultSet = new HashSet<TaskResultItem>();
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        HashMap<String, ProtectObject> toRemovedId2PoMap = new HashMap<String, ProtectObject>();
        MessageEvent removeEvent = null;
        boolean flag = true;
        try {
            this.helper.lockPos(this.protectObjectSet, 4, this.getBackTask(), resultSet);
            resultSet = this.helper.removeBatchTaskResultItem(this.protectObjectSet, this.protectGroup, this.getBackTask(), toRemovedId2PoMap);
            messageMap.put("TASK_RESULT_ITEM_LIST_KEY", resultSet);
            removeEvent = this.createMessageEvent(messageMap);
            ProtectGroupHelper.getInstance().validateProtectGroupParameter(this.protectGroup, true);
            this.service.notifyObserverList(removeEvent, "before");
            flag = this.dealTaskResultItemList(removeEvent, toRemovedId2PoMap);
            DeleteProtectObjectTransaction callback = new DeleteProtectObjectTransaction(this.service, this.protectGroup);
            this.service.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callback);
            this.afterNotify(removeEvent);
        }
        catch (LegoCheckedException le) {
            this.handleCheckedException(le);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.finalDeal(protectGroupId);
        }
        if (!flag) {
            this.getBackTask().setTaskResultSet(resultSet);
            logger.error((Object)"some protectobjects is not deleted!");
            throw new LegoCheckedException(-1L);
        }
    }

    private void afterNotify(MessageEvent removeEvent) {
        try {
            this.service.notifyObserverList(removeEvent, "after");
        }
        catch (Exception e) {
            logger.error((Object)("after notification error!" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void finalDeal(String protectGroupId) {
        this.helper.unlockPos(this.protectObjectSet, 4);
        ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
    }

    private MessageEvent createMessageEvent(Map<String, Object> messageMap) {
        MessageEvent removeEvent = new MessageEvent();
        removeEvent.setMessageType(4);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(this.protectGroup);
        removeEvent.setObjectList(objectList);
        removeEvent.setMessageMap(messageMap);
        return removeEvent;
    }

    private void handleException(Exception e) {
        ExceptionUtil.rethrowException((Throwable)e, (String)("failed to remove protectobject from protectgroup(" + this.protectGroup.getName() + ") because of saving error."), (long)-1L, (String[])new String[0], (Log)logger);
    }

    private void handleCheckedException(LegoCheckedException le) {
        ExceptionUtil.rethrowException((Throwable)le, (String)("failed to remove protectobject from protectgroup(" + this.protectGroup.getName() + ") because of sync error."), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
    }

    private boolean dealTaskResultItemList(MessageEvent removeEvent, Map<String, ProtectObject> toRemovedId2PoMap) {
        Map messageMap = removeEvent.getMessageMap();
        if (VerifyUtil.isEmpty((Map)messageMap)) {
            logger.error((Object)"messageMap is empty!");
            return true;
        }
        Object resultObj = messageMap.get("TASK_RESULT_ITEM_LIST_KEY");
        if (!(resultObj instanceof Set)) {
            logger.error((Object)"resultObj is not instancof Set");
            return true;
        }
        boolean flag = true;
        Set itemSet = (Set)resultObj;
        for (TaskResultItem item : itemSet) {
            String resId = item.getResId();
            Integer result = item.getResult();
            if (VerifyUtil.isEmpty((String)resId) || result == CommonConstant.BACKTASK_RESULT_SUCCESS) continue;
            this.protectGroup.getPolist().add(toRemovedId2PoMap.get(resId));
            toRemovedId2PoMap.remove(resId);
            flag = false;
        }
        if (!VerifyUtil.isEmpty(toRemovedId2PoMap)) {
            messageMap.put("TASK_RESULT_REMOVED_ITEM_LIST_KEY", new HashSet<ProtectObject>(toRemovedId2PoMap.values()));
        }
        return flag;
    }
}

