/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.PropsUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.protection.framework.service.group.AbstractProtectGroupService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.ReplicaUtil;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.ism.unistor.sdk.model.VstoreBaseInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

abstract class ProtectGroupQueryServiceImpl
extends AbstractProtectGroupService {
    private static final Log logger = LogFactory.getInstance(ProtectGroupQueryServiceImpl.class);
    private static final String QUERY_PO_BY_PGID = "select poId, name, moUuid, poType, poStatus, poRecoveryStatus, providerSN from ProtectObject where protectGroup.pgId = ?";
    private static final String QUERY_PG_BY_PTID = "select uuid from ProtectGroup where template.ptId = ?";
    private static final String QUERY_PO_PROPS = "select POID,PROPNAME,PROPVALUE from ti_po_prop where POID in(:ids)";
    private static final String COUNT_PO = "select protectGroup.pgId, count(uuid) from ProtectObject where protectGroup.pgId in(:ids) group by protectGroup.pgId";
    private static final String SELECT_PG = "select pgId, description, poType, poProviderSN, name, status, productSiteId, productSiteName, lastExecTime, lastExecResult, pgReplicaIndex, primary, objectType, template.ptId from ProtectGroup";
    private Map<Integer, IProtectObjectBaseProvider> providerMapping = new ConcurrentHashMap<Integer, IProtectObjectBaseProvider>();

    public Page pagedQueryProtectObjectByPg(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId, Integer poType) {
        logger.debug((Object)"pagedQueryProtectObjectByPg");
        ProtectGroup group = this.getProtectGroupBasicInfo(protectGroupId, false);
        StringBuilder hql = new StringBuilder(QUERY_PO_BY_PGID);
        ArrayList<Object> queryParams = new ArrayList<Object>();
        queryParams.add(protectGroupId);
        int allPoType = -1;
        if (poType != -1) {
            hql.append(" and poType = ?");
            queryParams.add(poType);
        }
        this.addOrder(hql, orderBy, isAsc);
        Page page = this.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, queryParams.toArray());
        List results = page.getResult();
        if (results == null || results.isEmpty() || group == null) {
            return page;
        }
        IProtectObjectBaseProvider provider = this.getProtectObjectProvider(group.getPoType());
        List<ProtectObject> objects = this.castAsProtectObjects(group, results);
        provider.refreshProtectObjectProperties(objects);
        page.setResult(objects);
        return page;
    }

    private List<ProtectObject> castAsProtectObjects(ProtectGroup group, List<?> datas) {
        logger.debug((Object)"castAsProtectObjects");
        List ids = this.getColumnData(datas, 0);
        List<?> values = this.executeNativeSql(QUERY_PO_PROPS, "ids", ids);
        Map<Object, Object> props = new HashMap();
        if (!VerifyUtil.isEmpty(values)) {
            props = this.groupPropItems(values);
        } else {
            logger.error((Object)"The props of protectObject is empty.");
        }
        boolean isAirGapSite = Optional.ofNullable(group).map(ProtectGroup::getProps).map(map -> (String)map.get("isAirGapType")).map(Boolean::parseBoolean).orElse(false);
        ArrayList<ProtectObject> objects = new ArrayList<ProtectObject>();
        for (Object each : datas) {
            int i = 0;
            Object[] data = (Object[])each;
            if (VerifyUtil.isEmpty((Object[])data) || data.length < 7) {
                logger.error((Object)"ProtectGroupQueryServiceImpl: data length error.", 90160758786989L);
                continue;
            }
            ProtectObject object = new ProtectObject();
            String id = (String)data[i++];
            object.setUuid(id);
            object.setName((String)data[i++]);
            object.setMoUuid((String)data[i++]);
            object.setPoType(((Integer)data[i++]).intValue());
            object.setPoStatus(((Integer)data[i++]).intValue());
            object.setPoRecoveryStatus(((Integer)data[i++]).intValue());
            object.setProviderSN((String)data[i++]);
            object.setProps((Map)props.get(id));
            String vstoreId = (String)object.getProps().get("PROP_KEY_VSTORE_ID");
            if (isAirGapSite && !VerifyUtil.isEmpty((String)vstoreId)) {
                VstoreBaseInfo vstoreInfo = StorageResourceServiceRouter.getInstance().getVstoreById(object.getProviderSN(), vstoreId);
                object.getProps().put("vstoreName", vstoreInfo.getName());
            }
            object.setProtectGroup(group);
            objects.add(object);
        }
        return objects;
    }

    public void onBind(IProtectObjectBaseProvider provider, Map<?, ?> properties) {
        logger.debug((Object)"onBind");
        this.providerMapping.put(provider.getProviderByType(), provider);
    }

    public void onUnbind(IProtectObjectBaseProvider provider, Map<?, ?> properties) {
        logger.debug((Object)"onUnbind");
        this.providerMapping.remove(provider.getProviderByType());
    }

    public IProtectObjectBaseProvider getProtectObjectProvider(Object type) {
        IProtectObjectBaseProvider provider = this.providerMapping.get(type);
        if (null == provider) {
            logger.error((Object)("Could not get provider, protect object type is " + type), 90160758787071L);
            throw new LegoCheckedException(1073947395L);
        }
        return provider;
    }

    public List<ProtectObject> getProtectObjectListByUuid(List<String> uuid) {
        if (VerifyUtil.isEmpty(uuid)) {
            logger.error((Object)"uuid null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupHelper.getInstance().getProtectObjectListByUuid(uuid);
    }

    public List<ProtectGroup> getAllProtectGroupBasicInfo(Long userId, boolean isQueryReplica, boolean isQueryProps, boolean isQueryPos) {
        return QueryProtectGroupRefineService.getInstance().getAllProtectGroupBasicInfo(userId, isQueryReplica, isQueryProps, isQueryPos);
    }

    public List<ProtectObject> getProtectObjectListByMoUUID(List<String> moUuIds) {
        if (VerifyUtil.isEmpty(moUuIds)) {
            logger.error((Object)"failed to getProtectObjectListByMoUUID because of invalidity paramiter.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return ProtectGroupHelper.getInstance().getProtectObjectListByMoUUID(moUuIds);
    }

    public ProtectGroup getProtectGroupByPolicyTemplateId(String policyTemplateId) {
        List pgIds = this.getBaseDao().getHibernateTemplate().find(QUERY_PG_BY_PTID, new Object[]{policyTemplateId});
        if (!VerifyUtil.isEmpty((Collection)pgIds)) {
            logger.info((Object)("protectGroupId is: " + (String)pgIds.get(0)), 90160758786989L);
            ProtectGroup pg = new ProtectGroup();
            pg.setUuid((String)pgIds.get(0));
            return pg;
        }
        return null;
    }

    public List<Schedule> getAllSchedule(String protectGroupId) {
        ProtectGroup protectGroup = ((IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        PolicyTemplate template = protectGroup.getTemplate();
        template.getSchedules().forEach(schedule -> schedule.setPolicyTemplate(template));
        this.updateSchedule(protectGroupId, template);
        template.getSchedules().forEach(ScriptParamsUtils::filterSensitiveParams);
        ProtectGroupUtil.disableDeformed4dcSchedules(protectGroup, template.getSchedules());
        return new ArrayList<Schedule>(template.getSchedules());
    }

    public ProtectGroup getProtectGroupByID(String protectGroupId, boolean queryProtectObjectReplica) {
        logger.debug((Object)("protectGroupId:" + protectGroupId + ", queryProtectObjectReplica:" + queryProtectObjectReplica));
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        this.updateSchedule(protectGroup, protectGroup.getTemplate());
        return protectGroup;
    }

    public ProtectGroup getProtectGroupByID(String protectGroupId) {
        logger.debug((Object)("protectGroupId:" + protectGroupId));
        return this.getProtectGroupByID(protectGroupId, true);
    }

    public Page pagedQueryProtectGroup(int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props, Long userId) {
        logger.info((Object)"pagedQueryProtectGroup");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder hql = new StringBuilder(SELECT_PG);
        boolean flag = false;
        if (props != null) {
            for (QueryCondition prop : props) {
                if (!CommonUtil.isValidDbColumn((String)prop.getPropName())) {
                    throw new LegoCheckedException(1073947393L);
                }
                String name = prop.getPropName();
                Object value = prop.getPropValue();
                if (prop.getCoType() == 8 && VerifyUtil.isEmpty((Object)value)) {
                    return new Page(0L, 0L, pageSize, Collections.emptyList());
                }
                hql.append(flag ? " and " : " where ");
                boolean isName = "name".equals(name) || "productSiteName".equals(name);
                hql.append(isName ? "lower(" + name + ")" : name);
                boolean isStatus = "status".equals(name);
                if (isStatus) {
                    hql.append(" = ?");
                    params.add(NumberUtil.convertToInteger((Object)value));
                } else if (prop.getCoType() == 8) {
                    List values = JSONArray.fromObject((Object)value).toBean(String.class);
                    hql.append(" in(");
                    String inValues = values.stream().map(v -> "?").collect(Collectors.joining(","));
                    hql.append(inValues).append(")");
                    params.addAll(values);
                } else if (value instanceof String) {
                    hql.append(isName ? " like lower(?) escape '/'" : " like ? escape '/'");
                    String str = ((String)value).replaceAll("/", "//");
                    str = str.replaceAll("%", "/%");
                    str = str.replaceAll("_", "/_");
                    params.add("%" + str + "%");
                } else {
                    hql.append(" = ?");
                    params.add(value);
                }
                flag = true;
            }
        }
        this.appendUserBizCondition(hql, params, userId, flag);
        this.addOrder(hql, orderBy, isAsc);
        Page page = this.getBaseDao().pagedQuery(hql.toString(), pageNo, pageSize, params.toArray());
        List<ProtectGroup> results = page.getResult();
        results = this.convertDatasToProtectGroups(results);
        page.setResult(results);
        return page;
    }

    public Map<String, Object> getProtectGroupBriefInfo(String protectGroupId) {
        String hql = "select new map(p.pgId as pgId, p.poProviderSN as poProviderSN, p.name as name, p.primary as primary, p.description as description, p.productSiteId as productSiteId,d.name as siteName, p.productSiteName as productSiteName, p.template as template)from ProtectGroup p, DrResource d, PolicyTemplate pt where p.pgId = ? and p.template.ptId = pt.ptId and d.deviceSn = p.poProviderSN";
        List list = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{protectGroupId});
        if (VerifyUtil.isEmpty((Collection)list)) {
            logger.error((Object)"failed to query ProtectGroup.", 1073947394L);
            throw new LegoCheckedException(1073947394L, "failed to query ProtectGroup.");
        }
        Map result = (Map)list.get(0);
        result.put("poCount", this.getProtectGroupObjectCount(protectGroupId));
        result.put("replicaCount", this.getProtectGroupReplicaCount(protectGroupId));
        String sql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID = :PGID";
        List<?> pgProps = this.executeNativeSql(sql, "PGID", protectGroupId);
        if (pgProps == null) {
            logger.error((Object)"pgProps is null!");
            return result;
        }
        Map<String, Map<String, String>> props = this.groupPropItems(pgProps);
        if (!VerifyUtil.isEmpty(props) && props.containsKey(protectGroupId)) {
            Map<String, String> prop = props.get(protectGroupId);
            prop.put("providerName", (String)result.get("siteName"));
            result.remove("siteName");
            result.put("props", prop);
        }
        return result;
    }

    public List<ProtectGroup> queryProtectGroups(Long userId) {
        return QueryProtectGroupRefineService.getInstance().queryProtectGroups(userId);
    }

    public List<ProtectGroup> getAllProtectGroup(Long userId) {
        logger.debug((Object)("userId:" + userId));
        return QueryProtectGroupRefineService.getInstance().getAllProtectGroup(userId);
    }

    public List<ProtectGroup> getProtectGroupByType(int poType, Long userId) {
        logger.debug((Object)"getProtectGroupByType");
        return this.getProtectGroupByType(poType, userId, true);
    }

    public List<ProtectGroup> getProtectGroupByType(int poType, Long userId, boolean queryProtectObjectReplica) {
        logger.debug((Object)"getProtectGroupByType");
        return QueryProtectGroupRefineService.getInstance().getProtectGroupByType(poType, userId, queryProtectObjectReplica);
    }

    public ProtectObject getProtectObjectByMoUUID(String protectGroupId, String uuId) {
        ProtectObject po = ProtectGroupHelper.getInstance().getProtectObjectByMoUUID(protectGroupId, uuId);
        if (VerifyUtil.isEmpty((Object)po)) {
            logger.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947394L);
        }
        return po;
    }

    public List<ProtectObject> getAllProtectObjectByType(int poType) {
        List result = null;
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectObject.class);
            crit.add((Criterion)Restrictions.eq((String)"poType", (Object)poType));
            crit.createAlias("protectGroup", "protectGroup").add(Restrictions.isNotNull((String)"protectGroup.pgId"));
            result = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return result;
    }

    public Page pageQueryHistoryLogFromAll(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup does not exist.Id:" + protectGroupId), 90160758787071L);
            return Page.createPage((int)pageNo, (int)pageSize, Collections.emptyList());
        }
        Site site = this.getSiteService().getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("queryHistoryLogs error, site is null, siteId:" + protectGroup.getProductSiteId()), 90160758787071L);
            return Page.createPage((int)pageNo, (int)pageSize, Collections.emptyList());
        }
        if (1 == site.getSiteType()) {
            return this.pageQueryRemoteLogs(pageNo, pageSize, orderBy, isAsc, protectGroup, site);
        }
        return this.pageQueryHistoryLog(pageNo, pageSize, orderBy, isAsc, protectGroupId);
    }

    private Page pageQueryRemoteLogs(int pageNo, int pageSize, String orderBy, boolean isAsc, ProtectGroup protectGroup, Site site) {
        logger.debug((Object)"pageQueryRemoteLogs");
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("protectGroupId", protectGroup.getUuid());
        uriVariables.put("startPage", pageNo);
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("orderBy", orderBy);
        String orderType = "desc";
        if (isAsc) {
            orderType = "asc";
        }
        uriVariables.put("orderType", orderType);
        String result = this.getPageLogJson(site, uriVariables);
        JSONObject pageJson = JSONObject.fromObject((Object)result);
        JSONArray logJsons = new JSONArray();
        long totalSize = 0L;
        try {
            logJsons = JSONArray.fromObject((Object)pageJson.get("records"));
            totalSize = Long.parseLong(String.valueOf(pageJson.get("totalCount")));
        }
        catch (Exception e) {
            logger.error((Object)("from json object or get totalPage error.json:" + result + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        long start = (long)pageNo * (long)pageSize;
        List arrayList = JSONArray.toCollection((JSONArray)logJsons, ProtectGroupLog.class);
        return new Page(start, totalSize, pageSize, arrayList);
    }

    private String getPageLogJson(Site site, Map<String, Object> uriVariables) {
        RestClient client = SiteUtil.initClient(site);
        try {
            String url = "/ws/protectgroups/{protectGroupId}/logs?startPage={startPage}&pageSize={pageSize}&orderBy={orderBy}&orderType={orderType}";
            return client.invoke(url, uriVariables, HttpMethod.GET);
        }
        catch (LegoCheckedException e) {
            String errorMsg = "query HistoryLogs from remote site error";
            logger.error((Object)errorMsg, 90160758787071L);
            throw new LegoCheckedException(1073947440L, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"getPageLogJson error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"query HistoryLogs from remote site error", (long)1073947440L, (String[])new String[0], (Log)logger);
            return null;
        }
    }

    private Page pageQueryHistoryLog(int pageNo, int pageSize, String orderBy, boolean isAsc, String protectGroupId) {
        List<Object> result = new ArrayList();
        try {
            result = this.queryProtectGroupLogs(protectGroupId, 1, orderBy, isAsc);
        }
        catch (Exception e) {
            logger.error((Object)"pageQueryHistoryLog error");
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to query ProtectObject.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        return Page.createPage((int)pageNo, (int)pageSize, result);
    }

    public List<ProtectGroupLogDetail> queryHistoryLogDetailFromAll(int historyLogId, String protectGroupId) {
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup does not exist. Id:" + protectGroupId), 90160758787071L);
            return Collections.emptyList();
        }
        Site site = this.getSiteService().getSiteById(protectGroup.getProductSiteId());
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.error((Object)("queryHistoryLogDetail error, site is null, siteId:" + protectGroup.getProductSiteId()), 90160758787071L);
            return Collections.emptyList();
        }
        if (!this.logIdBelongToProtectGroup(historyLogId, protectGroupId)) {
            logger.error((Object)"Log is not belong to protectgroup!");
            throw new LegoCheckedException(201L);
        }
        if (1 == site.getSiteType()) {
            RestClient client = SiteUtil.initClient(site);
            try {
                HashMap<String, Object> uriVariables = new HashMap<String, Object>();
                uriVariables.put("protectGroupId", protectGroup.getUuid());
                uriVariables.put("logId", historyLogId);
                String result = client.invoke("/ws/protectgroups/{protectGroupId}/logs/{logId}/details", uriVariables, HttpMethod.GET);
                List<ProtectGroupLogDetail> pgLogDetails = ProtectGroupUtil.getInstance().transJsonToLogDetail(result);
                return pgLogDetails;
            }
            catch (LegoCheckedException e) {
                String errorMsg = "query HistoryLogDetail from remote site error";
                logger.error((Object)errorMsg, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"query HistoryLogDetail from remote site error", (long)1073947440L, (String[])new String[0], (Log)logger);
                return new ArrayList<ProtectGroupLogDetail>();
            }
        }
        return this.queryHistoryLogDetail(String.valueOf(historyLogId));
    }

    public List<ProtectLocationPath> getProtectLocations(String protectGroupId) {
        logger.debug((Object)"enter getProtectLocations");
        ArrayList<ProtectLocationPath> result = new ArrayList<ProtectLocationPath>();
        ProtectGroup pg = this.getProtectGroupByID(protectGroupId, false);
        Set<Integer> allProtectLocations = ProtectGroupUtil.getInstance().getAllPgProtectLocation(pg);
        block0: for (Integer location : allProtectLocations) {
            for (Schedule schedule : pg.getTemplate().getSchedules()) {
                if (!location.equals(NumberUtil.convertToInteger((Object)schedule.getProtectLocation()))) continue;
                String targetSiteId = schedule.getTargetSiteId();
                if (VerifyUtil.isEmpty((String)targetSiteId)) continue block0;
                ProtectLocationPath path = new ProtectLocationPath();
                path.setProtectLocation(location.intValue());
                path.setRecoverySiteId(schedule.getTargetSiteId());
                ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
                path.setRecoverySiteName(siteService.getSiteById(schedule.getTargetSiteId()).getName());
                result.add(path);
                continue block0;
            }
        }
        return result;
    }

    public Map<String, ProtectObject> getStorageInfoChangedProtectObjectList(ProtectGroup protectGroup) {
        logger.debug((Object)"enter getStorageInfoChangedProtectObjectList");
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"parameter is error", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        HashMap protectObjectMap = new HashMap();
        for (ProtectObject po : protectGroup.getPolist()) {
            HashSet olderStorageInfo = new HashSet();
            olderStorageInfo.addAll(po.getUsedStorageResourceSet());
            protectObjectMap.put(po.getMoUuid(), olderStorageInfo);
        }
        IProtectObjectBaseProvider provider = this.getProtectObjectProvider(protectGroup.getPoType());
        HashMap<String, ProtectObject> protectObjectListChanged = new HashMap<String, ProtectObject>();
        for (ProtectObject po : protectGroup.getPolist()) {
            HashSet<ProtectObjectStorageInfo> newerStorageInfo = new HashSet<ProtectObjectStorageInfo>();
            po.clearUsedStorageResource();
            ProtectObject object = null;
            try {
                object = (ProtectObject)po.clone();
            }
            catch (Exception e) {
                logger.error((Object)"getStorageInfoChangedProtectObjectList error");
                ExceptionUtil.rethrowException((Throwable)e, (String)"Error to clone ProtectObject", (long)-1L, (String[])new String[0], (Log)logger);
            }
            newerStorageInfo.addAll(provider.getProtectObjectStorageInfo(object));
            String drRingLimits = "DrRing.Limits";
            if (null == object) {
                logger.error((Object)"object is null");
                throw new LegoCheckedException(0x300001L);
            }
            Map props = object.getProps();
            if (props != null && props.containsKey(drRingLimits)) {
                po.getProps().put(drRingLimits, props.get(drRingLimits));
            }
            Set olderStorageInfo = (Set)protectObjectMap.get(po.getMoUuid());
            if (ProtectGroupHelper.getInstance().checkPoStorageInfoChanged(olderStorageInfo, newerStorageInfo)) {
                protectObjectListChanged.put(po.getMoUuid(), po);
            }
            po.clearUsedStorageResource();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : newerStorageInfo) {
                po.addHostStorageResourceInfo(protectObjectStorageInfo);
            }
        }
        this.addProtectGroupReplicaChangedInfo(protectObjectListChanged, protectGroup);
        return protectObjectListChanged;
    }

    private void addProtectGroupReplicaChangedInfo(Map<String, ProtectObject> changed, ProtectGroup protectGroup) {
        Set replicaList = protectGroup.getReplicaList();
        if (VerifyUtil.isEmpty((Collection)replicaList)) {
            return;
        }
        Optional<ProtectGroupReplica> protectGroupReplicaOptional = replicaList.stream().filter(pgReplica -> !ReplicaUtil.isLocalStorageReplica((ProtectGroupReplica)pgReplica)).findFirst();
        if (!protectGroupReplicaOptional.isPresent()) {
            return;
        }
        ProtectGroupReplica replica = protectGroupReplicaOptional.get();
        if (replica.getReplicas().size() == protectGroup.getPolist().size()) {
            return;
        }
        Set invalidPoIdSet = replica.getReplicas().stream().map(ProtectObjectReplica::getPoId).collect(Collectors.toSet());
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            invalidPoIdSet.remove(protectObject.getUuid());
        }
        logger.info((Object)"find invalid protectObjectReplica in protectGroupReplica: poIds=%s", new Object[]{invalidPoIdSet});
        ProtectObject protectObject = new ProtectObject();
        for (String invalidPoId : invalidPoIdSet) {
            changed.put(invalidPoId, protectObject);
        }
    }

    protected List<ProtectGroupLogDetail> queryPgRunningHistoryLog(String protectGroupId) {
        try {
            ProtectGroupLog pglog = this.getRunningProtectGroupLog(protectGroupId);
            if (null == pglog) {
                return null;
            }
            return this.queryHistoryLogDetail(pglog.getHistoryLogId() + "");
        }
        catch (Exception e) {
            logger.error((Object)("queryRunningHistoryLog error" + ExceptionUtil.getErrorMessage((Throwable)e)));
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to query ProtectObject.", (long)-1L, (String[])new String[0], (Log)logger);
            return new ArrayList<ProtectGroupLogDetail>();
        }
    }

    private long getProtectGroupObjectCount(String protectGroupId) {
        logger.debug((Object)("protectGroupId:" + protectGroupId));
        String hql = "select count(uuid) from ProtectObject where protectGroup.pgId = ?";
        return this.getCountResult(hql, protectGroupId);
    }

    private long getProtectGroupReplicaCount(String protectGroupId) {
        logger.debug((Object)("protectGroupId:" + protectGroupId));
        String hql = "select count(id) from ProtectGroupReplica where pg.pgId = ?";
        return this.getCountResult(hql, protectGroupId);
    }

    private long getCountResult(String hql, String arg) {
        logger.debug((Object)"getCountResult");
        List list = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{arg});
        if (VerifyUtil.isEmpty((Collection)list)) {
            return 0L;
        }
        Long count = (Long)list.get(0);
        return count != null ? count : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProtectGroup> convertDatasToProtectGroups(List<?> datas) {
        ArrayList<ProtectGroup> items = new ArrayList<ProtectGroup>();
        if (VerifyUtil.isEmpty(datas)) {
            return items;
        }
        List<String> ids = this.getColumnData(datas, 0);
        List<?> counts = null;
        Map<String, Map<String, String>> props = null;
        List<PolicyTemplate> templates = null;
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            counts = this.getProtectGroupObjectCounts(ids);
            props = PropsUtil.queryPropMaps(PropsUtil.PropModel.PROTECTGROUP, ids);
            templates = this.getProtectTemplates(session, datas);
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Query infomation for ProtectGroup failed.", (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        for (String id : ids) {
            Object[] result = ProtectGroupUtil.getInstance().getItemByPgId(datas, id);
            if (result == null || result.length <= 1) continue;
            int count = ProtectGroupUtil.getInstance().getProtectGroupObjectCount(counts, id);
            PolicyTemplate template = this.getPolicyTemplateByPgId(templates, (String)result[result.length - 1]);
            if (props == null) {
                logger.error((Object)"props is null!");
                return items;
            }
            Map<String, String> prop = props.get(id);
            items.add(this.getAndFillProtectGroup(result, template, prop, count));
        }
        return items;
    }

    private List<?> getProtectGroupObjectCounts(List<String> ids) {
        logger.debug((Object)"getProtectGroupObjectCounts");
        return this.getBaseDao().getHibernateTemplate().findByNamedParam(COUNT_PO, "ids", ids);
    }

    private ProtectGroup getAndFillProtectGroup(Object[] data, PolicyTemplate template, Map<String, String> props, int count) {
        logger.debug((Object)"getAndFillProtectGroup");
        int i = 0;
        ProtectGroup protectGroup = new ProtectGroup();
        if (data == null || data.length < 11) {
            return null;
        }
        protectGroup.setUuid((String)data[i++]);
        protectGroup.setDescription((String)data[i++]);
        protectGroup.setPoType(((Integer)data[i++]).intValue());
        protectGroup.setPoProviderSN((String)data[i++]);
        protectGroup.setName((String)data[i++]);
        protectGroup.setStatus(((Integer)data[i++]).intValue());
        String siteId = (String)data[i++];
        protectGroup.setProductSiteId(siteId);
        protectGroup.setProductSiteName((String)data[i++]);
        Site site = this.getSiteService().getSiteById(siteId);
        protectGroup.setProductSiteName(site.getName());
        protectGroup.setLastExecTime((Long)data[i++]);
        protectGroup.setLastExecResult((Integer)data[i++]);
        protectGroup.setPgReplicaIndex(((Integer)data[i++]).intValue());
        protectGroup.setPrimary(((Boolean)data[i++]).booleanValue());
        protectGroup.setPolist(new HashSet(count));
        protectGroup.setProps(props);
        protectGroup.setTemplate(template);
        return protectGroup;
    }

    private PolicyTemplate getPolicyTemplateByPgId(List<PolicyTemplate> templates, String id) {
        logger.debug((Object)"getPolicyTemplateByPgId");
        PolicyTemplate template = null;
        for (PolicyTemplate each : templates) {
            if (!each.getPtId().equals(id)) continue;
            template = each;
            break;
        }
        return template;
    }

    private List<PolicyTemplate> getProtectTemplates(Session session, List<?> groups) {
        logger.debug((Object)"getProtectTemplates");
        ArrayList<PolicyTemplate> templates = new ArrayList<PolicyTemplate>();
        List ids = this.getColumnData(groups, -1);
        String sql = "select PTID, NAME, VIEWTEMPLATEURL, TYPE from ti_policytemplate where PTID in(:ids)";
        NativeQuery query = session.createSQLQuery(sql);
        query.setParameterList("ids", ids);
        List datas = query.list();
        for (Object each : datas) {
            Object[] data = (Object[])each;
            PolicyTemplate template = new PolicyTemplate();
            int i = 0;
            if (data == null || data.length < 4) continue;
            template.setPtId((String)data[i++]);
            template.setName((String)data[i++]);
            template.setViewTemplateUrl((String)data[i++]);
            template.setType(((Integer)data[i++]).intValue());
            templates.add(template);
        }
        return templates;
    }

    public static void logDiskInfo(String pgName, List<DiskInfo> diskInfos) {
        if (null == diskInfos) {
            return;
        }
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)po.getName());
                return poJsonObj;
            }).forEach(o -> poArray.add(o));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(o -> diskJSONArray.add(o));
        String str = diskJSONArray.toString();
        logger.info((Object)("protectGroup:" + pgName + " diskInfos:" + str));
    }
}

