/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class UpdateProtectGroupTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(UpdateProtectGroupTransaction.class);
    private IProtectGroupBaseService service;
    private IBaseDao<?, ?> callBackBaseDao;
    private ProtectGroup protectGroup;
    private List<BatchOperation> resultList;

    public UpdateProtectGroupTransaction(IProtectGroupBaseService service, ProtectGroup protectGroup, List<BatchOperation> resultList) {
        this.service = service;
        this.callBackBaseDao = service.getBaseDao();
        this.protectGroup = protectGroup;
        this.resultList = resultList;
    }

    public Object doInTransaction(TransactionStatus tStatus) {
        try {
            this.callBackBaseDao.getHibernateTemplate().saveOrUpdate((Object)this.protectGroup);
            ((IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class)).syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to add protectobject to potectgroup(%s) because of sync error.", new Object[]{le, this.protectGroup.getName()});
            tStatus.setRollbackOnly();
            if (this.resultList != null) {
                ProtectGroupHelper.getInstance().updateBatchOperationResult(this.resultList, 0L == le.getErrorCode() ? -1L : le.getErrorCode());
            }
            throw le;
        }
        catch (DataAccessException e) {
            this.handleUpdatePgError(tStatus, this.protectGroup.getName(), (Exception)((Object)e));
        }
        catch (Exception ex) {
            this.handleUpdatePgError(tStatus, this.protectGroup.getName(), ex);
        }
        return this.resultList;
    }

    private void handleUpdatePgError(TransactionStatus tStatus, String protectGroupName, Exception ex) {
        logger.error((Object)"failed to add protectobject to potectgroup(%s) because of saving error: %s.", new Object[]{protectGroupName, ExceptionUtil.getErrorMessage((Throwable)ex)});
        tStatus.setRollbackOnly();
        if (this.resultList == null) {
            throw ExceptionUtil.convertException((Throwable)ex, (String)"", (long)-1L, (String[])new String[0], (Log)logger);
        }
        ProtectGroupHelper.getInstance().updateBatchOperationResult(this.resultList, -1L);
    }
}

