/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.task;

import com.huawei.ism.drm.protection.framework.engine.job.DataBaseClearJob;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.text.ParseException;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

public class DataBaseClearJobManager {
    public static final String DATEBEFORE = "DATEBEFORE";
    private static final String DATE2CLEAR = "7";
    private static final Log LOGGER = LogFactory.getInstance(DataBaseClearJobManager.class);

    public void init() {
        try {
            Scheduler protectQuartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            if (protectQuartzScheduler == null) {
                LOGGER.error((Object)"Schedule is empty , DataBaseClearJob failed.");
                return;
            }
            JobKey jobKey = new JobKey(this.getClearJobName(), this.getClearJobGroupName());
            JobDetail jobDetail = protectQuartzScheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                protectQuartzScheduler.deleteJob(jobKey);
            }
            protectQuartzScheduler.scheduleJob(this.buildJobDeatil(), this.buildCronTrigger());
            protectQuartzScheduler.start();
            LOGGER.info((Object)"Schedule DataBaseClearJob success.");
        }
        catch (SchedulerException e) {
            LOGGER.error((Object)"Schedule DataBaseClearJob failed.");
        }
    }

    public String getClearJobName() {
        return "historyLogClearJob";
    }

    public String getClearJobGroupName() {
        return "historyLogClearJobGroup";
    }

    public String getClearTriggerName() {
        return "historyLogClearTrigger";
    }

    public String getClearTriggerGroupName() {
        return "historyLogClearTriggerGroup";
    }

    public Trigger buildCronTrigger() {
        String cronExpression = "0 0 0 * * ?";
        CronTriggerImpl quarzTrigger = null;
        try {
            quarzTrigger = new CronTriggerImpl(this.getClearTriggerName(), this.getClearTriggerGroupName(), cronExpression);
            quarzTrigger.setStartTime(new Date());
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Parse crontab expression failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return quarzTrigger;
    }

    public JobDetail buildJobDeatil() {
        JobDetailImpl jobDetail = new JobDetailImpl();
        jobDetail.setJobClass(DataBaseClearJob.class);
        jobDetail.setName(this.getClearJobName());
        jobDetail.setGroup(this.getClearJobGroupName());
        jobDetail.setDurability(true);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATEBEFORE, DATE2CLEAR);
        jobDetail.setJobDataMap(jobDataMap);
        return jobDetail;
    }
}

