/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.IRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.ExecuteLocalScriptUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class BaseRecoveryProcessor
extends RecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(BaseRecoveryProcessor.class);
    protected static final boolean CONTINUE_RECOVERY_PROCESS = true;
    protected static final boolean EXIT_RECOVERY_PROCESS = false;
    protected static final long LOG_CODE = -1L;
    protected static final long NO_SUB_PROCESSOR = Long.MAX_VALUE;
    protected static final Duration PROCESSOR_TIMEOUT = Duration.ofHours(1L);
    protected static final KeyLocker UPDATE_PROGRESS_LOCKER = new KeyLocker(BaseRecoveryProcessor.class, "UPDATE_PROGRESS_LOCK");
    protected static final String PREPPARE_CLASS = "prepareclass";
    private static final long serialVersionUID = -4384869125323015228L;
    private static final Log logger = LogFactory.getInstance(BaseRecoveryProcessor.class);
    private static final String PARAM_PROC_NAME_PARAMS = "ProcNameParams";
    private static final String PARAM_PROC_NAME = "ProcName";
    private static final String PARAM_PROC_ID = "ProcId";
    private static final String PARAM_PREVIOUS_PROC_ID = "PreviousProcId";
    private static final String PARAM_NEXT_PROC_ID = "NextProcId";
    private static final String PARAM_PROC_STATUS = "ProcessStatus";
    private static final String REF_PROC_TYPE = "refproctype";
    private RecoveryProcessorContext contextRef = null;
    private boolean asyncExecute = false;
    private String recoveryTasksKey = "recoveryTasks";
    private IRecoveryTaskInterceptor taskInterceptor;

    public RecoveryProcessorContext getContextRef() {
        logger.debug((Object)"enter getContextRef");
        return this.contextRef;
    }

    public boolean success() {
        return this.success(null, null);
    }

    public boolean success(String detail, String[] detailParams) {
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        this.updateProcessDetail(detail, detailParams);
        return true;
    }

    public boolean failure() {
        return this.failure(null, null);
    }

    public boolean failure(String failureDetails, String[] failureParams) {
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail(failureDetails, failureParams);
        return false;
    }

    public boolean failure(LegoCheckedException ex) {
        return this.failure(ex.getErrorMessageKey(), ex.getParameters());
    }

    public void setContextRef(RecoveryProcessorContext contextRef) {
        logger.debug((Object)"enter setContextRef");
        this.contextRef = contextRef;
    }

    public boolean isAsyncExecute() {
        logger.debug((Object)"enter isAsyncExecute");
        return this.asyncExecute;
    }

    public void setAsyncExecute(boolean asyncExecute) {
        logger.debug((Object)"enter setAsyncExecute");
        this.asyncExecute = asyncExecute;
    }

    public String getRecoveryTasksKey() {
        if (this.getProps().containsKey("recovery-task-key")) {
            return (String)this.getProps().get("recovery-task-key");
        }
        return this.recoveryTasksKey;
    }

    public void setRecoveryTasksKey(String recoveryTasksKey) {
        this.recoveryTasksKey = recoveryTasksKey;
    }

    public final boolean process(RecoveryProcessorContext context) {
        Map details;
        logger.debug((Object)"enter process");
        this.contextRef = context;
        this.updateProcessName();
        boolean isNeedCreateDetail = this.getIsNeedCreateDetail();
        logger.debug((Object)"IsNeedCreateDetail now is %s", new Object[]{isNeedCreateDetail});
        if (!VerifyUtil.isEmpty((Object)context.getAttribute("CSHA_CSDR_ALL_RECOVERYPROCESSOR_DETAIL")) && context.getAttribute("CSHA_CSDR_ALL_RECOVERYPROCESSOR_DETAIL") instanceof Map && (details = (Map)context.getAttribute("CSHA_CSDR_ALL_RECOVERYPROCESSOR_DETAIL")).containsKey(this.getProcId())) {
            RecoveryProcessorDetail detail = (RecoveryProcessorDetail)((List)details.get(this.getProcId())).get(0);
            detail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDetail(detail);
            this.setCurProcessDetail(detail);
            this.setIsNeedCreateDetail(false);
        }
        this.beforeExecRecoveryProcessor();
        if (!VerifyUtil.isEmpty((Object)context.getAttribute("CSHA_CSDR_ALL_RECOVERYPROCESSOR_DETAIL"))) {
            this.setIsNeedCreateDetail(isNeedCreateDetail);
        }
        this.updateProcNameParams();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        boolean result = false;
        if (this.checkReprotectReentrantable(recoveryPlan)) {
            logger.debug((Object)("the process is in reprotect and refactor success: " + recoveryPlan.getName()));
            result = true;
        } else {
            result = this.executeRecoveryProcessor();
        }
        if (!this.isAsyncExecute()) {
            this.endRecoveryProcessor();
        }
        return result;
    }

    protected boolean checkReprotectReentrantable(RecoveryPlan recoveryPlan) {
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus() && String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes);
    }

    public void updateProcessName(String processName) {
        logger.debug((Object)"enter updateProcessName");
        if (!this.isParentNeedCreateDetail() || !this.getIsNeedCreateDetail().booleanValue()) {
            logger.debug((Object)("no need to update: " + processName));
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessName(processName);
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void updateProcessNameParams(String[] procNameParams) {
        logger.info((Object)"enter updateProcessNameParams");
        if (!this.getIsNeedCreateDetail().booleanValue()) {
            logger.info((Object)"no need to updatedetail ");
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessNameParams(RecoveryProcessBaseUtil.constructParamsString(procNameParams));
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void updateProcessDetail(LegoCheckedException ex) {
        this.updateProcessDetail(ex.getErrorMessageKey(), ex.getParameters());
    }

    public void updateProcessDetail(String procDetail, String[] procDetailParams) {
        logger.debug((Object)"enter updateProcessDetail");
        this.setProcDetail(procDetail);
        this.setProcDetailParams(procDetailParams);
        if (!this.getIsNeedCreateDetail().booleanValue()) {
            logger.debug((Object)"no need to updatedetail and param");
            return;
        }
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setProcessDetail(procDetail);
        detail.setProcessDetailParams(RecoveryProcessBaseUtil.constructParamsString(procDetailParams));
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public void setProcessDetailIsSkipped(Boolean isSkipped) {
        logger.debug((Object)"set skip begin");
        RecoveryProcessorDetail detail = this.getCurProcessDetail();
        detail.setIsSkipped(Boolean.valueOf(true));
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        recoveryProcessService.updateRecoveryProcessDetail(detail);
    }

    public RecoveryProcessorDetail createRecoveryProcessorDetail(String logId, String parentProcDetailId, String procId, String procName, String previousProcId, String nextProcId) {
        logger.debug((Object)"enter createRecoveryProcessorDetail");
        HashMap<String, Object> procParams = new HashMap<String, Object>();
        procParams.put(PARAM_PROC_ID, procId);
        procParams.put(PARAM_PROC_NAME, procName);
        procParams.put(PARAM_PROC_NAME_PARAMS, null);
        procParams.put(PARAM_PREVIOUS_PROC_ID, previousProcId);
        procParams.put(PARAM_NEXT_PROC_ID, nextProcId);
        String detailId = this.createRecoveryProcessorDetail(logId, parentProcDetailId, procParams, new Date().getTime());
        RecoveryProcessorDetail procDetail = null;
        if (null != detailId) {
            logger.debug((Object)("detailId is : " + detailId));
            IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
            procDetail = planService.getRecoveryProcessorDetail(detailId);
        }
        return procDetail;
    }

    public int getAssociatedPoType(RecoveryProcessorContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        int poType = ((ProtectGroup)iterator.next()).getPoType();
        return poType;
    }

    protected abstract boolean execute(RecoveryProcessorContext var1);

    protected boolean invoke(RecoveryProcessorContext context) {
        return this.invoke(context, true);
    }

    protected boolean invoke(RecoveryProcessorContext context, boolean isForbidPartSuccess) {
        return this.invoke(context, isForbidPartSuccess, false);
    }

    protected boolean invoke(RecoveryProcessorContext context, boolean isForbidPartSuccess, boolean isConcurrent) {
        return this.invoke(context, isForbidPartSuccess, isConcurrent, false);
    }

    protected boolean invoke(RecoveryProcessorContext context, boolean isForbidPartSuccess, boolean isConcurrent, boolean isSortable) {
        Object processorExecutor;
        List<? extends IProcessor> processors = RecoveryServiceUtil.sortAndUpdateProcessorRation(this.getChildProc(), isSortable);
        if (isConcurrent) {
            processorExecutor = RecoveryProcessConcurrentExecutor.createExecutor(processors);
        } else {
            DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
            processorExecutor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(processors, type);
        }
        processorExecutor.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        return this.checkExecuteResult(isForbidPartSuccess, procStatus.getValue());
    }

    private boolean checkExecuteResult(boolean isForbidPartSuccess, int procStatus) {
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == procStatus) {
            return this.failure();
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procStatus) {
            return this.success();
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == procStatus) {
            if (isForbidPartSuccess) {
                return this.failure();
            }
            return this.success();
        }
        return this.success();
    }

    protected boolean executeSubProcessor(RecoveryProcessorContext context) {
        List<? extends IProcessor> processors = RecoveryServiceUtil.sortAndUpdateProcessorRation(this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor(processors);
        concurrentExecutor.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected String generateResultKey() {
        return null;
    }

    protected Set<AbstractMap.SimpleEntry<String, Boolean>> getPoRecoveryStatus(RecoveryProcessorContext context) {
        logger.debug((Object)"enter getPoRecoveryStatus");
        return new HashSet<AbstractMap.SimpleEntry<String, Boolean>>();
    }

    protected void checkIfHasSubProcessor() {
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"childroc is null");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            throw new LegoCheckedException(Long.MAX_VALUE);
        }
    }

    protected DrmEnumDefine.RecoveryPlanExecuteResultE calcProcStatusBySubProc(Set<RecoveryProcessor> rProcesses) {
        logger.debug((Object)"begin calcProcStatus start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS;
        boolean hasFailed = false;
        boolean hasPartSuccessed = false;
        boolean hasSuccess = false;
        if (!VerifyUtil.isEmpty(rProcesses)) {
            for (RecoveryProcessor process : rProcesses) {
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == process.getProcStatus()) {
                    hasFailed = true;
                    continue;
                }
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == process.getProcStatus()) {
                    hasPartSuccessed = true;
                    continue;
                }
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != process.getProcStatus()) continue;
                if (this.calcCascadeProcessResult(process, DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS)) {
                    hasPartSuccessed = true;
                    continue;
                }
                if (this.calcCascadeProcessResult(process, DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED)) {
                    hasFailed = true;
                    continue;
                }
                hasSuccess = true;
            }
        }
        procStatus = this.getProcStatus(procStatus, hasFailed, hasPartSuccessed, hasSuccess);
        return procStatus;
    }

    private DrmEnumDefine.RecoveryPlanExecuteResultE getProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE procStatus, boolean hasFailed, boolean hasPartSuccessed, boolean hasSuccess) {
        logger.debug((Object)"enter getProcStatus");
        if (hasPartSuccessed || hasFailed && hasSuccess) {
            procStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS;
            this.setContextProcessStatusFailed();
        } else if (hasFailed && !hasSuccess) {
            procStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
            this.setContextProcessStatusFailed();
        } else if (!hasFailed && hasSuccess) {
            procStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS;
        }
        return procStatus;
    }

    protected void setContextProcessStatusFailed() {
        if (null == this.contextRef) {
            logger.error((Object)"the contextRef is null");
            return;
        }
        this.contextRef.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == procStatus.getValue()) {
            logger.debug((Object)"the status is failed");
            return false;
        }
        return true;
    }

    protected boolean saveSubProcessors(Set<RecoveryProcessor> processors) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(processors);
        } else {
            this.setChildProc(processors);
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance();
        IRecoveryProcessBaseService recoveryService = (IRecoveryProcessBaseService)serviceLocator.getService(IRecoveryProcessBaseService.class);
        return recoveryService.updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected boolean saveSubProcessors(List<RecoveryProcessor> processors) {
        if (processors.isEmpty()) {
            return false;
        }
        Set<RecoveryProcessor> linkedRecoveryProcessors = this.linkRecoveryProcessors(processors);
        return this.saveSubProcessors(linkedRecoveryProcessors);
    }

    protected Set<RecoveryProcessor> linkRecoveryProcessors(List<RecoveryProcessor> processors) {
        for (RecoveryProcessor processor : processors) {
            if (processors.stream().filter(arg_0 -> ((RecoveryProcessor)processor).equals(arg_0)).count() <= 1L) continue;
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessor previousProcessor = processors.get(0);
        for (int index = 1; index < processors.size(); ++index) {
            RecoveryProcessor currentProcessor = processors.get(index);
            currentProcessor.setPreviousProcessor(previousProcessor);
            previousProcessor.setNextProcessor(currentProcessor);
            previousProcessor = currentProcessor;
        }
        return new HashSet<RecoveryProcessor>(processors);
    }

    protected <T extends BaseRecoveryProcessor> T createSubProcessor(Supplier<T> supplier) {
        return this.createSubProcessor(supplier, null);
    }

    protected <T extends BaseRecoveryProcessor> T createSubProcessor(Supplier<T> supplier, Consumer<T> initializer) {
        BaseRecoveryProcessor processor = (BaseRecoveryProcessor)((Object)supplier.get());
        if (processor.getProcName() == null) {
            processor.setProcName(processor.getName());
        }
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setParentProc(this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setContextRef(this.getContextRef());
        if (initializer != null) {
            initializer.accept(processor);
        }
        this.syncProcIdTo(processor);
        return (T)((Object)processor);
    }

    protected void updateSubProcessors(Set<RecoveryProcessor> newSubProcessors) {
        if (null == newSubProcessors || newSubProcessors.isEmpty() || null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"param is null");
            return;
        }
        Set<RecoveryProcessor> processes = RecoveryTaskUtil.getRootRecoveryProcessors(this.getChildProc());
        Iterator<RecoveryProcessor> preIterator = processes.iterator();
        Iterator<RecoveryProcessor> newIterator = newSubProcessors.iterator();
        IRecoveryProcessBaseService rProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        while (preIterator.hasNext()) {
            RecoveryProcessor preProcessor = preIterator.next();
            boolean isExist = false;
            while (newIterator.hasNext()) {
                RecoveryProcessor newProcessor = newIterator.next();
                if (!this.isSameProcessor(preProcessor, newProcessor)) continue;
                this.updateProcessorData(preProcessor, newProcessor);
                this.updateCascadeProcessors(preProcessor, newProcessor);
                newIterator.remove();
                newIterator = newSubProcessors.iterator();
                isExist = true;
                break;
            }
            if (isExist) continue;
            rProcessService.deleteRecoveryProcessor(preProcessor.getProcId());
            preIterator.remove();
            preIterator = processes.iterator();
            newIterator = newSubProcessors.iterator();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor recoveryProcess : processes) {
            subProcessors.add(recoveryProcess);
        }
        for (RecoveryProcessor recoveryProcess : newSubProcessors) {
            subProcessors.add(recoveryProcess);
        }
        this.setChildProc(subProcessors);
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess && null == newProcess) {
            logger.debug((Object)"param is null");
            return true;
        }
        if (null != oldProcess) {
            return oldProcess.equals((Object)newProcess);
        }
        return false;
    }

    protected void updateProcessorData(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        logger.debug((Object)"enter updateProcessorData");
        oldProcess.setReentrantable(newProcess.isReentrantable());
    }

    public void endRecoveryProcessor() {
        this.recordProcessResult(this.contextRef);
        this.recordPoRecoveryStatus(this.contextRef);
        this.updateRecoveryPlanProgress(this.contextRef.getRecoveryPlan().getPlanId(), this.getProgressRatio());
        if (this.getIsNeedCreateDetail().booleanValue()) {
            RecoveryProcessorDetail processDetail = this.getCurProcessDetail();
            if (null == processDetail) {
                logger.error((Object)("the processDetail is null: " + this.contextRef.getRecoveryPlan().getPlanId()), 1L);
                return;
            }
            processDetail.setEndTime(String.valueOf(new Date().getTime()));
            processDetail.setProcessStatus(this.getProcStatus());
            IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            recoveryProcessService.updateRecoveryProcessDetail(processDetail);
            if (null != this.taskInterceptor) {
                this.taskInterceptor.after();
            }
        }
    }

    protected List<RecoveryProcessor> getRecoveryProcessors(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, Class<? extends RecoveryProcessor> cls) {
        return BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors(recoveryPlan, execType, cls);
    }

    public static List<RecoveryProcessor> getRecoveryPlanRecoveryProcessors(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, Class<? extends RecoveryProcessor> cls) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        conditions.add(new QueryCondition("procType", (Object)execType.getValue()));
        IRecoveryProcessBaseService rProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        List recoveryProcessors = rProcessService.getRecoveryProcessors(recoveryPlan.getPlanId(), conditions, cls);
        return recoveryProcessors;
    }

    private void recordPoRecoveryStatus(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        try {
            Set<AbstractMap.SimpleEntry<String, Boolean>> poRecoveryStatusEntries = this.getPoRecoveryStatus(context);
            if (VerifyUtil.isEmpty(poRecoveryStatusEntries)) {
                return;
            }
            for (AbstractMap.SimpleEntry<String, Boolean> entry : poRecoveryStatusEntries) {
                String key = entry.getKey();
                Boolean value = entry.getValue();
                Boolean preValue = processResult.getValue(key);
                if (null == preValue) {
                    processResult.addProcessResult(key, value.booleanValue());
                } else {
                    processResult.addProcessResult(key, value != false && preValue != false);
                }
                logger.debug((Object)("Po Recovery Status: Key=" + key + ",Value=" + value + ",PreValue:" + preValue), 90160758784000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting protect object recovery status failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private void recordProcessResult(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        try {
            String resultKey = this.generateResultKey();
            if (null == resultKey || resultKey.trim().isEmpty()) {
                return;
            }
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
                processResult.addProcessResult(resultKey, true);
            } else {
                processResult.addProcessResult(resultKey, false);
            }
        }
        catch (LegoUnsupportedOperationException e) {
            logger.error((Object)e.getMessage(), 90160758784001L);
        }
        catch (Exception e) {
            logger.error((Object)("Generating result key failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        if (!UPDATE_PROGRESS_LOCKER.tryLock(recoveryPlanId, PROCESSOR_TIMEOUT)) {
            logger.error((Object)"Get UPDATE_PROGRESS_LOCK failed. recoveryPlanId: %s", new Object[]{recoveryPlanId});
            return;
        }
        logger.debug((Object)"Get UPDATE_PROGRESS_LOCK success. recoveryPlanId: %s", new Object[]{recoveryPlanId});
        try {
            if (0 < progressRatio && 100 >= progressRatio && (null == this.getParentProc() || this.getParentProc() instanceof IInitialChildProcessor)) {
                IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
                recoveryProcessService.updateRecoveryPlanProgress(recoveryPlanId, progressRatio);
            }
        }
        catch (Throwable throwable) {
            UPDATE_PROGRESS_LOCKER.unlock(recoveryPlanId);
            logger.debug((Object)"Release UPDATE_PROGRESS_LOCK. recoveryPlanId: %s", new Object[]{recoveryPlanId});
            throw throwable;
        }
        UPDATE_PROGRESS_LOCKER.unlock(recoveryPlanId);
        logger.debug((Object)"Release UPDATE_PROGRESS_LOCK. recoveryPlanId: %s", new Object[]{recoveryPlanId});
    }

    private boolean executeRecoveryProcessor() {
        boolean result = true;
        try {
            logger.debug((Object)"Begin to execute processor: %s", new Object[]{((Object)((Object)this)).getClass().getName()});
            result = this.execute(this.contextRef);
            logger.debug((Object)"Execute processor successful....");
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == Long.MAX_VALUE) {
                logger.warn((Object)"The processor has no sub processor. ProcName: %s", new Object[]{this.getProcName()});
            } else {
                logger.error((Throwable)e, (Object)"Executing recovery process[%s] failed.", new Object[]{((Object)((Object)this)).getClass().getName()});
                this.updateProcessDetail(e);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                result = false;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Executing recovery process[%s] failed, message: %s", new Object[]{((Object)((Object)this)).getClass().getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            if (!this.exceptionCaught(e)) {
                this.updateProcessDetail("lego.err.-1", new String[0]);
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            result = false;
        }
        return result;
    }

    protected boolean exceptionCaught(Throwable e) {
        if (e instanceof IllegalArgumentException || e instanceof NullPointerException) {
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return true;
        }
        return false;
    }

    public void beforeExecRecoveryProcessor() {
        if (this.getIsNeedCreateDetail().booleanValue()) {
            String parentDetailId = null;
            if (null != this.getParentProc()) {
                parentDetailId = this.getParentProc().getCurProcessDetail().getDetailId();
            }
            RecoveryProcessor preProcessor = RecoveryProcessBaseUtil.getValidPreviousProcessor(this);
            RecoveryProcessor nextProcessor = RecoveryProcessBaseUtil.getValidNextProcessor(this);
            String previousProcId = null != preProcessor ? preProcessor.getProcId() : null;
            String nextProcId = null != nextProcessor ? nextProcessor.getProcId() : null;
            RecoveryProcessorDetail procDetail = this.createRecoveryProcessorDetail(this.contextRef.getRecoveryLogId(), parentDetailId, this.getProcId(), this.getProcName(), previousProcId, nextProcId);
            this.setCurProcessDetail(procDetail);
        }
        this.prepare();
    }

    private void prepare() {
        String prepareClassName = (String)this.getProps().get(PREPPARE_CLASS);
        String refProcType = (String)this.getProps().get(REF_PROC_TYPE);
        if (null == prepareClassName) {
            return;
        }
        try {
            Class<?> cls = Class.forName(prepareClassName);
            Constructor<?> cons = cls.getConstructor(BaseRecoveryProcessor.class);
            Object interceptor = cons.newInstance(new Object[]{this});
            if (!(interceptor instanceof IRecoveryTaskInterceptor)) {
                return;
            }
            this.taskInterceptor = (IRecoveryTaskInterceptor)interceptor;
            if (null != refProcType) {
                this.taskInterceptor.setRefProcType(refProcType);
            } else {
                this.taskInterceptor.setRefProcType(String.valueOf(this.getProcType()));
            }
            this.taskInterceptor.before();
        }
        catch (Exception e) {
            logger.error((Object)("Construct prepare instance failed, error message :" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void deleteCascadeProcessors(RecoveryProcessor processor) {
        if (null == processor) {
            logger.debug((Object)"processor is null");
            return;
        }
        if (null == processor.getNextCascadeProcessor()) {
            IRecoveryProcessBaseService rProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
            rProcessService.deleteRecoveryProcessor(processor.getProcId());
            return;
        }
        this.deleteCascadeProcessors(processor.getNextCascadeProcessor());
    }

    private void updateCascadeProcessors(RecoveryProcessor preProcessor, RecoveryProcessor newProcessor) {
        if (null == newProcessor.getNextCascadeProcessor()) {
            logger.debug((Object)"param is null");
            return;
        }
        if (null == preProcessor.getNextCascadeProcessor()) {
            preProcessor.setNextCascadeProcessor(newProcessor.getNextCascadeProcessor());
            return;
        }
        if (this.isSameProcessor(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor())) {
            this.updateProcessorData(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor());
            this.updateCascadeProcessors(preProcessor.getNextCascadeProcessor(), newProcessor.getNextCascadeProcessor());
        } else {
            this.deleteCascadeProcessors(preProcessor.getNextCascadeProcessor());
            preProcessor.setNextCascadeProcessor(newProcessor.getNextCascadeProcessor());
        }
    }

    private boolean calcCascadeProcessResult(RecoveryProcessor processor, DrmEnumDefine.RecoveryPlanExecuteResultE resultType) {
        if (null == processor) {
            logger.debug((Object)"processor is null");
            return false;
        }
        if (resultType.getValue() == processor.getProcStatus()) {
            return true;
        }
        if (null != processor.getNextCascadeProcessor()) {
            return this.calcCascadeProcessResult(processor.getNextCascadeProcessor(), resultType);
        }
        return false;
    }

    private String createRecoveryProcessorDetail(String logId, String parentProcDetailId, Map<String, Object> procParams, long startTime) {
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        boolean isUpdate = true;
        RecoveryProcessorDetail procDetail = null;
        String procId = String.valueOf(procParams.get(PARAM_PROC_ID));
        if (null == parentProcDetailId) {
            logger.debug((Object)("parentProcDetailId is null: " + logId));
            procDetail = recoveryProcessService.getRecoveryProcessDetail(logId, procId);
        }
        if (null == procDetail) {
            procDetail = new RecoveryProcessorDetail();
            procDetail.setDetailId(UUIDGenerator.getUUID());
            isUpdate = false;
        }
        procDetail.setStartTime(String.valueOf(startTime));
        procDetail.setProcId(procId);
        if (null != procParams.get(PARAM_PREVIOUS_PROC_ID)) {
            procDetail.setPreviousProcId(String.valueOf(procParams.get(PARAM_PREVIOUS_PROC_ID)));
        }
        if (null != procParams.get(PARAM_NEXT_PROC_ID)) {
            procDetail.setNextProcId(String.valueOf(procParams.get(PARAM_NEXT_PROC_ID)));
        }
        procDetail.setProcessName(String.valueOf(procParams.get(PARAM_PROC_NAME)));
        if (procParams.get(PARAM_PROC_STATUS) != null) {
            procDetail.setProcessStatus(((Integer)procParams.get(PARAM_PROC_STATUS)).intValue());
        } else {
            procDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
        }
        procDetail.setLogId(logId);
        String[] procNameParams = null;
        Object procNameParamsObj = procParams.get(PARAM_PROC_NAME_PARAMS);
        if (null != procNameParamsObj) {
            procNameParams = (String[])procNameParamsObj;
        }
        String params = RecoveryProcessBaseUtil.constructParamsString(procNameParams);
        procDetail.setProcessNameParams(params);
        procDetail.setParentDetailId(parentProcDetailId);
        String detailId = recoveryProcessService.createRecoveryProcessDetail(procDetail, isUpdate);
        return detailId;
    }

    protected String getVstoreId(RecoveryProcessorContext context) {
        logger.debug((Object)("not support" + context));
        return null;
    }

    protected boolean serialExcuteChildProc(RecoveryProcessorContext context) {
        Set subProcessors = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)subProcessors)) {
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE execType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList(subProcessors), execType);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        return executeResult;
    }

    protected boolean updateSubProcessors(RecoveryProcessor processor) {
        if (null != this.getChildProc()) {
            this.getChildProc().clear();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        this.initProcessor(processor);
        subProcessors.add(processor);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected void initProcessor(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public void createRecoveryProcessorDetail(RecoveryProcessorDetail procDetail) {
        HashMap<String, Object> procParams = new HashMap<String, Object>();
        procParams.put(PARAM_PROC_ID, procDetail.getProcId());
        procParams.put(PARAM_PROC_NAME, procDetail.getProcessName());
        procParams.put(PARAM_PROC_NAME_PARAMS, null);
        procParams.put(PARAM_PREVIOUS_PROC_ID, procDetail.getPreviousProcId());
        procParams.put(PARAM_NEXT_PROC_ID, procDetail.getNextProcId());
        procParams.put(PARAM_PROC_STATUS, procDetail.getProcessStatus());
        this.createRecoveryProcessorDetail(procDetail.getLogId(), procDetail.getParentDetailId(), procParams, new Date().getTime());
    }

    protected boolean executeLocalScript(String scriptName, JSONObject scriptParams, boolean isReplayWhenSucc) {
        boolean isLocalScriptExecOk;
        int successValue = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        if (successValue == this.getProcStatus() && !isReplayWhenSucc) {
            logger.info((Object)("The script has been executed successfully: " + scriptName), 90160758786816L);
            return true;
        }
        try {
            isLocalScriptExecOk = ExecuteLocalScriptUtil.executeLocalScript(scriptName, scriptParams);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Script executed failed: " + e.getMessage()), 90160758787071L);
            this.updateProcessDetail(e.getMessage(), new String[0]);
            isLocalScriptExecOk = false;
        }
        catch (Exception e) {
            logger.error((Object)"Unknown exception occurred", (Throwable)e, 90160758787071L);
            this.updateProcessDetail("ism.drm.recovery.process.excute.script.failed", new String[0]);
            isLocalScriptExecOk = false;
        }
        this.updateExecuteResult(isLocalScriptExecOk);
        boolean isContinueIfFailed = Boolean.parseBoolean((String)this.getProps().get("EXECUTE_POLICY"));
        if (!isLocalScriptExecOk && !isContinueIfFailed) {
            logger.info((Object)"Failed to execute script.", 90160758787071L);
            return false;
        }
        return true;
    }

    protected String getSiteIdByDeviceSn(String devSn) {
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        return Optional.ofNullable(siteService.getSiteByDeviceSn(devSn)).map(Site::getSiteId).orElseThrow(() -> new LegoCheckedException(2117645L));
    }
}

