/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.framework.process.AbstractPgLockingCustomPreProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DisasterRecoveryPgLockingCustomPreProcessor
extends AbstractPgLockingCustomPreProcessor {
    private static final Log LOG = LogFactory.getInstance(DisasterRecoveryPgLockingCustomPreProcessor.class);

    @Override
    public Map<String, Object> process(RecoveryPlan plan) {
        Boolean lockResult;
        HashMap<String, Object> result;
        block5: {
            result = new HashMap<String, Object>();
            IRecoveryProcessBaseHandler recoveryProcHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            lockResult = false;
            try {
                Future<Boolean> future = FixedRecoveryThreadPool.submitFast(() -> recoveryProcHandler.lockProtectGroups(plan.getProtectGroups()));
                lockResult = future.get(40L, TimeUnit.SECONDS);
            }
            catch (LegoCheckedException | InterruptedException | ExecutionException | TimeoutException ex) {
                LOG.error((Object)"Lock pg for plan(%s) failed. ErrMsg: %s", new Object[]{plan.getUuid(), ExceptionUtil.getErrorMessage((Throwable)ex)});
                if (!plan.getProtectGroups().stream().anyMatch(pg -> PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType()))) break block5;
                ExceptionUtil.rethrowException((Throwable)ex, (String)("HCS type! get po lock failed" + plan.getUuid()), (long)1073948693L, (String[])new String[0], (Log)this.getLogger());
            }
        }
        if (lockResult != null && lockResult.booleanValue()) {
            result.put("LockProtectGroup", lockResult);
        }
        return result;
    }

    public String getType() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.name();
    }
}

