/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class EndRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1410992583871817347L;
    private static final Log logger = LogFactory.getInstance(EndRecoveryProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        int procResult = this.getPreviousProcessorStatus();
        this.setProcStatus(procResult);
        return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == procResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        if (!UPDATE_PROGRESS_LOCKER.tryLock(recoveryPlanId, PROCESSOR_TIMEOUT)) {
            logger.error((Object)"Get UPDATE_PROGRESS_LOCK failed. recoveryPlanId: %s", new Object[]{recoveryPlanId});
            return;
        }
        logger.debug((Object)"Get UPDATE_PROGRESS_LOCK success. recoveryPlanId: %s", new Object[]{recoveryPlanId});
        try {
            if (0 < progressRatio && 100 >= progressRatio && (this.getChildProc() == null || this.getChildProc().isEmpty()) && !this.getHasChildProc().booleanValue()) {
                IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
                recoveryProcessService.updateRecoveryPlanProgress(recoveryPlanId, 100);
            }
        }
        catch (Throwable throwable) {
            UPDATE_PROGRESS_LOCKER.unlock(recoveryPlanId);
            logger.debug((Object)"Release UPDATE_PROGRESS_LOCK. recoveryPlanId: %s", new Object[]{recoveryPlanId});
            throw throwable;
        }
        UPDATE_PROGRESS_LOCKER.unlock(recoveryPlanId);
        logger.debug((Object)"Release UPDATE_PROGRESS_LOCK. recoveryPlanId: %s", new Object[]{recoveryPlanId});
    }

    @Override
    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName(this.calcProcessName());
    }

    public int getPreviousProcessorStatus() {
        RecoveryProcessor preProcessor;
        for (preProcessor = this.getPreviousProcessor(); !(null == preProcessor || preProcessor.getIsEnabled().booleanValue() && preProcessor.getIsResultProcessor().booleanValue()); preProcessor = preProcessor.getPreviousProcessor()) {
        }
        int procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        if (null != preProcessor) {
            procResult = preProcessor.getProcStatus();
            Boolean isContinueIfFailed = Boolean.parseBoolean((String)preProcessor.getProps().get("EXECUTE_POLICY"));
            if (isContinueIfFailed.booleanValue()) {
                return DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
            }
        }
        return procResult;
    }

    private String calcProcessName() {
        String processName = null;
        processName = DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType() ? "ism.drm.clean.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() ? "ism.drm.testing.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue() == this.getProcType() ? "ism.drm.planedmotion.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() == this.getProcType() ? "ism.drm.reprotect.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP.getValue() == this.getProcType() ? "ism.drm.swap.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.umountReplica.end.process.name" : (DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue() == this.getProcType() ? "ism.drm.mountReplica.end.process.name" : "ism.drm.recovery.end.process.name"))))));
        return processName;
    }

    public void updateDescription() {
        this.setDescription("ism.drm.recovery.end.process.des");
    }

    public String getStepPosition() {
        return "End";
    }
}

