/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.provider.AbstractBaseRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.framework.provider.DeleteProcessorByNameComparator;
import com.huawei.ism.drm.recovery.framework.provider.IComparator;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessBaseUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseRecoveryProcessVRProvider
extends AbstractBaseRecoveryProcessProvider
implements IRecoveryProcessBaseProvider {
    private static final Log logger = LogFactory.getInstance(BaseRecoveryProcessVRProvider.class);
    private static List<Integer> isSuitablePtTypesForLocalList = new ArrayList<Integer>();
    private static List<Integer> isSuitablePtTypesForRemoteList = new ArrayList<Integer>();
    private static List<Integer> supportedPolicyTplTypesForReprotect = new ArrayList<Integer>();
    private static List<Integer> unSupportedTypesForReprotectOnRemoteDisasterSite = new ArrayList<Integer>();

    @Override
    protected List<DrmEnumDefine.RecoveryPlanExecuteTypeE> getSuitableProcTypes(RecoveryPlan recoveryPlan) {
        ArrayList<DrmEnumDefine.RecoveryPlanExecuteTypeE> procTypes = new ArrayList<DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        logger.debug((Object)"The recoveryPlan.getPlanType()=%s.", new Object[]{String.valueOf(recoveryPlan.getPlanType())});
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType()) {
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK);
        } else {
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP);
        }
        return procTypes;
    }

    @Override
    protected boolean isSuitablePtTypesForLocal(Integer policyTemplateType) {
        return isSuitablePtTypesForLocalList.contains(policyTemplateType);
    }

    @Override
    protected boolean isSuitablePtTypesForRemote(Integer policyTemplateType) {
        return isSuitablePtTypesForRemoteList.contains(policyTemplateType);
    }

    public void checkIfAllowReprotect(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The recoveryPlan is null or getProtectGroups is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            return;
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (!supportedPolicyTplTypesForReprotect.contains(policyTemplateType)) {
            logger.error((Object)"Reprotect is not supported for the policy template.");
            throw new LegoCheckedException(1073948736L);
        }
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        ProtectGroupReplica pgReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            break;
        }
        if (pgReplica == null) {
            logger.error((Object)"There is no suited protect group replica.");
            throw new LegoCheckedException(-1L);
        }
        if (unSupportedTypesForReprotectOnRemoteDisasterSite.contains(policyTemplateType) && this.isRecoveryToRemoteDisasterSite(pgReplica)) {
            logger.error((Object)"Reprotect is not supported after switching to remote disaster center.");
            throw new LegoCheckedException(1073948737L);
        }
    }

    public boolean checkProductionBusinessStopped(RecoveryProcessorContext context) {
        if (context == null) {
            logger.debug((Object)"The param context is null.");
            return true;
        }
        String productionSiteId = RecoveryServiceUtil.getProductSiteId(context.getRecoveryPlan());
        Site productionSite = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(productionSiteId);
        Object object = context.getAttribute("recoveryTasks");
        if (object == null) {
            return true;
        }
        Collection recoveryTasks = (Collection)object;
        Set<RecoveryTask> rootRecoveryTasks = RecoveryTaskUtil.getRootRecoveryTasks(recoveryTasks);
        boolean isRollbackType = false;
        if (null != context.getAttribute("PLAN_EXEXUTE_TYPE")) {
            boolean bl = isRollbackType = DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK == (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        }
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == context.getRecoveryPlan().getPlanType() || isRollbackType) {
            return RecoveryProcessBaseUtil.isAllSrcLunUnMapping(context, rootRecoveryTasks);
        }
        return RecoveryProcessBaseUtil.isAllSrcLunUnMapping(context, productionSite, rootRecoveryTasks);
    }

    public void updateRecoveryProcessorEnableStatus(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> processores, boolean isEnable) {
        logger.debug((Object)"begin updateRecoveryProcessorEnableStatus");
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        for (RecoveryProcessor processor : recoveryProcessDef.getRecoveryProcessors()) {
            if (!this.isSameRecoveryProcess(processor, processores)) continue;
            recoveryProcessService.deleteSubRecoveryProcessor(processor.getProcId());
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            recoveryProcessService.updateRecoveryProcessor(processor);
        }
    }

    public void enableRecoverySyncProcessor(RecoveryProcessDefinition recoveryProcessDef, boolean isNeedUpdateDb) {
        Class<? extends RecoveryProcessor> syncProcessor = RecoveryProcessorMgr.getInstance().getSyncProcessor(recoveryProcessDef.getProtectionType());
        if (syncProcessor == null) {
            logger.debug((Object)"Param syncProcessor is null.");
            return;
        }
        ArrayList<Class<? extends RecoveryProcessor>> classes = new ArrayList<Class<? extends RecoveryProcessor>>();
        classes.add(syncProcessor);
        if (isNeedUpdateDb) {
            this.updateRecoveryProcessorEnableStatus(recoveryProcessDef, classes, true);
        } else {
            this.setRecoveryProcessorEnableStatus(recoveryProcessDef, classes, true);
        }
    }

    public void disableRecoverySyncProcessor(RecoveryProcessDefinition recoveryProcessDef, boolean isNeedUpdateDb) {
        Class<? extends RecoveryProcessor> syncProcessor = RecoveryProcessorMgr.getInstance().getSyncProcessor(recoveryProcessDef.getProtectionType());
        if (syncProcessor == null) {
            logger.debug((Object)"Param syncProcessor is null.");
            return;
        }
        ArrayList<Class<? extends RecoveryProcessor>> classes = new ArrayList<Class<? extends RecoveryProcessor>>();
        classes.add(syncProcessor);
        if (isNeedUpdateDb) {
            this.updateRecoveryProcessorEnableStatus(recoveryProcessDef, classes, false);
        } else {
            this.setRecoveryProcessorEnableStatus(recoveryProcessDef, classes, false);
        }
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, Class<? extends RecoveryProcessor> afterProcCls, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        logger.debug((Object)"null implement");
        return null;
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, RecoveryProcessor afterProcessor, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        logger.debug((Object)"null implement");
        return null;
    }

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDefinition, String procId, Map<String, Object> params) {
        logger.debug((Object)"null implement");
    }

    @Override
    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, final String procId, boolean isNeedUpdateDb) {
        if (null == recoveryProcessDef || null == procId || procId.isEmpty()) {
            logger.debug((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        IComparator<RecoveryProcessor> comparator = new IComparator<RecoveryProcessor>(){

            @Override
            public boolean isEqual(RecoveryProcessor processor) {
                return null != processor && processor.getProcId().equals(procId);
            }
        };
        this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
    }

    @Override
    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> procClsList, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || null == procClsList || procClsList.isEmpty()) {
            logger.debug((Object)"param is null");
            return;
        }
        for (Class<? extends RecoveryProcessor> rprocCls : procClsList) {
            DeleteProcessorByNameComparator comparator = new DeleteProcessorByNameComparator(rprocCls);
            this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
        }
    }

    private void removeRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator, boolean isNeedUpdateDb) {
        RecoveryProcessor delProcessor = this.getDeletedRecoveryProcessor(recoveryProcessDef, comparator);
        if (null == delProcessor) {
            logger.error((Object)"The processor does not exist.", 90160758784001L);
            return;
        }
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        RecoveryProcessor preProcessor = delProcessor.getPreviousProcessor();
        RecoveryProcessor nextProcessor = delProcessor.getNextProcessor();
        if (null != preProcessor) {
            preProcessor.setNextProcessor(nextProcessor);
        }
        if (null != nextProcessor) {
            nextProcessor.setPreviousProcessor(preProcessor);
        }
        delProcessor.setPreviousProcessor(null);
        delProcessor.setNextProcessor(null);
        if (isNeedUpdateDb) {
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
            recoveryProcessService.deleteRecoveryProcessor(delProcessor);
        }
        recoveryProcessDef.getRecoveryProcessors().remove(delProcessor);
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition rpDef, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        logger.debug((Object)"return null");
        return null;
    }

    public List<RecoveryProcessor> filterProcessor(List<RecoveryProcessor> processors, Map<String, String> filters) {
        return null;
    }

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass() {
        logger.debug((Object)"return null");
        return null;
    }

    static {
        isSuitablePtTypesForRemoteList.add(6);
        isSuitablePtTypesForRemoteList.add(5);
        isSuitablePtTypesForRemoteList.add(4);
        isSuitablePtTypesForRemoteList.add(3);
        isSuitablePtTypesForRemoteList.add(0);
        isSuitablePtTypesForRemoteList.add(1);
        isSuitablePtTypesForRemoteList.add(18);
        isSuitablePtTypesForRemoteList.add(20);
        isSuitablePtTypesForRemoteList.add(21);
        isSuitablePtTypesForRemoteList.add(22);
        isSuitablePtTypesForRemoteList.add(23);
        isSuitablePtTypesForRemoteList.add(24);
        isSuitablePtTypesForRemoteList.add(25);
        isSuitablePtTypesForRemoteList.add(26);
        isSuitablePtTypesForRemoteList.add(27);
        isSuitablePtTypesForRemoteList.add(30);
        isSuitablePtTypesForRemoteList.add(31);
        isSuitablePtTypesForRemoteList.add(32);
        isSuitablePtTypesForRemoteList.add(35);
        isSuitablePtTypesForRemoteList.add(36);
        isSuitablePtTypesForRemoteList.add(33);
        isSuitablePtTypesForRemoteList.add(39);
        isSuitablePtTypesForRemoteList.add(51);
        isSuitablePtTypesForRemoteList.add(52);
        isSuitablePtTypesForRemoteList.add(34);
        isSuitablePtTypesForRemoteList.add(37);
        isSuitablePtTypesForLocalList.add(2);
        isSuitablePtTypesForLocalList.add(14);
        isSuitablePtTypesForLocalList.add(19);
        isSuitablePtTypesForLocalList.add(17);
        isSuitablePtTypesForLocalList.add(28);
        isSuitablePtTypesForLocalList.add(15);
        supportedPolicyTplTypesForReprotect.add(6);
        supportedPolicyTplTypesForReprotect.add(5);
        supportedPolicyTplTypesForReprotect.add(4);
        supportedPolicyTplTypesForReprotect.add(3);
        supportedPolicyTplTypesForReprotect.add(0);
        supportedPolicyTplTypesForReprotect.add(1);
        supportedPolicyTplTypesForReprotect.add(11);
        supportedPolicyTplTypesForReprotect.add(18);
        supportedPolicyTplTypesForReprotect.add(20);
        supportedPolicyTplTypesForReprotect.add(21);
        supportedPolicyTplTypesForReprotect.add(22);
        supportedPolicyTplTypesForReprotect.add(23);
        supportedPolicyTplTypesForReprotect.add(24);
        supportedPolicyTplTypesForReprotect.add(25);
        supportedPolicyTplTypesForReprotect.add(26);
        supportedPolicyTplTypesForReprotect.add(27);
        supportedPolicyTplTypesForReprotect.add(30);
        supportedPolicyTplTypesForReprotect.add(31);
        supportedPolicyTplTypesForReprotect.add(32);
        supportedPolicyTplTypesForReprotect.add(34);
        supportedPolicyTplTypesForReprotect.add(37);
        supportedPolicyTplTypesForReprotect.add(35);
        supportedPolicyTplTypesForReprotect.add(36);
        supportedPolicyTplTypesForReprotect.add(33);
        supportedPolicyTplTypesForReprotect.add(39);
        supportedPolicyTplTypesForReprotect.add(51);
        supportedPolicyTplTypesForReprotect.add(52);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(5);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(4);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(3);
        unSupportedTypesForReprotectOnRemoteDisasterSite.add(35);
    }
}

