/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessCascadeExecutor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class AbstractRecoveryProcessSerialExecutor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryProcessSerialExecutor.class);
    protected String name;
    protected List<IProcessor> processors = new ArrayList<IProcessor>();
    protected int curProcessorIndex = -1;

    /*
     * WARNING - void declaration
     */
    protected void init(String templateName, List<? extends IProcessor> processorList) {
        if (templateName == null || processorList == null || processorList.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.name = templateName;
        for (IProcessor iProcessor : processorList) {
            void var4_4;
            RecoveryProcessor reProcessor;
            if (iProcessor instanceof RecoveryProcessor && (reProcessor = (RecoveryProcessor)iProcessor).getNextCascadeProcessor() != null) {
                RecoveryProcessCascadeExecutor recoveryProcessCascadeExecutor = RecoveryProcessCascadeExecutor.createExecutor(reProcessor);
            }
            this.processors.add((IProcessor)var4_4);
        }
    }

    protected static String getTemplateName() {
        return "RCT_" + UUIDGenerator.getUUID();
    }

    public boolean isAllProcessorCompleted() {
        boolean isEnd;
        boolean bl = isEnd = this.curProcessorIndex == this.processors.size() - 1;
        if (VerifyUtil.isEmpty(this.processors)) {
            return isEnd;
        }
        return this.processors.stream().noneMatch(processor -> {
            boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
            if (!isRecoveryProcessor) {
                return false;
            }
            RecoveryProcessor recoveryProcessor = (RecoveryProcessor)processor;
            if (recoveryProcessor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue()) {
                return true;
            }
            Set childProcs = recoveryProcessor.getChildProc();
            if (VerifyUtil.isEmpty((Collection)childProcs)) {
                return false;
            }
            return childProcs.stream().anyMatch(child -> child.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        });
    }

    public DrmEnumDefine.RecoveryPlanExecuteResultE getLastProcessorResult() {
        DrmEnumDefine.RecoveryPlanExecuteResultE result = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
        if (this.processors != null && !this.processors.isEmpty()) {
            for (int ii = this.processors.size() - 1; ii >= 0; --ii) {
                RecoveryProcessor recoveryProcessor = (RecoveryProcessor)this.processors.get(ii);
                if (!recoveryProcessor.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)recoveryProcessor.getProcStatus());
            }
        }
        return result;
    }

    public boolean process(RecoveryProcessorContext context) {
        return this.callProcessors(context);
    }

    public String getName() {
        return this.name;
    }

    private boolean callProcessors(RecoveryProcessorContext context) {
        IProcessor processor = null;
        boolean isNormal = true;
        try {
            int size = this.processors.size();
            for (int ii = 0; ii < size; ++ii) {
                RecoveryProcessor recoveryProcessor;
                processor = this.processors.get(ii);
                if (processor == null) continue;
                this.curProcessorIndex = ii;
                boolean isRecoveryProcessor = processor instanceof RecoveryProcessor;
                if (isRecoveryProcessor && (!(recoveryProcessor = (RecoveryProcessor)processor).getIsEnabled().booleanValue() || this.checkMotionContinue(context, (IProcessor)recoveryProcessor))) continue;
                boolean processResult = processor.process(context);
                if (isRecoveryProcessor) {
                    RecoveryProcessor recoveryProcessor2 = (RecoveryProcessor)processor;
                    ((IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class)).updateRecoveryProcessor(recoveryProcessor2);
                }
                if (!processResult) {
                    isNormal = false;
                    break;
                }
                this.dealMotionPaused(context, processor, ii, size);
            }
        }
        catch (Exception e) {
            isNormal = this.callProcessorsException(context, processor, e);
        }
        return isNormal;
    }

    protected abstract boolean checkMotionContinue(RecoveryProcessorContext var1, IProcessor var2);

    protected abstract void dealMotionPaused(RecoveryProcessorContext var1, IProcessor var2, int var3, int var4);

    protected boolean callProcessorsException(RecoveryProcessorContext context, IProcessor processor, Exception ex) {
        String processorName = "";
        if (processor != null) {
            processorName = processor.getName();
        }
        logger.error((Object)"Calling processor failed. Name:%s,error is %s.", new Object[]{processorName, ExceptionUtil.getErrorMessage((Throwable)ex)});
        this.setContextErrorCode(context, ex);
        return false;
    }

    protected void setContextErrorCode(RecoveryProcessorContext context, Throwable ex) {
        if (ex instanceof LegoCheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoCheckedException)ex).getErrorCode());
        } else if (ex instanceof LegoUncheckedException) {
            context.setAttribute("icommand:errorcode", (Object)((LegoUncheckedException)ex).getErrorCode());
        } else {
            context.setAttribute("icommand:errorcode", (Object)0x200909L);
        }
    }
}

