/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.google.common.base.Charsets;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.sun.javafx.PlatformUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExecuteLocalScriptUtil {
    private static final Log logger = LogFactory.getInstance(ExecuteLocalScriptUtil.class);
    private static final String BACK_PATH = "/Runtime/LegoRuntime/tools/thirdParty";
    private static final long THIRTY_MINUTES = 1800000L;
    private static final Charset CODE_UTF_8 = Charsets.UTF_8;
    private static final String SUCCESS_RESULT = "Result:0";
    private static final Map<String, Boolean> supportedScriptType = new HashMap<String, Boolean>();
    private static final String EXECUTING_SCRIPT_FAILED = "ism.drm.recovery.process.excute.script.failed";
    private static final String EXECUTING_SCRIPT_TIMEOUT = "ism.drm.recovery.process.excute.script.timeout";

    public static boolean executeLocalScript(String scriptName) throws LegoCheckedException {
        return ExecuteLocalScriptUtil.executeLocalScript(scriptName, null);
    }

    public static boolean executeLocalScript(String scriptName, JSONObject scriptParams) throws LegoCheckedException {
        return ExecuteLocalScriptUtil.executeLocalScript(scriptName, null, scriptParams);
    }

    public static boolean executeLocalScript(String scriptName, String relativeScriptPath, JSONObject scriptParams) throws LegoCheckedException {
        logger.info((Object)"Prepare to exec script: %s", new Object[]{scriptName});
        if (!ExecuteLocalScriptUtil.isFileValid(scriptName)) {
            logger.error((Object)"File name Is invalid: %s", new Object[]{scriptName});
            throw new LegoCheckedException("ism.drm.recovery.process.script.file.name.is.invalid");
        }
        String filePath = ExecuteLocalScriptUtil.getFilePath(relativeScriptPath);
        if (!ExecuteLocalScriptUtil.isFileExist(filePath, scriptName)) {
            logger.error((Object)"File Is not exist: %s", new Object[]{scriptName});
            throw new LegoCheckedException("ism.drm.recovery.process.script.file.is.not.exist");
        }
        if (!ExecuteLocalScriptUtil.isFileCanExecute(filePath, scriptName)) {
            logger.error((Object)"File can not be accessible: %s", new Object[]{scriptName});
            throw new LegoCheckedException("ism.drm.recovery.process.script.file.is.not.accesible");
        }
        boolean executeResult = ExecuteLocalScriptUtil.executeScript(filePath, scriptName, scriptParams);
        if (!executeResult) {
            logger.error((Object)"Failed to execute script: %s", new Object[]{scriptName});
            return false;
        }
        return true;
    }

    private static boolean isFileCanExecute(String filePath, String scriptName) {
        if (VerifyUtil.isEmpty((String)filePath)) {
            logger.error((Object)"FilePath is empty");
            return false;
        }
        File scriptFile = new File(filePath + File.separator + scriptName);
        if (scriptFile.canExecute()) {
            return true;
        }
        logger.error((Object)"File can not be executed");
        return false;
    }

    private static boolean isFileValid(String fileName) {
        if (VerifyUtil.isEmpty((String)fileName)) {
            logger.error((Object)"FileName is empty");
            return false;
        }
        String reg = "^([a-zA-Z0-9_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\\w-]*(\\.bat|\\.sh){1})$";
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFKC);
        Matcher matcher = Pattern.compile(reg).matcher(fileName);
        if (!matcher.matches()) {
            logger.error((Object)"FileName is invalid: %s", new Object[]{fileName});
            return false;
        }
        String scriptType = fileName.substring(fileName.indexOf(".") + 1);
        if (!supportedScriptType.get(scriptType).booleanValue()) {
            logger.error((Object)"This kind of script type not fit to the current os: %s", new Object[]{fileName});
            return false;
        }
        return true;
    }

    private static boolean executeScript(String filePath, String scriptName, JSONObject scriptParams) {
        boolean runResult;
        if (VerifyUtil.isEmpty((String)filePath)) {
            logger.error((Object)"FilePath is empty: %s", new Object[]{scriptName});
            return false;
        }
        String cmd = filePath + File.separator + scriptName;
        try {
            runResult = ExecuteLocalScriptUtil.runShell(cmd, scriptParams);
        }
        catch (Exception e) {
            if (e instanceof LegoCheckedException) {
                throw e;
            }
            logger.error((Object)"Executing script failed for the exception is %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(EXECUTING_SCRIPT_FAILED, (Throwable)e);
        }
        return runResult;
    }

    private static boolean runShell(String shStr, JSONObject scriptParams) {
        Process process;
        String[] commands = ExecuteLocalScriptUtil.getAndCheckCommands(shStr);
        ProcessBuilder builder = new ProcessBuilder(commands);
        ExecuteLocalScriptUtil.injectScriptParams(builder, scriptParams);
        try {
            process = builder.start();
        }
        catch (IOException e) {
            logger.error((Object)"The shell running failed for the exception is %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(EXECUTING_SCRIPT_FAILED);
        }
        InputStream tempErrorStream = process.getErrorStream();
        InputStream tempInputStream = process.getInputStream();
        ExecuteThread errorStream = new ExecuteThread(tempErrorStream);
        ExecuteThread inputStream = new ExecuteThread(tempInputStream);
        errorStream.start();
        inputStream.start();
        try {
            boolean hasResult = process.waitFor(1800000L, TimeUnit.SECONDS);
            if (!hasResult) {
                logger.warn((Object)"The shell running is timeout");
                throw new LegoCheckedException(EXECUTING_SCRIPT_TIMEOUT);
            }
        }
        catch (InterruptedException ex) {
            logger.error((Object)"The running process for this shell is interrupted: %s", new Object[]{shStr, ex});
            throw new LegoCheckedException(EXECUTING_SCRIPT_TIMEOUT);
        }
        try {
            errorStream.join(1800000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"The shell running failed for reading errorStream timeout", (Throwable)e);
            throw new LegoCheckedException(EXECUTING_SCRIPT_TIMEOUT, (Throwable)e);
        }
        try {
            inputStream.join(1800000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"The shell running failed for reading inputStream timeout", (Throwable)e);
            throw new LegoCheckedException(EXECUTING_SCRIPT_TIMEOUT);
        }
        String errStr = errorStream.getReturnValue().toString().trim();
        String sucStr = inputStream.getReturnValue().toString().trim();
        int exitValue = process.exitValue();
        return ExecuteLocalScriptUtil.runResult(errStr, sucStr, exitValue);
    }

    private static boolean runResult(String errStr, String sucStr, int exitValue) {
        if (exitValue != 0) {
            if (sucStr.contains(SUCCESS_RESULT)) {
                logger.debug((Object)"Success result: \n%s", new Object[]{sucStr});
                return true;
            }
            logger.error((Object)"The shell running failed because of %s", new Object[]{errStr});
            throw new LegoCheckedException(EXECUTING_SCRIPT_FAILED);
        }
        return true;
    }

    private static String[] getAndCheckCommands(String shStr) {
        if (SecurityUtil.fileValueBlackListCheck((String)shStr)) {
            logger.error((Object)"The input shStr is illegal.");
            throw new LegoCheckedException(EXECUTING_SCRIPT_FAILED);
        }
        String[] commands = ExecuteLocalScriptUtil.generateCmd(shStr);
        commands[1] = StringEscapeUtil.escape((String)commands[1]);
        File file = Paths.get(commands[1], new String[0]).toFile();
        if (!file.exists()) {
            logger.error((Object)"The shell file does not exist: %s", new Object[]{shStr});
            throw new LegoCheckedException("ism.drm.recovery.process.script.file.is.not.exist");
        }
        return commands;
    }

    private static void injectScriptParams(ProcessBuilder builder, JSONObject scriptParams) {
        if (scriptParams != null && scriptParams.size() != 0) {
            Map<String, String> environment = builder.environment();
            environment.putAll((Map<String, String>)scriptParams);
        }
    }

    private static boolean isFileExist(String filePath, String scriptName) {
        if (VerifyUtil.isEmpty((String)filePath)) {
            logger.error((Object)"The filePath is null or empty.");
            return false;
        }
        File dir = new File(filePath);
        if (!dir.isDirectory()) {
            logger.error((Object)"The filePath is not a directory: %s", new Object[]{dir.getName()});
            return false;
        }
        FilenameFilter filter = (ignore, name) -> name.endsWith(".sh");
        File[] fileList = Optional.ofNullable(dir.listFiles(filter)).orElseGet(() -> new File[0]);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : fileList) {
            fileNames.add(file.getName());
        }
        if (fileNames.contains(scriptName)) {
            logger.debug((Object)"The target script exists");
            return true;
        }
        logger.info((Object)"Script does not exist: %s", new Object[]{scriptName});
        return false;
    }

    private static String getFilePath(String relativeScriptPath) {
        String userDir = System.getProperties().getProperty("user.dir");
        logger.debug((Object)"Got user directory");
        if (VerifyUtil.isEmpty((String)userDir)) {
            logger.error((Object)"There is no directory from system property user.dir");
            throw new LegoCheckedException(-1L);
        }
        int pos = userDir.lastIndexOf("LegoRuntime");
        if (pos < 0) {
            logger.error((Object)"The install directory of system does not exists.");
            throw new LegoCheckedException(-1L);
        }
        String appInstallPath = "";
        String installFile = userDir.substring(0, pos) + "bin" + File.separator + "RDInstalled.xml";
        File file = new File(installFile);
        try {
            DocumentBuilder builder = CommonUtil.createDocumentBuilder((boolean)false);
            Document doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("install");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element bookElement = (Element)nl.item(i);
                NodeList childNodes = bookElement.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node node = childNodes.item(j);
                    String installPath = ExecuteLocalScriptUtil.degradeParseXML(node);
                    if (VerifyUtil.isEmpty((String)installPath)) continue;
                    appInstallPath = installPath;
                }
            }
            logger.debug((Object)"Get app install path");
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"ParseXML error:", (long)-1L, null, (Log)logger);
        }
        return appInstallPath + (relativeScriptPath == null ? BACK_PATH : relativeScriptPath);
    }

    private static String degradeParseXML(Node node) {
        if (node.getNodeType() == 1 && "installpath".equals(node.getNodeName())) {
            NamedNodeMap nnm = node.getAttributes();
            return nnm.getNamedItem("path").getNodeValue();
        }
        return "";
    }

    private static String[] generateCmd(String shStr) {
        String[] resultCmdArray = new String[]{"", "", ""};
        resultCmdArray[0] = "/bin/sh";
        resultCmdArray[1] = shStr;
        return resultCmdArray;
    }

    static {
        supportedScriptType.put("sh", PlatformUtil.isLinux() || PlatformUtil.isUnix());
    }

    static class ExecuteThread
    extends Thread {
        private InputStreamReader inputStreamReader;
        private StringBuilder returnValue;

        public ExecuteThread(InputStream inputStream) {
            try {
                if (null != inputStream) {
                    this.inputStreamReader = new InputStreamReader(inputStream, CODE_UTF_8);
                }
            }
            catch (UnsupportedCharsetException e) {
                logger.error((Object)"Charset uft-8 not supported: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            this.returnValue = new StringBuilder();
        }

        public StringBuilder getReturnValue() {
            return this.returnValue;
        }

        @Override
        public void run() {
            try (InputStreamReader inputReader = this.inputStreamReader;
                 SafeBufferedReader bufferedReader = new SafeBufferedReader((Reader)inputReader);){
                String readValue;
                while (null != (readValue = bufferedReader.readLine())) {
                    this.getReturnValue().append(readValue);
                }
            }
            catch (Exception e) {
                logger.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
    }
}

