/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class RecoveryTaskUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryTaskUtil.class);
    private static final int TIMEOUT = 10800000;
    private static final int INTERVAL = 2000;
    private static final List<Integer> ARRAY_4DC_VAULT_TEMPLATE = Arrays.asList(41, 40, 42, 43);

    private RecoveryTaskUtil() {
    }

    public static Set<RecoveryTask> getRootRecoveryTasks(Collection<RecoveryTask> recoveryTasks) {
        HashSet<RecoveryTask> tasks = new HashSet<RecoveryTask>();
        if (VerifyUtil.isEmpty(recoveryTasks)) {
            return tasks;
        }
        for (RecoveryTask recoveryTask : recoveryTasks) {
            RecoveryTask associatedTask = recoveryTask.getAssociatedTask();
            if (associatedTask == null) {
                tasks.add(recoveryTask);
                continue;
            }
            if (recoveryTasks.contains(associatedTask)) continue;
            tasks.add(recoveryTask);
        }
        return tasks;
    }

    public static Set<RecoveryTask> getRecoveryTasksByDisisaterSite(Collection<RecoveryTask> recoveryTasks, String disasterSiteId) {
        HashSet<RecoveryTask> tasks = new HashSet<RecoveryTask>();
        if (VerifyUtil.isEmpty(recoveryTasks) || disasterSiteId == null) {
            return tasks;
        }
        for (RecoveryTask recoveryTask : recoveryTasks) {
            if (!disasterSiteId.equals(recoveryTask.getDisasterSite().getSiteId())) continue;
            tasks.add(recoveryTask);
        }
        return tasks;
    }

    public static Set<RecoveryProcessor> getRootRecoveryProcessors(Collection<RecoveryProcessor> recoveryProcessors) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (VerifyUtil.isEmpty(recoveryProcessors)) {
            return processors;
        }
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (RecoveryTaskUtil.isAssociatedByOtherProcessor(recoveryProcessors, recoveryProcessor)) continue;
            processors.add(recoveryProcessor);
        }
        return processors;
    }

    public static boolean waitRecoveryPlanCompleted(String planId, DrmEnumDefine.RecoveryPlanStatusE expectedStatus) {
        boolean result;
        block6: {
            Object[] parameters;
            IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
            long startTime = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Thread is interrupted");
                }
                RecoveryPlan latestPlan = planService.getRecoveryPlan(planId);
                if (VerifyUtil.isEmpty((Object)latestPlan)) {
                    logger.error((Object)"The latestPlan is null");
                    throw new LegoCheckedException(1073947394L);
                }
                int status = latestPlan.getPlanStatus();
                if (expectedStatus.getValue() == status) {
                    result = true;
                } else {
                    if (status != DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED.getValue() && status != DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED.getValue() && status != DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue() && status != DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_FAILED.getValue() && status != DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED.getValue() && status != DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED.getValue()) continue;
                    result = false;
                }
                break block6;
            } while (System.currentTimeMillis() - startTime < 10800000L);
            Object[] args = parameters = new String[]{planId};
            String msg = String.format(Locale.ENGLISH, "query recovery plan status timeout!", args);
            logger.error((Object)msg);
            result = false;
        }
        return result;
    }

    public static User getAdminUser() {
        IUserMgrBaseService userMgr = (IUserMgrBaseService)ServiceLocator.getInstance().getService(IUserMgrBaseService.class);
        if (userMgr == null) {
            logger.error((Object)"Get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (user == null) {
            logger.error((Object)"Get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        return user;
    }

    private static boolean isAssociatedByOtherProcessor(Collection<RecoveryProcessor> recoveryProcessors, RecoveryProcessor recoveryProcessor) {
        if (VerifyUtil.isEmpty(recoveryProcessors) || recoveryProcessor == null) {
            return false;
        }
        for (RecoveryProcessor processor : recoveryProcessors) {
            if (processor.getNextCascadeProcessor() == null || !processor.getNextCascadeProcessor().getProcId().equals(recoveryProcessor.getProcId())) continue;
            return true;
        }
        return false;
    }

    public static String getAirGapQueryArrayId(String sourceArrayId, String targetArrayId) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource targetDrResource = resourceService.getDrResourceBySn(targetArrayId);
        DrResource sourceDrResource = resourceService.getDrResourceBySn(sourceArrayId);
        if (!VerifyUtil.isEmpty((Object)targetDrResource) && targetDrResource.getIsAirGapResource().booleanValue()) {
            return targetArrayId;
        }
        if (!VerifyUtil.isEmpty((Object)sourceDrResource) && sourceDrResource.getIsAirGapResource().booleanValue()) {
            return sourceArrayId;
        }
        return "";
    }

    public static boolean isAirGapSite(String siteDevSn) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(siteDevSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)"The target device does not exist. DevSN: %s", new Object[]{siteDevSn});
            throw new LegoCheckedException(1073947394L);
        }
        return drResource.getIsAirGapResource();
    }

    public static boolean is4DCVaultRollBack(RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE curType = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        ProtectGroup pg = (ProtectGroup)context.getAttribute("Recovery_ProtectGroup");
        int templateType = pg.getTemplate().getType();
        return curType.getValue() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() && ARRAY_4DC_VAULT_TEMPLATE.contains(templateType);
    }

    public static boolean isMultiDisasterSite(ProtectGroup protectGroup, String disasterSiteId) {
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return DrmEnumDefine.ProtectLocation.B_C.getValue() == replica.getProtectLocation();
        }
        return false;
    }

    public static boolean isVault4DCSceneAndRollBack(ProtectGroup pg, int procType) {
        if (!RecoveryTaskUtil.is4DCVaultRollBack(pg, procType)) {
            return false;
        }
        Set hmSites = pg.getHyperMetroSiteIdSet();
        String productSiteId = pg.getProductSiteId();
        return hmSites.contains(productSiteId);
    }

    public static boolean is4DCVaultRollBack(ProtectGroup pg, int procType) {
        int templateType = pg.getTemplate().getType();
        return procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() && ARRAY_4DC_VAULT_TEMPLATE.contains(templateType);
    }

    public static boolean is4DCVaultSceneAndRollBack(ProtectGroup pg, int procType) {
        if (RecoveryTaskUtil.is4DCVaultRollBack(pg, procType)) {
            Set hmSites = pg.getHyperMetroSiteIdSet();
            String productSiteId = pg.getProductSiteId();
            return hmSites.contains(productSiteId);
        }
        return false;
    }
}

