/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.security.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.security.sdk.model.UserBizObject;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.util.ScopeManagerUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import org.springframework.dao.DataAccessException;

@Service(name="IBizScopeManager", desc="", interfaceClass=IBizScopeManager.class)
public class BizScopeManagerImpl
extends DrmBaseService
implements IBizScopeManager {
    private static final Log logger = LogFactory.getInstance(BizScopeManagerImpl.class);
    private static IUserMgrBaseService usermgr = null;

    public List<DRMObject> getUserGrantObject(Long userId) {
        List<UserBizObject> objList = this.getUserBizObject(userId);
        ArrayList<DRMObject> result = new ArrayList<DRMObject>();
        for (UserBizObject userBizObj : objList) {
            DRMObject drmObject = new DRMObject();
            drmObject.setUuid(userBizObj.getObjectId());
            result.add(drmObject);
        }
        return result;
    }

    public List<? extends DRMObject> filterObject(Long userId, List<? extends DRMObject> objectList) {
        if (this.checkIsAdmin(userId)) {
            return objectList;
        }
        if (objectList == null || objectList.isEmpty()) {
            return objectList;
        }
        ArrayList<DRMObject> result = new ArrayList<DRMObject>();
        List<UserBizObject> objList = this.getUserBizObject(userId);
        block0: for (DRMObject dRMObject : objectList) {
            for (UserBizObject userBizObj : objList) {
                if (!dRMObject.getUuid().equals(userBizObj.getObjectId())) continue;
                result.add(dRMObject);
                continue block0;
            }
        }
        return result;
    }

    public <T extends ManagedObject> List<T> filterMoList(Long userId, List<T> moList) {
        if (userId == null || VerifyUtil.isEmpty(moList)) {
            logger.error((Object)"Fail to filter mo list, user id is null or moList is empty.");
            return Collections.emptyList();
        }
        Predicate<ManagedObject> moValidate = mo -> mo != null && !VerifyUtil.isEmpty((Object)mo.getMoId());
        Predicate<ManagedObject> authCheck = mo -> ScopeManagerUtil.checkUserGrantedMOObject(userId, mo.getMoId());
        return moList.stream().filter(moValidate.and(authCheck)).collect(Collectors.toList());
    }

    public void deleteScopeObject(String objectId) {
        String hql = "from UserBizObject where objectId = ? ";
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        List objList = baseDao.getHibernateTemplate().find(hql, new Object[]{objectId});
        baseDao.getHibernateTemplate().deleteAll((Collection)objList);
    }

    public void saveOrUpdateObject(String objectIds, Long userId) {
        if (objectIds == null) {
            return;
        }
        String[] objectArray = objectIds.split(",");
        this.deleteUserGrantedObject(userId);
        this.addObject(userId, objectArray);
    }

    public void checkUserGrantedObject(Long userId, String objectId) {
        if (!this.isObjectExist(objectId)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (this.checkIsAdmin(userId)) {
            return;
        }
        String hql = "from UserBizObject where userId = ? and objectId = ?";
        Object[] params = new Object[]{userId, objectId};
        try {
            List objList = this.getBaseDao().getHibernateTemplate().find(hql, params);
            if (objList == null || objList.isEmpty()) {
                throw new LegoCheckedException(1073947400L);
            }
        }
        catch (DataAccessException dae) {
            ExceptionUtil.rethrowException((Throwable)dae, (String)"save user biz object to database error!", (long)1073947400L, (String[])new String[0], (Log)logger);
        }
    }

    public void deleteUserGrantedObject(Long userId) {
        List<UserBizObject> objList = this.getUserBizObject(userId);
        this.getBaseDao().getHibernateTemplate().deleteAll(objList);
    }

    public void addObject(Long userId, String ... objectIds) {
        if (objectIds == null) {
            return;
        }
        boolean isAdmin = this.checkIsAdmin(userId);
        Long adminId = null;
        if (!isAdmin) {
            User adminUser = this.getUserMgr().getUserByName("admin");
            adminId = adminUser.getUserId();
        }
        ArrayList<UserBizObject> userBizObjectList = new ArrayList<UserBizObject>();
        for (String objectId : objectIds) {
            UserBizObject userBizObject = new UserBizObject();
            userBizObject.setUserId(userId);
            userBizObject.setObjectId(objectId);
            userBizObjectList.add(userBizObject);
            if (isAdmin || VerifyUtil.isEmpty((Object)adminId)) continue;
            UserBizObject userAdminBizObject = new UserBizObject();
            userAdminBizObject.setUserId(adminId);
            userAdminBizObject.setObjectId(objectId);
            userBizObjectList.add(userAdminBizObject);
        }
        try {
            CommonDAOLocator.getBaseDao().saveOrUpdateAll(userBizObjectList);
        }
        catch (DataAccessException dae) {
            logger.error((Object)"save user biz object to database error!", (Throwable)dae, -1L);
        }
        catch (PersistenceException e) {
            logger.error((Object)"save user biz object to database error!", (Throwable)e, -1L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"save user biz object to database error!", (Throwable)e, -1L);
        }
    }

    private List<UserBizObject> getUserBizObject(Long ... userIds) {
        String hql = "from UserBizObject where userId = ? ";
        List objList = this.getBaseDao().getHibernateTemplate().find(hql, (Object[])userIds);
        return objList;
    }

    private IUserMgrBaseService getUserMgr() {
        if (usermgr != null) {
            return usermgr;
        }
        usermgr = (IUserMgrBaseService)ServiceContext.getInstance().lookup("user/usermgr");
        return usermgr;
    }

    private boolean isObjectExist(String objectId) {
        String hql = "select count(*) from UserBizObject where objectId = ?";
        try {
            List list = this.getBaseDao().getHibernateTemplate().find(hql, new Object[]{objectId});
            if (list == null || list.isEmpty()) {
                return false;
            }
            Object countObj = list.get(0);
            if (countObj instanceof Long) {
                Long count = (Long)countObj;
                return count.intValue() > 0;
            }
            return false;
        }
        catch (DataAccessException dae) {
            logger.error((Object)"business object is not exist", (Throwable)dae, -1L);
            return false;
        }
    }

    public boolean checkIsAdmin(Long userId) {
        IUserMgrBaseService userMgr = this.getUserMgr();
        if (null == userMgr) {
            logger.error((Object)"can not get user/usermgr service", 90160758784001L);
            return true;
        }
        boolean isAdmin = userMgr.checkUserIsAdmin(userId.longValue());
        return isAdmin;
    }

    public void checkUserGrantedMOObject(Long userId, String objectId) {
        boolean hasRight;
        long moId = 0L;
        NetworkEntity ne = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)objectId);
        if (ne == null) {
            ne = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "uuid", (Object)objectId);
        }
        if (ne != null) {
            moId = ne.getMoId();
        }
        if (!(hasRight = ScopeManagerUtil.checkUserGrantedMOObject(userId, moId))) {
            throw new LegoCheckedException(1073947400L);
        }
    }

    public void checkUserGrantedMOObject(Long userId, long ... moIds) {
        for (long moId : moIds) {
            boolean hasRight = ScopeManagerUtil.checkUserGrantedMOObject(userId, moId);
            if (hasRight) continue;
            throw new LegoCheckedException(1073947400L);
        }
    }
}

