/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.detect.IResourceDetectManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryBaseService;
import com.huawei.lego.nem.discover.util.DaoFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class DeleteResourceBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DeleteResourceBackTask.class);
    private List<BatchOperation> ops;

    public DeleteResourceBackTask(List<BatchOperation> ops) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)StringUtil.listToString(ops, BatchOperation::getTargetName), (String)"ism.drm.delete.resource", (String)"System", (String)"", null), true);
        this.ops = ops;
    }

    protected void doWork() {
        if (VerifyUtil.isEmpty(this.ops)) {
            logger.error((Object)"delete opeartion obj is null");
            throw new LegoCheckedException(2117645L);
        }
        String targetNames = StringUtil.listToString(this.ops, BatchOperation::getTargetName);
        List<ManagedObject> managedObjects = this.queryBatchOperationManagedObjects(this.ops);
        Map<String, Boolean> waitDeleteMap = this.getWaitDeleteSnsMap(managedObjects);
        this.preDeleteResource(waitDeleteMap);
        this.deleteAirGapRelationInfo(waitDeleteMap);
        logger.info((Object)"start to delete resource.target names:[%s]", new Object[]{targetNames});
        IDiscoveryBaseService discoveryService = (IDiscoveryBaseService)ServiceLocator.getInstance().getService(IDiscoveryBaseService.class);
        BatchOperationResult batchOperationResult = discoveryService.deleteDeviceNew(this.ops);
        if (batchOperationResult.getFailCount() > 0 || batchOperationResult.getSucceedCount() != this.ops.size()) {
            this.checkBatchOperationResult(managedObjects, batchOperationResult);
        } else {
            managedObjects.forEach(this::cleanBatchOperationRelatedData);
        }
        logger.info((Object)"delete resource success.target names:[%s]", new Object[]{targetNames});
    }

    private void checkBatchOperationResult(List<ManagedObject> managedObjects, BatchOperationResult batchOperationResult) {
        List batchOperations = batchOperationResult.getResult();
        for (BatchOperation operation : batchOperations) {
            long errorCode = operation.getErrorCode();
            if (errorCode != 0L) {
                logger.error((Object)"delete resource failed. resource name:[%s]", new Object[]{operation.getTargetName()});
                throw new LegoCheckedException(errorCode);
            }
            managedObjects.stream().filter(managedObject -> Objects.equals(managedObject.getMoId(), operation.getTargetId())).forEach(this::cleanBatchOperationRelatedData);
        }
    }

    private void preDeleteResource(Map<String, Boolean> waitDeleteMap) {
        if (waitDeleteMap.size() == 0) {
            logger.info((Object)"Wait delete map is empty.");
            return;
        }
        List<String> devSnList = this.getAirGapDevSns(waitDeleteMap);
        if (CollectionUtils.isEmpty(devSnList)) {
            logger.error((Object)"No need to pre delete air gap relations!");
            return;
        }
        logger.info((Object)"Begin to enable resource ports. devSnList: %s", new Object[]{devSnList});
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        linkProcessor.preSetBeforeRemoveStorage(devSnList);
    }

    private List<String> getAirGapDevSns(Map<String, Boolean> waitDeleteMap) {
        ArrayList<String> devSnList = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : waitDeleteMap.entrySet()) {
            String devSn = entry.getKey();
            boolean isAirGap = entry.getValue();
            if (!isAirGap) continue;
            devSnList.add(devSn);
        }
        return devSnList;
    }

    private void deleteAirGapRelationInfo(Map<String, Boolean> waitDeleteMap) {
        if (waitDeleteMap.size() == 0) {
            logger.info((Object)"Wait delete map is empty.");
            return;
        }
        List<String> devSnList = this.getAirGapDevSns(waitDeleteMap);
        for (String devSn : devSnList) {
            logger.info((Object)"Begin to delete devSn: %s air gap relations.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            try {
                IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
                resourceService.deleteResourceRelationTimeWindows(devSn);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Exception occurred when delete resource relation: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurred when delete resource relation: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
    }

    private Map<String, Boolean> getWaitDeleteSnsMap(Collection<ManagedObject> objects) {
        HashMap<String, Boolean> resMap = new HashMap<String, Boolean>();
        for (ManagedObject lmo : objects) {
            if (!(lmo instanceof HvsStorage)) continue;
            HvsStorage storage = (HvsStorage)lmo;
            String devSn = storage.getSn();
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
            resMap.put(devSn, drResource.getIsAirGapResource());
        }
        return resMap;
    }

    private List<ManagedObject> queryBatchOperationManagedObjects(List<BatchOperation> operations) {
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        ArrayList<ManagedObject> list = new ArrayList<ManagedObject>();
        for (BatchOperation operation : operations) {
            long moId = operation.getTargetId();
            ManagedObject managedObject = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
            list.add(managedObject);
        }
        return list;
    }

    private void cleanBatchOperationRelatedData(ManagedObject managedObject) {
        if (managedObject instanceof NetworkEntity) {
            IResourceDetectManager resourceDetectManager = (IResourceDetectManager)ServiceLocator.getInstance().getService(IResourceDetectManager.class);
            NetworkEntity networkEntity = (NetworkEntity)managedObject;
            String sn = networkEntity.getSn();
            resourceDetectManager.removeDetectCache(sn);
        }
    }
}

