/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryBaseService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DiscoverResourceBackTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(DiscoverResourceBackTask.class);
    private static final int TIME_INTERVAL = 5;
    private static final int POLLING_TIMES = 480;
    private DiscoveryPolicy policy;

    public DiscoverResourceBackTask(DiscoveryPolicy policy) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)policy.getEndIP(), (String)"ism.drm.discovery", (String)"System", (String)"", null), true);
        this.policy = policy;
    }

    protected void doWork() {
        this.policy.getExtendAttributeMap().put("discoveryTask", this.getBackTask());
        IDiscoveryBaseService discoveryService = (IDiscoveryBaseService)ServiceLocator.getInstance().getService(IDiscoveryBaseService.class);
        long policyId = discoveryService.icmpDiscovery(this.policy);
        int timeout = 0;
        long totalIpCount = this.policy.getTotalIpCount();
        String countSql = "select count(*) from DiscoveryResult where discoveryPolicy.discoveryPolicyId = ?";
        long resultCount = 0L;
        while (resultCount < totalIpCount) {
            try {
                resultCount = CommonDAOLocator.getBaseDao().getTotalCount(countSql, new Object[]{policyId});
                TimeUnit.SECONDS.sleep(5L);
                this.policy = discoveryService.getDiscoveryPolicy(Long.valueOf(policyId));
            }
            catch (InterruptedException ex) {
                logger.error((Object)"Current thread has been interrupted by BackTaskHandler!", (Throwable)ex);
                throw new LegoCheckedException(1073947433L, (Throwable)ex);
            }
            if (timeout++ != 480) continue;
            StringBuilder sb = new StringBuilder("Discover resource error");
            sb.append(", totalIpCount=").append(totalIpCount);
            sb.append(", resultCount=").append(resultCount);
            sb.append(", discoveredNum=").append(this.policy.getDiscoveredDeviceCount());
            logger.error((Object)"Discover resource failed, timeout error, %s", new Object[]{sb.toString()});
            throw new LegoCheckedException(1073947433L, sb.toString());
        }
        int discoveredNum = this.policy.getDiscoveredDeviceCount();
        if (discoveredNum > 0) {
            if (this.policy.getIsAirGapResource().booleanValue()) {
                this.handleAirGapResourceDiscovery(this.policy.getStartIP());
            }
            return;
        }
        this.dealErrorMsg(policyId);
    }

    private void handleAirGapResourceDiscovery(String ipAddress) {
        IManagementServerBaseService managementServerBaseService = (IManagementServerBaseService)ServiceLocator.getInstance().getService(IManagementServerBaseService.class);
        if (managementServerBaseService == null) {
            logger.info((Object)"Get managementServerBaseService null.");
            return;
        }
        managementServerBaseService.handleAirGapResourceDiscovery(ipAddress);
    }

    private void dealErrorMsg(long policyId) {
        String queryResultSql = "from DiscoveryResult discoveryResult where discoveryResult.discoveryPolicy.discoveryPolicyId = ? order by discoveryResult.discoveryResultId asc";
        List disResult = CommonDAOLocator.getMoDao().find(queryResultSql, new Object[]{policyId});
        if (VerifyUtil.isEmpty((Collection)disResult)) {
            logger.error((Object)"DiscoveryResult is empty.");
            throw new LegoCheckedException(1053L, "Discover resource error!");
        }
        DiscoveryResult result = (DiscoveryResult)disResult.get(0);
        long errorCode = result.getErrorCode();
        if (errorCode != 0L) {
            String errorParam = result.getErrorParam();
            String[] errorParams = null;
            if (!VerifyUtil.isEmpty((String)errorParam)) {
                errorParams = errorParam.split(",");
            }
            logger.error((Object)"The policy=%s, result=%s, errorCode=%s.", new Object[]{String.valueOf(policyId), result.getDiscoveryResultId(), errorCode});
            throw new LegoCheckedException(errorCode, errorParams);
        }
    }
}

