/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.site.resource.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.resource.service.DeleteResourceBackTask;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.StoragePortOperateLog;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public abstract class AbstractResourceService
extends IsmBaseService
implements IResourceService {
    private static final Log logger = LogFactory.getInstance(AbstractResourceService.class);
    private Map<String, IResourceManager> rmMapping = new ConcurrentHashMap<String, IResourceManager>();

    public void onBind(IResourceManager rm, Map<?, ?> properties) {
        logger.debug((Object)"onBind");
        this.rmMapping.put(rm.getResourceType(), rm);
    }

    public void onUnbind(IResourceManager rm, Map<?, ?> properties) {
        logger.debug((Object)"onUnbind");
        this.rmMapping.remove(rm.getResourceType());
    }

    public DrResource getDrResourceBySn(String devSn, String resType) {
        logger.debug((Object)"devSn=%s, resType=%s", new Object[]{devSn, resType});
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        return SiteResourceServiceProxy.getInstance().getSiteResourceService(resType).getDrResourceBySn(devSn);
    }

    public DrResource getDrResourceBySn(String devSn) {
        logger.debug((Object)"devSn=%s", new Object[]{devSn});
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource result = null;
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrResource where deviceSn=?", new Object[]{devSn});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            result = (DrResource)resources.get(0);
        }
        return result;
    }

    public <T extends ManagedObject> List<T> queryMoList(Class<T> clz, Map<String, Object> queryCondition) {
        logger.debug((Object)"queryMoList");
        if (VerifyUtil.isEmpty(clz)) {
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().findMoBy(clz, queryCondition);
    }

    public List<String> getResourceMainTypes(long userId) {
        ArrayList<String> types = new ArrayList<String>(SiteResourceServiceProxy.getInstance().getAllSiteResourceServiceKey());
        logger.debug((Object)"ResourceMainTypes: %s", new Object[]{types});
        return types;
    }

    public <T extends Serializable> List<T> query(Class<T> clazz, Map<String, Object> queryCondition) {
        logger.debug((Object)"query");
        if (VerifyUtil.isEmpty(clazz)) {
            return null;
        }
        if (VerifyUtil.isEmpty(queryCondition)) {
            queryCondition = new HashMap<String, Object>(0);
        }
        List criterionList = CommonDAOLocator.getBaseDao().translatePropsToCriterions(queryCondition);
        List createCriteria = CommonDAOLocator.getBaseDao().createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
        ArrayList<T> list = new ArrayList<T>();
        if (null != createCriteria) {
            for (Serializable s : createCriteria) {
                list.add(clazz.cast(s));
            }
        }
        return list;
    }

    protected void sendModifyMoMessage(ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            logger.debug((Object)"mo is null,not send ModifyMoMessage.");
            return;
        }
        HashMap<String, ManagedObject> messageBody = new HashMap<String, ManagedObject>();
        messageBody.put("ModifyManagedObject", mo);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(7005L);
        mu.setObj(messageBody);
        mu.setMt(MessageTopic.COMMAND);
        mu.setSourceAppName(((Object)((Object)this)).getClass().getName());
        ((IMessageCenter)ServiceLocator.getInstance().getService(IMessageCenter.class)).sendMessage(mu);
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        logger.debug((Object)"updateMgrProtocol");
        long moId = neMgrProtocol.getMoId();
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "connot get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        resourceManager.validate(neMgrProtocol);
        resourceManager.updateMgrProtocol(neMgrProtocol);
    }

    private String getMainType(long moId) {
        logger.debug((Object)"moId=%s", new Object[]{String.valueOf(moId)});
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from TopoObject where moId=?", new Object[]{moId});
        if (null == obs || obs.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
        String mainType = ((TopoObject)obs.get(0)).getMainType();
        return mainType;
    }

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        logger.debug((Object)"moId=%s", new Object[]{String.valueOf(moId)});
        String mainType = this.getMainType(moId);
        IResourceManager resourceManager = this.rmMapping.get(mainType);
        if (VerifyUtil.isEmpty((Object)resourceManager)) {
            String errorMsg = "connot get resourceManager by " + mainType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return resourceManager.getMgrProtocol(moId);
    }

    public long deleteResources(List<BatchOperation> opts) {
        DeleteResourceBackTask task = new DeleteResourceBackTask(opts);
        BackTaskHandler instance = BackTaskHandler.getInstance();
        return instance.submitTask((AbstractBackTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getSupportResource() {
        Session session;
        Map<String, String> supportResources;
        block4: {
            supportResources = new HashMap<String, String>();
            IMoDao moDao = CommonDAOLocator.getMoDao();
            session = null;
            try {
                session = moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select NAME, DESCRIPTION from T_MAIN_DEVICE_TYPE";
                NativeQuery query = session.createSQLQuery(querySQL);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) break block4;
                supportResources = this.parseSupportResoureDbData(results);
            }
            catch (Exception e) {
                try {
                    ExceptionUtil.rethrowException((Throwable)e, (String)"Querying support resource failed.", (long)-1L, (String[])new String[0], (Log)logger);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return supportResources;
    }

    private Map<String, String> parseSupportResoureDbData(List<?> results) {
        logger.debug((Object)"parseSupportResoureDbData");
        HashMap<String, String> supportResources = new HashMap<String, String>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 2 != (values = (Object[])object).length) continue;
            String name = String.valueOf(values[0]);
            String desc = String.valueOf(values[1]);
            supportResources.put(name, desc);
        }
        return supportResources;
    }

    public void modifyResourceSite(String resourceId, String siteId) {
        if (VerifyUtil.isEmpty((String)resourceId) || VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)"Param resourceId or siteId is emnpty.");
            throw new LegoCheckedException(1073947393L);
        }
        DrResource resource = this.getDrResourceBySn(resourceId);
        if (VerifyUtil.isEmpty((Object)resource)) {
            logger.error((Object)"DrResource is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        List obs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from NetworkEntity where sn=?", new Object[]{resourceId});
        if (!VerifyUtil.isEmpty((Collection)obs)) {
            NetworkEntity networkEntity = (NetworkEntity)obs.get(0);
            String mainType = networkEntity.getMainType();
            SiteResourceServiceProxy.getInstance().getSiteResourceService(mainType).isResourceUsed(networkEntity.getMoId());
        }
        try {
            resource.setSiteId(siteId);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)resource);
        }
        catch (DataAccessException e) {
            logger.error((Object)"unable to modify resource site, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public List<DrResource> getAirGapResource() {
        throw new UnsupportedOperationException();
    }

    public List<ResourceTimeWindow> getResourceTimeWindow(String resourceId) {
        throw new UnsupportedOperationException();
    }

    public void switchoverTimeWindows(String devSn, String windowId, boolean isManualTunnel, boolean isAutoTrigger) {
        throw new UnsupportedOperationException();
    }

    public void updateResourceTimeWindow(ResourceTimeWindow timeWindow) {
        throw new UnsupportedOperationException();
    }

    public List<StoragePortOperateLog> getResourcePortOperateLog(String resourceId, String portId) {
        throw new UnsupportedOperationException();
    }

    public void deleteResourceTimeWindow(String windowId) {
        throw new UnsupportedOperationException();
    }

    public void deleteResourceRelationTimeWindows(String devSn) {
        throw new UnsupportedOperationException();
    }

    public void doUpdateLinkPorts(String devSn) {
        throw new UnsupportedOperationException();
    }
}

