/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageProtectGroupBaseManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class StorageProtectGroupManagerProxy
extends BaseStorageManagerProxy
implements IStorageProtectGroupBaseManager {
    private static final Log logger = LogFactory.getInstance(StorageProtectGroupManagerProxy.class);
    private static final StorageProtectGroupManagerProxy INSTANCE = new StorageProtectGroupManagerProxy();
    private final Map<String, IStorageProtectGroupBaseManager> managers = new ConcurrentHashMap<String, IStorageProtectGroupBaseManager>();

    private StorageProtectGroupManagerProxy() {
    }

    public static StorageProtectGroupManagerProxy getInstance() {
        return INSTANCE;
    }

    public void onBind(IStorageProtectGroupBaseManager spg, Map<?, ?> properties) {
        if (spg.getStorageType() != null) {
            this.managers.put(spg.getStorageType(), spg);
        }
    }

    public IStorageProtectGroupBaseManager getStorageProtectGroupAdapter(String devSn) {
        String storageType = this.getStorageType(devSn);
        IStorageProtectGroupBaseManager storageProtectGroupBaseManagerManager = this.managers.get(storageType);
        if (storageProtectGroupBaseManagerManager == null) {
            logger.error((Object)"storageProtectGroupBaseManagerManager is null, sn=%s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            throw new LegoCheckedException(1073947395L);
        }
        return storageProtectGroupBaseManagerManager;
    }

    public void onUnbind(IStorageProtectGroupBaseManager spg, Map<?, ?> properties) {
        this.managers.remove(spg.getStorageType());
    }

    public String getStorageType() {
        return null;
    }

    public void addLuns(List<Lun> luns, String groupId) {
        String devSn = luns.get(0).getDevSn();
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(devSn);
        manager.addLuns(luns, groupId);
    }

    public void removeLuns(List<Lun> luns, String groupId) {
        String devSn = luns.get(0).getDevSn();
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(devSn);
        manager.removeLuns(luns, groupId);
    }

    public HvsProtectionGroup associatedQueryProtectionGroup(String devSn, int resourceType, String resourceId) {
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(devSn);
        return manager.associatedQueryProtectionGroup(devSn, resourceType, resourceId);
    }

    public void deleteProtectGroup(HvsProtectionGroup protectionGroup) {
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(protectionGroup.getDevSn());
        manager.deleteProtectGroup(protectionGroup);
    }

    public HvsProtectionGroup createProtectGroup(HvsProtectionGroup protectionGroup) {
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(protectionGroup.getDevSn());
        return manager.createProtectGroup(protectionGroup);
    }

    public Optional<HvsProtectionGroup> queryProtectionGroup(HvsProtectionGroup protectionGroup) {
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(protectionGroup.getDevSn());
        return manager.queryProtectionGroup(protectionGroup);
    }

    public List<HvsProtectionGroup> batchQueryProtectionGroup(String devSn, String criteria) {
        IStorageProtectGroupBaseManager manager = this.getStorageProtectGroupAdapter(devSn);
        return manager.batchQueryProtectionGroup(devSn, criteria);
    }
}

