/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.Locale;

public final class AlarmGenerator {
    private static final Log logger = LogFactory.getInstance(AlarmGenerator.class);

    private AlarmGenerator() {
    }

    public static String generateAlarmId(long alarmID) {
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        return alarmId;
    }

    private static void sendAlarm(TopoObject to, long alarmID, FaultEnum.AlarmSeverity alarmLevel, String ... alarmParams) {
        IFaultGenerateService alarmService = AlarmGenerator.getAlarmService();
        LegoAlarm alarm = new LegoAlarm();
        long moID = to.getMoId();
        String alarmId = AlarmGenerator.generateAlarmId(alarmID);
        String id = moID + alarmId + to.getUuid();
        logger.info((Object)"Send alarm! the entity of the alarm is %s", new Object[]{id});
        alarm.setMoId(moID);
        alarm.setMoIP(to.getIpAddress());
        alarm.setMoName(to.getName());
        alarm.setMoUuid(to.getUuid());
        alarm.setEntity(moID + alarmId);
        alarm.setAlarmId(alarmId);
        alarm.setAlarmLevel(alarmLevel);
        alarm.setAlarmParam(alarmParams);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setClearStatus(FaultEnum.ClearState.UNCLEARED);
        alarm.setSourceType(FaultEnum.AlarmResourceType.UNDEFINED.getValue());
        try {
            boolean isSuccessed = alarmService.generateLegoAlarm(alarm);
            if (!isSuccessed) {
                logger.error((Object)"generate fault alarm failed.see lego logs");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Generate fault alarm failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private static void restoreAlarm(TopoObject to, long alarmID, String ... alramParams) {
        if (VerifyUtil.isEmpty((Object[])alramParams)) {
            return;
        }
        String alarmId = AlarmGenerator.generateAlarmId(alarmID);
        long moID = to.getMoId();
        String id = moID + alarmId + alramParams[0];
        LegoAlarm oldAlarm = AlarmUtil.getAlarm((String)id);
        IFaultGenerateService alarmService = AlarmGenerator.getAlarmService();
        if (oldAlarm != null && oldAlarm.getClearStatus().equals((Object)FaultEnum.ClearState.UNCLEARED)) {
            oldAlarm.setClearStatus(FaultEnum.ClearState.CLEARED);
            oldAlarm.setClearTime(System.currentTimeMillis());
            oldAlarm.setClearUser("system");
            try {
                oldAlarm.setFaultDefine(null);
                boolean isSuccessed = alarmService.generateRestoreAlarm(oldAlarm);
                if (!isSuccessed) {
                    logger.error((Object)"Restore fault alarm failed.see lego logs");
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Generate fault alarm failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public static IFaultGenerateService getAlarmService() {
        ServiceContext context = ServiceContext.getInstance();
        IFaultGenerateService service = (IFaultGenerateService)context.lookup("fault/faultGenerateService");
        return service;
    }

    public static void generateUploadConfigDataFailAlarm(TopoObject to, String ... alarmParams) {
        if (!VerifyUtil.isEmpty((Object)to) && !VerifyUtil.isEmpty((Object[])alarmParams)) {
            AlarmGenerator.sendAlarm(to, 52625428L, FaultEnum.AlarmSeverity.MINOR, alarmParams);
        }
    }

    public static void restoreUploadConfigDataFailAlarm(TopoObject to, String systemIP) {
        if (!VerifyUtil.isEmpty((Object)to)) {
            AlarmGenerator.restoreAlarm(to, 52625428L, systemIP, to.getUuid());
        }
    }
}

