/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.thirdservice.impl;

import com.huawei.ism.drm.cert.checker.HttpsConnectChecker;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ILegoConfigService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

@Service(name="com.huawei.ism.drm.system.thirdservice.sdk.service.ILegoConfigService", desc="", interfaceClass=ILegoConfigService.class)
public class LegoConfigServiceImpl
extends BaseService
implements ILegoConfigService {
    private static final Log LOGGER = LogFactory.getInstance(LegoConfigServiceImpl.class);

    public Boolean getSwitch(String key, Boolean defaultValue) {
        if (VerifyUtil.isEmpty((String)key)) {
            LOGGER.error((Object)"GetSwitch failed, cause key is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return LegoBaseConfig.getInstance().getBoolean(key, defaultValue);
    }

    public void modifySwitch(String key, Boolean value) {
        if (value == null || VerifyUtil.isEmpty((String)key)) {
            LOGGER.error((Object)"ModifySwitch failed, cause value is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LegoBaseConfig.getInstance().setConfigValue(key, value.toString());
    }

    public List<String> getConnectFailedServices() {
        HttpsConnectChecker httpsConnectChecker = (HttpsConnectChecker)ServiceLocator.getInstance().getService(HttpsConnectChecker.class);
        try {
            return httpsConnectChecker.getConnectFailedServices(Boolean.TRUE);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to getConnectFailedServices, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
    }
}

