/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.service.impl;

import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class TopoResourceManagerImpl
implements ITopoResourceManager {
    private static final long serialVersionUID = 1L;
    private static final List<String> LOCAL_EN_LANG_BOUND = new ArrayList<String>(Arrays.asList("en_US", "en", "EN"));
    private Locale locale = null;
    private I18nMgr i18nMgr;
    private String langInfo = null;

    public TopoResourceManagerImpl() {
        this("zh", null);
    }

    public TopoResourceManagerImpl(String locale, I18nMgr i18nMgr) {
        this.setLocale(locale);
        this.setI18nMgr(i18nMgr);
    }

    public I18nMgr getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMgr i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale.getLanguage());
    }

    public void setLocale(String lang) {
        this.langInfo = lang = LOCAL_EN_LANG_BOUND.contains(lang) ? "en" : "zh";
        this.locale = LOCAL_EN_LANG_BOUND.contains(lang) ? new Locale("en") : new Locale("zh", "CN");
    }

    public boolean containText(String key) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        return !key.equals(this.getText(key));
    }

    public String getText(String key) {
        try {
            String value = this.i18nMgr.getString(key, this.locale);
            return value;
        }
        catch (Exception e) {
            return key;
        }
    }

    public String getErrText(String key) {
        try {
            String value = this.i18nMgr.getString(key, this.locale);
            return value;
        }
        catch (Exception e) {
            return key;
        }
    }

    public String getLangInfo() {
        if (null == this.langInfo) {
            return "zh";
        }
        return this.langInfo;
    }
}

