/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.utils;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public abstract class TooltipUtil {
    private static final int TIME_START_INDEX = 11;
    private static final int TIME_END_INDEX = 16;
    private static final Log LOGGER = LogFactory.getInstance(TooltipUtil.class);

    public static void appendTooltip(StringBuilder builder, String key, String value) {
        TooltipUtil.appendTooltip(builder, key, value, TopoBaseContext.getTopoResourceManager());
    }

    public static void appendTooltipNoKey(StringBuilder builder, String key, String value) {
        TooltipUtil.appendTooltipNoKey(builder, value);
    }

    public static void appendTooltip(StringBuilder builder, String key, String value, ITopoResourceManager resourceManager) {
        builder.append(resourceManager.getText(key));
        builder.append(" ");
        if (TopoServiceUtil.isNullStr(value)) {
            value = "--";
        } else if (value.matches("&\\w+;")) {
            value = TopoServiceUtil.convertHtmlString(value);
        }
        builder.append(value);
        builder.append("\n");
    }

    public static void appendTooltipNoKey(StringBuilder builder, String value) {
        builder.append(" ");
        if (value.matches("&\\w+;")) {
            value = TopoServiceUtil.convertHtmlString(value);
        }
        builder.append(value);
        builder.append("\n");
    }

    public static String getScheduleInfo(Schedule schedule) {
        return TooltipUtil.getScheduleInfo(TopoBaseContext.getTopoResourceManager(), schedule);
    }

    public static String getScheduleInfo(ITopoResourceManager resourceManager, Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(resourceManager.getText("ism.drm.topo.protection.term.exeHistory.label"));
        sb.append(" ");
        if (schedule.getScheduleMode() == 0) {
            sb.append(resourceManager.getText("protection.term.exeHistory.value.auto.value"));
            sb.append("\n");
            sb.append(resourceManager.getText("ism.drm.topo.drp.time.start"));
            sb.append(" ");
            sb.append(TooltipUtil.formatDate(schedule.getStartTime()));
            sb.append("\n");
            sb.append(resourceManager.getText("ism.drm.topo.drp.time.end"));
            sb.append(" ");
            sb.append(TooltipUtil.formatDate(schedule.getEndTime()));
            sb.append("\n");
            sb.append(resourceManager.getText("ism.drm.topo.protect.policy.period"));
            sb.append(" ");
            sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.every"));
            TooltipUtil.addBlank(resourceManager, sb);
            int period = schedule.getPeriodType();
            int periodInterval = schedule.getPeriodInterval();
            if (period == 0) {
                sb.append(periodInterval);
                TooltipUtil.addBlank(resourceManager, sb);
                sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.type.minute"));
            } else if (period == 1) {
                sb.append(periodInterval);
                TooltipUtil.addBlank(resourceManager, sb);
                sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.type.hour"));
            } else if (period == 2) {
                sb.append(periodInterval);
                TooltipUtil.addBlank(resourceManager, sb);
                sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.type.day"));
            } else if (period == 3) {
                TooltipUtil.getWeekDay(schedule, resourceManager, sb);
            } else if (period == 4) {
                TooltipUtil.getMonthDay(schedule, resourceManager, sb);
            }
            TooltipUtil.addBlank(resourceManager, sb);
            sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.runone"));
            sb.append("\n");
            sb.append(TooltipUtil.getPeriodExclude(sb, schedule, resourceManager));
            if (period == 2 && !VerifyUtil.isEmpty((String)schedule.getAbortTaskTime())) {
                sb.append("\n");
                sb.append(resourceManager.getText("ism.drm.protect.policy.forcibly.terminate"));
                sb.append(" ");
                sb.append(schedule.getAbortTaskTime());
            }
        } else {
            sb.append(resourceManager.getText("protection.term.exeHistory.value.manual.value"));
        }
        return sb.toString();
    }

    private static void addBlank(ITopoResourceManager resourceManager, StringBuffer sb) {
        if ("en".equals(resourceManager.getLangInfo())) {
            sb.append(" ");
        }
    }

    private static void getWeekDay(Schedule schedule, ITopoResourceManager resourceManager, StringBuffer sb) {
        StringBuilder buffer = new StringBuilder();
        String sunday = "";
        String strDaysOfWeek = schedule.getDaysOfWeek();
        if (strDaysOfWeek.contains("1")) {
            sunday = resourceManager.getText("ism.drm.protectpolicy.schedule.week1");
            strDaysOfWeek = strDaysOfWeek.replace(",1", "");
            strDaysOfWeek = strDaysOfWeek.replace("1", "");
        }
        if (!VerifyUtil.isEmpty((String)strDaysOfWeek)) {
            String[] daysOfWeek = strDaysOfWeek.split(",");
            int len = daysOfWeek.length;
            for (int i = 0; i < len; ++i) {
                buffer.append(resourceManager.getText("ism.drm.protectpolicy.schedule.week" + daysOfWeek[i]));
                buffer.append(',');
            }
        }
        String workDay = buffer.toString();
        if ("en".equals(resourceManager.getLangInfo())) {
            if (!VerifyUtil.isEmpty((String)sunday)) {
                workDay = workDay + sunday + ",";
            }
            workDay = workDay.substring(0, workDay.length() - 1);
            if (schedule.getDaysOfWeek().length() > 1) {
                int index = workDay.lastIndexOf(",");
                sb.append(workDay.substring(0, index));
                sb.append(" and ");
                sb.append(workDay.substring(index + 1));
            } else {
                sb.append(workDay);
            }
        } else {
            sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.type.week"));
            if (!VerifyUtil.isEmpty((String)sunday)) {
                sb.append(workDay).append(sunday);
            } else {
                sb.append(workDay.substring(0, workDay.length() - 1));
            }
        }
    }

    private static void getMonthDay(Schedule schedule, ITopoResourceManager resourceManager, StringBuffer sb) {
        sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.type.monthDay"));
        if ("en".equals(resourceManager.getLangInfo())) {
            if (schedule.getLastDayOfMonth() == 1) {
                sb.append("last");
            } else {
                sb.append(schedule.getDaysOfMonth());
            }
            sb.append(" day of a month");
        } else if (schedule.getLastDayOfMonth() == 1) {
            sb.append(resourceManager.getText("ism.drm.protect.policy.lastDay"));
        } else {
            sb.append(schedule.getDaysOfMonth());
            sb.append(resourceManager.getText("ism.drm.protectpolicy.schedule.month.hao"));
        }
    }

    private static String getPeriodExclude(StringBuffer sb, Schedule schedule, ITopoResourceManager resourceManager) {
        int period = schedule.getPeriodType();
        if (period > 1 && 5 != period) {
            sb.append(resourceManager.getText("ism.drm.topo.protectpolicy.schedule.point.exclude.label"));
            sb.append(" ");
            return TooltipUtil.getSechedlePoint(schedule);
        }
        sb.append(resourceManager.getText("ism.drm.topo.protectpolicy.schedule.period.exclude.label"));
        sb.append(" ");
        Set scheduleRanges = schedule.getScheduleRanges();
        if (VerifyUtil.isEmpty((Collection)scheduleRanges)) {
            return resourceManager.getText("ism.drm.protectpolicy.schedule.period.executeAlways.value");
        }
        String startTime = null;
        String endTime = null;
        if (scheduleRanges.size() == 1) {
            ScheduleRangeTime scheduleRange = (ScheduleRangeTime)scheduleRanges.iterator().next();
            String strStartTime = TooltipUtil.formatDate(scheduleRange.getStartTime());
            String strEndTime = TooltipUtil.formatDate(scheduleRange.getEndTime());
            startTime = strStartTime.substring(11, 16);
            endTime = strEndTime.substring(11, 16);
        } else {
            ScheduleRangeTime scheduleRangeOne = (ScheduleRangeTime)scheduleRanges.iterator().next();
            ScheduleRangeTime scheduleRangeTwo = (ScheduleRangeTime)scheduleRanges.iterator().next();
            String startInfo = TooltipUtil.formatDate(scheduleRangeOne.getStartTime()).substring(11, 16);
            if (!"00:00".equals(startInfo)) {
                startTime = TooltipUtil.formatDate(scheduleRangeOne.getStartTime()).substring(11, 16);
                endTime = TooltipUtil.formatDate(scheduleRangeTwo.getEndTime()).substring(11, 16);
            } else {
                startTime = TooltipUtil.formatDate(scheduleRangeTwo.getStartTime()).substring(11, 16);
                endTime = TooltipUtil.formatDate(scheduleRangeOne.getEndTime()).substring(11, 16);
            }
        }
        if ("23:59".equals(endTime)) {
            endTime = "00:00";
        }
        return startTime + " - " + endTime;
    }

    private static String getSechedlePoint(Schedule schedule) {
        String hours = schedule.getHours();
        String[] hourArray = hours.split(",");
        String minute = "";
        StringBuilder buffer = new StringBuilder();
        for (String hour : hourArray) {
            try {
                if (Integer.parseInt(hour) < 10) {
                    buffer.append('0');
                }
                buffer.append(hour);
                buffer.append(":");
                minute = schedule.getMinutes();
                if (Integer.parseInt(minute) < 10) {
                    buffer.append("0");
                }
                buffer.append(minute);
                buffer.append(",");
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("formateexception, hour:" + hour + ",minute: " + minute), (Throwable)e, 1L);
            }
        }
        String result = buffer.toString();
        return result.substring(0, result.length() - 1);
    }

    private static String formatDate(String startTime) {
        String startTimeFormat = "--";
        if (!VerifyUtil.isEmpty((String)startTime)) {
            long parseLong = NumberUtil.convertToLong((Object)startTime, (long)0L);
            startTimeFormat = TooltipUtil.formatDate(new Date(parseLong));
        }
        return startTimeFormat;
    }

    private static String formatDate(Date date) {
        if (null == date) {
            return "--";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(date);
        TimeZone zone = TimeZone.getDefault();
        long offset = zone.getRawOffset();
        timeContent = offset >= 0L ? timeContent + " UTC+" : timeContent + " UTC-";
        offset = Math.abs(offset);
        dateFormat = new SimpleDateFormat("HH:mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        String timeZoneStr = dateFormat.format(offset);
        timeContent = timeContent + timeZoneStr;
        return timeContent;
    }

    public static String getSnapInfo(List<ProtectGroupReplica> pgReplicaList) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        StringBuffer sb = new StringBuffer();
        sb.append(resourceManager.getText("ism.drm.topo.duplicate.amount"));
        sb.append(" ");
        int num = 0;
        if (VerifyUtil.isEmpty(pgReplicaList)) {
            sb.append(0);
        } else {
            sb.append(pgReplicaList.size());
            for (ProtectGroupReplica protectGroupReplica : pgReplicaList) {
                if (protectGroupReplica.getStatus() != DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue()) continue;
                ++num;
            }
        }
        sb.append("\n");
        sb.append(resourceManager.getText("ism.drm.topo.duplicate.active.amount"));
        sb.append(" ");
        sb.append(num);
        sb.append("\n");
        return sb.toString();
    }

    public static String getHYPERCDPInfo(Integer totalCount) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        StringBuffer sb = new StringBuffer();
        sb.append(resourceManager.getText("ism.drm.topo.duplicate.amount"));
        sb.append(" ");
        sb.append(totalCount);
        sb.append("\n");
        sb.append(resourceManager.getText("ism.drm.topo.duplicate.active.amount"));
        sb.append(" ");
        sb.append(totalCount);
        sb.append("\n");
        return sb.toString();
    }
}

