/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.utils;

import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.utils.NodeDemension;
import com.huawei.ism.drm.topo.skin.Theme;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.IElement;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;

public final class TopoServiceUtil {
    private static final Log logger = LogFactory.getInstance(TopoServiceUtil.class);
    private static final int TOPO_NAME_LENTH = 16;
    private static final double TOPO_MORE_HIGHT = 15.0;
    private static final double OUTLINE_ALPHA = 0.0;

    private TopoServiceUtil() {
    }

    public static DrResource getDrResource(String sn) {
        String hql = "from DrResource where deviceSn=?";
        List drHost = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{sn});
        if (drHost.isEmpty()) {
            logger.error((Object)"The drHost is null,sn: %s.", new Object[]{sn});
            return null;
        }
        return (DrResource)drHost.get(0);
    }

    public static int initNewPairStatus(int pairStatus) {
        XveEuumDefineParent.RUNNING_STATUS_E xvePairStatus = XveEuumDefineParent.RUNNING_STATUS_E.valueOf((int)pairStatus);
        switch (xvePairStatus) {
            case NORMAL: {
                return 1;
            }
            case INVALID: {
                return 6;
            }
            case INTERRUPTED: {
                return 4;
            }
            case TO_BE_RECOVERD: {
                return 3;
            }
            case SPLIT: {
                return 5;
            }
            case AIR_GAP_LINK_DOWN: {
                return 7;
            }
            case SYNCHRONIZING: 
            case INITIAL_SYNCHRONIZING: {
                return 2;
            }
        }
        return pairStatus;
    }

    public static Schedule getSchedule(int protectLocation, Set<Schedule> schedules, ProtectGroup pg) {
        if (VerifyUtil.isEmpty(schedules)) {
            logger.error((Object)"The schedules is empty");
            return null;
        }
        Schedule result = null;
        Set<String> allProtectionLocation = TopoServiceUtil.getAllPgProtectLocation(pg);
        for (Schedule schedule : schedules) {
            if (allProtectionLocation.size() > 1 && schedule.getProtectLocation() != protectLocation) continue;
            if (schedule.getScheduleMode() == 1) {
                result = schedule;
                continue;
            }
            return schedule;
        }
        return result;
    }

    public static int getArrayReplicationMode(ReplicationTargetLun targetLun) {
        int mode;
        if (null == targetLun) {
            logger.debug((Object)"The param is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (targetLun.getParentMo() != null) {
            ReplicationPair replicationPair = (ReplicationPair)targetLun.getParentMo();
            mode = replicationPair.getReplicationMode();
        } else {
            mode = targetLun.getSyncMode();
        }
        return mode;
    }

    private static Set<String> getAllPgProtectLocation(ProtectGroup pg) {
        logger.debug((Object)"pg: %s", new Object[]{pg.getName()});
        TreeSet<String> allProtectLocation = new TreeSet<String>();
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            allProtectLocation.add(String.valueOf(replica.getProtectLocation()));
        }
        return allProtectLocation;
    }

    public static Node findNodeByIdInBox(ElementBox box, String id) {
        if (null == box || VerifyUtil.isEmpty((String)id)) {
            logger.debug((Object)"The param is null", 1L);
            return new Node();
        }
        Node result = null;
        for (Object obj : box.getDatas()) {
            IData data = (IData)obj;
            if (data.getID() == null || !id.equals(data.getID())) continue;
            result = (Node)data;
        }
        return result;
    }

    public static boolean isNullStr(String str) {
        return str == null || str.length() < 1;
    }

    public static boolean isExistLinkBetweenNodes(Node from, Node to) {
        boolean isExistTag = false;
        if (null == from || null == to) {
            logger.debug((Object)"param is null", 1L);
            return isExistTag;
        }
        List linkList = from.getFromLinks();
        if (linkList == null) {
            isExistTag = false;
        } else {
            for (Link link : linkList) {
                Node toNode = link.getToNode();
                if (!to.equals(toNode)) continue;
                isExistTag = true;
                break;
            }
        }
        return isExistTag;
    }

    public static String getNodeShowName(String strOrgName) {
        return TopoServiceUtil.cutTo(strOrgName, 16);
    }

    public static String cutTo(String str, int length) {
        if (str == null || str.length() < length) {
            return str;
        }
        return str.substring(0, length) + "...";
    }

    public static NodeDemension computeNodeWidthAndHight(Node fatherNode) {
        NodeDemension returnData = new NodeDemension();
        double width = 0.0;
        double hight = 0.0;
        if (fatherNode == null) {
            logger.error((Object)"param is null", 1L);
            return returnData;
        }
        if (fatherNode.getChildren() != null && fatherNode.getChildren().size() > 0) {
            double maxSonWidth = 0.0;
            double maxSonHeight = 0.0;
            for (int index = 0; index < fatherNode.getChildren().size(); ++index) {
                IElement son = (IElement)fatherNode.getChildren().get(index);
                NodeDemension sonDemension = TopoServiceUtil.countWidthAndHeightOfSons(fatherNode, width, hight, son);
                width = sonDemension.getWidth();
                hight = sonDemension.getHight();
                if (width > maxSonWidth) {
                    maxSonWidth = width;
                }
                if (!(hight > maxSonHeight)) continue;
                maxSonHeight = hight;
            }
            if (null != fatherNode.getID() && String.valueOf(fatherNode.getID()).contains("subNetwork:more:")) {
                maxSonWidth = 48.0;
                maxSonHeight = 15.0;
            }
            fatherNode.setClient("maxSonWidth", maxSonWidth);
            fatherNode.setClient("maxSonHeight", maxSonHeight);
            NodeDemension widthAndHeight = TopoServiceUtil.countFinalWidthAngHeight(fatherNode, width, hight);
            width = widthAndHeight.getWidth();
            hight = widthAndHeight.getHight();
        } else {
            NodeDemension imageWH = TopoServiceUtil.getImageWidthAndHeightOfNode(fatherNode);
            width = imageWH.getWidth();
            hight = imageWH.getHight();
        }
        if (!"circle".equals(fatherNode.getStyle("vector.shape"))) {
            fatherNode.setWidth(width);
            fatherNode.setHeight(hight);
            returnData.setHight(hight);
            returnData.setWidth(width);
        }
        TopoServiceUtil.countArrowToXOfft(fatherNode);
        TopoServiceUtil.updateSonNodeWidthAndHeight(fatherNode);
        return returnData;
    }

    private static void updateSonNodeWidthAndHeight(Node fatherNode) {
        if ("StyleGroup".equals(fatherNode.getClient("TopoModel")) && fatherNode.getChildren() != null && fatherNode.getChildren().size() > 0) {
            logger.debug((Object)"fatherNode is style group");
            TopoServiceUtil.updateGroupNodeDemension(fatherNode);
        }
    }

    private static void updateGroupNodeDemension(Node fatherNode) {
        double maxSonWidth = (Double)fatherNode.getClient("maxSonWidth");
        double maxSonHeight = (Double)fatherNode.getClient("maxSonHeight");
        for (int i = 0; i < fatherNode.getChildren().size(); ++i) {
            if ("StyleGroup".equals(fatherNode.getClient("TopoModel"))) {
                logger.debug((Object)"fatherNode is style group");
                continue;
            }
            IElement son = (IElement)fatherNode.getChildren().get(i);
            if (!(son instanceof Node) || son.getChildrenCount() <= 0) continue;
            Node sonNode = (Node)son;
            if ("topbottom".equals(fatherNode.getClient("layout"))) {
                sonNode.setWidth(maxSonWidth);
            }
            if ("leftright".equals(fatherNode.getClient("layout"))) {
                sonNode.setHeight(maxSonHeight);
            }
            TopoServiceUtil.updateSonNodeWidthAndHeight(sonNode);
        }
    }

    private static void countArrowToXOfft(Node rootNode) {
        if (null == rootNode || 0 <= rootNode.getChildrenCount()) {
            logger.debug((Object)"param no need count");
            return;
        }
        for (Object son : rootNode.getChildren()) {
            if (!(son instanceof Node) || ((Node)son).getChildrenCount() <= 0) continue;
            TopoServiceUtil.countArrowToXOfft((Node)son);
        }
    }

    public static NodeDemension getImageWidthAndHeightOfNode(Node node) {
        NodeDemension returnData = new NodeDemension();
        double width = 48.0;
        double height = 48.0;
        File file = new File(node.getImage());
        try {
            BufferedImage bi = ImageIO.read(file);
            if (null != bi) {
                double nodeLabelWidth;
                width = bi.getWidth();
                if (node.getName() != null && !"right.right".equals(node.getStyle("label.position")) && (nodeLabelWidth = (double)node.getName().length() * 10.0) > width) {
                    width = nodeLabelWidth;
                }
                height = bi.getHeight();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Reading image file failed.", 90160758784001L);
        }
        returnData.setHight(height);
        returnData.setWidth(width);
        return returnData;
    }

    private static NodeDemension countFinalWidthAngHeight(Node node, double width, double hight) {
        double groupLabelWidth;
        NodeDemension returnObj = new NodeDemension();
        String layout = (String)node.getClient("layout");
        if (TopoServiceUtil.checkTopBottom(layout)) {
            if (hight > 0.0) {
                hight -= ((Double)node.getClient("sonsGap")).doubleValue();
            }
        } else if (TopoServiceUtil.checkLeftRight(layout) && width > 0.0) {
            width -= ((Double)node.getClient("sonsGap")).doubleValue();
        }
        if (width > 0.0) {
            width += 2.0 * (Double)node.getClient("leftGap");
        }
        if (hight > 0.0) {
            hight += 2.0 * (Double)node.getClient("topGap");
        }
        if (!VerifyUtil.isEmpty((String)node.getName()) && (groupLabelWidth = !"topleft.topright".equals(node.getStyle("label.position")) ? (double)node.getName().length() * 10.0 : (Double)node.getStyle("label.xoffset") + (double)node.getName().length() * 10.0) > width) {
            width = groupLabelWidth;
        }
        returnObj.setWidth(width);
        returnObj.setHight(hight);
        logger.debug((Object)("the width=" + width + "hight=" + hight));
        return returnObj;
    }

    private static boolean checkLeftRight(String layout) {
        return layout.equals("leftright") || layout.equals("rightleft");
    }

    private static boolean checkTopBottom(String layout) {
        return layout.equals("bottomtop") || layout.equals("topbottom");
    }

    private static NodeDemension countWidthAndHeightOfSons(Node fatherNode, double width, double hight, IElement son) {
        NodeDemension returnObj = new NodeDemension();
        if (son instanceof Node) {
            Node node;
            Node sonNode = (Node)son;
            double sonWidth = 0.0;
            double sonHeight = 0.0;
            if (sonNode.getChildrenCount() > 0) {
                NodeDemension groupNodeWh = TopoServiceUtil.countGroupNodeDemension(sonNode);
                sonWidth = groupNodeWh.getWidth();
                sonHeight = groupNodeWh.getHight();
                if (null != sonNode.getID() && String.valueOf(sonNode.getID()).contains("subNetwork:more:")) {
                    sonWidth = 48.0;
                    sonHeight = 15.0;
                }
            } else if (sonNode.getChildrenCount() == 0 && !"node_image".equals((node = sonNode).getImage())) {
                NodeDemension groupNodeWh = TopoServiceUtil.countSingleNodeDemension(sonNode);
                sonWidth = groupNodeWh.getWidth();
                sonHeight = groupNodeWh.getHight();
            }
            if (null == fatherNode.getID() || !String.valueOf(fatherNode.getID()).contains("subNetwork:more:")) {
                NodeDemension demensionWithGap = TopoServiceUtil.addGapWidthAndHeight(fatherNode, width, hight, sonWidth, sonHeight);
                width = demensionWithGap.getWidth();
                hight = demensionWithGap.getHight();
            }
        }
        returnObj.setHight(hight);
        returnObj.setWidth(width);
        logger.debug((Object)("the width=" + width + "hight=" + hight));
        return returnObj;
    }

    private static NodeDemension countGroupNodeDemension(Node groupNode) {
        double sonWidth = 0.0;
        double sonHeight = 0.0;
        NodeDemension sonNodeWH = TopoServiceUtil.computeNodeWidthAndHight(groupNode);
        if (sonNodeWH != null) {
            sonWidth = sonNodeWH.getWidth();
            sonHeight = sonNodeWH.getHight();
        }
        if (!VerifyUtil.isEmpty((String)groupNode.getName()) && !"right.right".equals(groupNode.getStyle("label.position"))) {
            sonHeight += 20.0;
        }
        if (groupNode.getStyle("icons.names") != null) {
            double iconHeight = (Double)groupNode.getClient("iconHeight");
            double iconWidth = (Double)groupNode.getClient("iconWidth");
            if (iconWidth > sonWidth) {
                groupNode.setWidth(iconWidth);
                sonWidth = iconWidth;
            }
            sonHeight += iconHeight;
            groupNode.setClient("iconHeight", iconHeight);
        }
        NodeDemension returnObj = new NodeDemension();
        returnObj.setWidth(sonWidth);
        returnObj.setHight(sonHeight);
        logger.debug((Object)"the width=%s,hight=%s", new Object[]{String.valueOf(sonWidth), String.valueOf(sonHeight)});
        return returnObj;
    }

    private static NodeDemension countSingleNodeDemension(Node singleNode) {
        NodeDemension returnObj = new NodeDemension();
        try {
            double sonWidth = 0.0;
            double sonHeight = 0.0;
            sonWidth = (Double)singleNode.getClient("imageWidth");
            sonHeight = (Double)singleNode.getClient("imageHeight");
            singleNode.setClient("imageWidth", sonWidth);
            singleNode.setClient("imageHeight", sonHeight);
            double nodeLabelWidth = 0.0;
            if (singleNode.getName() != null && !"right.right".equals(singleNode.getStyle("label.position"))) {
                nodeLabelWidth = (double)singleNode.getName().length() * 10.0;
            }
            if (nodeLabelWidth > sonWidth) {
                if (BusinessUtil.isUltraVR()) {
                    double padding = (sonWidth - nodeLabelWidth) / 2.0;
                    singleNode.setStyle("image.padding.left", padding);
                    singleNode.setStyle("image.padding.right", padding);
                }
                sonWidth = nodeLabelWidth;
            }
            singleNode.setSize(sonWidth, sonHeight);
            if (!VerifyUtil.isEmpty((String)singleNode.getName()) && !"right.right".equals(singleNode.getStyle("label.position"))) {
                sonHeight += 20.0;
            }
            returnObj.setWidth(sonWidth);
            returnObj.setHight(sonHeight);
        }
        catch (Exception e) {
            logger.error((Object)("Count singleNode demension error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return returnObj;
    }

    private static NodeDemension addGapWidthAndHeight(Node fatherNode, double width, double hight, double sonWidth, double sonHeight) {
        String layout = (String)fatherNode.getClient("layout");
        NodeDemension returnObj = new NodeDemension();
        if (TopoServiceUtil.checkTopBottom(layout)) {
            if (sonWidth > width) {
                width = sonWidth;
            }
            hight += sonHeight + (Double)fatherNode.getClient("sonsGap");
        } else if (TopoServiceUtil.checkLeftRight(layout)) {
            if (sonHeight > hight) {
                hight = sonHeight;
            }
            width += sonWidth + (Double)fatherNode.getClient("sonsGap");
        }
        returnObj.setWidth(width);
        returnObj.setHight(hight);
        logger.debug((Object)("the width=" + sonWidth + "hight=" + sonWidth));
        return returnObj;
    }

    public static void addElementToBox(ElementBox box, IData data) {
        String id = (String)data.getID();
        try {
            if (!box.containsByID((Object)id)) {
                box.add(data);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to add data to box.ID:" + data.getID() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    public static void createSimpleLinkOfPO(Node from, Node to, String linkLayerId, ElementBox box, Node father, boolean isCORNER) {
        if (TopoServiceUtil.isExistLinkBetweenNodes(from, to)) {
            logger.debug((Object)"there is no link");
            return;
        }
        Link link = new Link(from, to);
        from.setLayerID((Object)linkLayerId);
        to.setLayerID((Object)linkLayerId);
        link.setLayerID((Object)linkLayerId);
        link.setStyle("link.width", 1.0);
        link.setStyle("arrow.to", false);
        link.setStyle("arrow.to.color", 3259670);
        link.setStyle("link.color", 3259670);
        link.setStyle("link.from.at.edge", false);
        link.setStyle("link.to.at.edge", false);
        if (isCORNER) {
            link.setStyle("link.type", (Object)"orthogonal.horizontal");
            link.setStyle("link.corner", (Object)"none");
            link.setStyle("link.extend", 0);
            link.setStyle("link.split.by.percent", true);
            link.setStyle("link.split.percent", 0.4);
        }
        father.addChild((IData)link);
        TopoServiceUtil.addElementToBox(box, (IData)link);
    }

    public static Node createProtectObjStyleNode(TopoBaseContext context, String poTypeName, String styleNodeId) {
        Node group = (Node)context.getElementBox().getElementByID((Object)styleNodeId);
        if (group != null) {
            logger.debug((Object)"the group is exit,styleNodeId: %s.", new Object[]{styleNodeId});
            Theme.BLUE.apply((IElement)group);
            return group;
        }
        group = new Node((Object)styleNodeId);
        group.setStyle("vector.roundrect.radius", 7);
        group.setClient("layout", (Object)"topbottom");
        group.setClient("TopoModel", (Object)"StyleGroup");
        group.setClient("leftGap", 1.0);
        group.setClient("topGap", 1.0);
        group.setClient("sonsGap", 8.0);
        group.setStyle("label.position", (Object)"topleft.topright");
        group.setStyle("label.xoffset", 15.0);
        group.setStyle("content.type", (Object)"vector");
        group.setStyle("vector.shape", (Object)"roundrect");
        group.setClient("iconWidth", 48.0);
        group.setClient("iconHeight", 48.0);
        group.setStyle("icons.position", (Object)"topleft.topright");
        group.setStyle("label.bold", false);
        String nodeLabel = null != poTypeName ? poTypeName : "--";
        group.setClient("iconFlag", false);
        group.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/blank.png");
        group.setName(nodeLabel);
        group.setStyle("label.font", (Object)TopoBaseContext.getTopoResourceManager().getText("ism.drm.topo.label.font"));
        group.setStyle("label.color", (Object)"0x222222");
        Theme.BLUE.apply((IElement)group);
        return group;
    }

    public static Node createDiskGroupStyleNode(TopoBaseContext context, String hostSN) {
        String nodeId = hostSN + ":diskGroupStyle";
        logger.debug((Object)"nodeID = %s.", new Object[]{nodeId});
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeId);
        if (group == null) {
            group = TopoServiceUtil.createGroupStyleNode(nodeId);
            group.setStyle("vector.fill.color", 0xFCFCFC);
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.fill", false);
            group.setStyle("vector.outline.width", 0);
            group.setStyle("vector.outline.color", 0xDCDCDC);
        }
        Theme.BLUE100.apply((IElement)group);
        return group;
    }

    public static Node createDataStoreStyleNode(TopoBaseContext context, String vcenterSN) {
        String nodeId = vcenterSN + ":dataStoreStyle";
        logger.debug((Object)"nodeID = %s.", new Object[]{nodeId});
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeId);
        if (null != group) {
            Theme.BLUE100.apply((IElement)group);
            return group;
        }
        group = TopoServiceUtil.createGroupStyleNode(nodeId);
        group.setStyle("vector.fill.color", 0xFCFCFC);
        group.setClient("leftGap", 11.0);
        group.setClient("topGap", 11.0);
        group.setClient("sonsGap", 7.0);
        group.setStyle("vector.fill", false);
        group.setStyle("vector.outline.width", 0);
        group.setStyle("vector.outline.color", 0xDCDCDC);
        Theme.BLUE100.apply((IElement)group);
        return group;
    }

    public static Node createDeviceStyleNode(TopoBaseContext context, String hostSN) {
        String nodeId = hostSN + ":hangPointStyle";
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeId);
        if (null != group) {
            logger.debug((Object)"group is exist,nodeID: %s", new Object[]{nodeId});
            return group;
        }
        group = TopoServiceUtil.createGroupStyleNode(nodeId);
        group.setStyle("vector.fill.color", 0xFCFCFC);
        group.setClient("leftGap", 11.0);
        group.setClient("topGap", 11.0);
        group.setClient("sonsGap", 7.0);
        group.setStyle("vector.fill", false);
        group.setStyle("vector.outline.width", 0);
        group.setStyle("vector.outline.color", 0xDCDCDC);
        Theme.BLUE100.apply((IElement)group);
        return group;
    }

    public static Node createDeviceAndDiskStyle(TopoBaseContext context, String providerSN) {
        String nodeID = providerSN + ":deviceStyleNode";
        logger.debug((Object)"nodeID = %s", new Object[]{nodeID});
        Node deviceStyleNode = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (null != deviceStyleNode) {
            return deviceStyleNode;
        }
        deviceStyleNode = new Node((Object)nodeID);
        deviceStyleNode.setClient("TopoModel", (Object)"StyleGroup");
        deviceStyleNode.setStyle("vector.roundrect.radius", 7);
        deviceStyleNode.setClient("leftGap", 10.0);
        deviceStyleNode.setClient("topGap", 10.0);
        deviceStyleNode.setClient("sonsGap", 20.0);
        deviceStyleNode.setClient("layout", (Object)"leftright");
        deviceStyleNode.setStyle("content.type", (Object)"vector");
        deviceStyleNode.setStyle("vector.shape", (Object)"roundrect");
        deviceStyleNode.setClient("iconFlag", true);
        deviceStyleNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/blank.png");
        deviceStyleNode.setClient("iconWidth", 60.0);
        deviceStyleNode.setClient("iconHeight", 60.0);
        Theme.BLUE.apply((IElement)deviceStyleNode);
        return deviceStyleNode;
    }

    public static Node createDiskStyleNode(TopoBaseContext context, String hostSN) {
        String nodeID = hostSN + ":diskStyle";
        logger.debug((Object)"nodeID = %s", new Object[]{nodeID});
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (group == null) {
            group = TopoServiceUtil.createGroupStyleNode(nodeID);
            group.setStyle("vector.fill.color", 0xFCFCFC);
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.fill", false);
            group.setStyle("vector.outline.width", 0);
            group.setStyle("vector.outline.color", 0xDCDCDC);
            Theme.BLUE100.apply((IElement)group);
        }
        return group;
    }

    public static Node createGroupStyleNode(String id) {
        Node group = new Node((Object)id);
        logger.debug((Object)("nodeID = " + id));
        group.setStyle("vector.roundrect.radius", 7);
        group.setClient("layout", (Object)"topbottom");
        group.setClient("TopoModel", (Object)"StyleGroup");
        group.setStyle("content.type", (Object)"vector");
        group.setStyle("vector.shape", (Object)"roundrect");
        return group;
    }

    public static Node createDBInstaceStyleNode(TopoBaseContext context, String styleNodeId) {
        String nodeID = styleNodeId + ":poStyle";
        logger.debug((Object)("nodeID = " + nodeID));
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (group == null) {
            group = TopoServiceUtil.createGroupStyleNode(nodeID);
            group.setStyle("vector.fill.color", 0xFCFCFC);
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.fill", false);
            group.setStyle("vector.outline.width", 0);
            group.setStyle("vector.outline.color", 0xDCDCDC);
        }
        return group;
    }

    public static Node createUnVisibleStyleNode(TopoBaseContext context, String styleNodeId) {
        String nodeID = styleNodeId + ":unvisible";
        logger.debug((Object)("nodeID = " + nodeID));
        Node group = (Node)context.getElementBox().getElementByID((Object)nodeID);
        if (group == null) {
            group = TopoServiceUtil.createGroupStyleNode(nodeID);
            group.setStyle("vector.fill.color", 0xFAFAFA);
            group.setClient("leftGap", 11.0);
            group.setClient("topGap", 11.0);
            group.setClient("sonsGap", 7.0);
            group.setStyle("vector.outline.width", 0);
            group.setStyle("vector.outline.color", 0xFAFAFA);
            group.setStyle("vector.fill", false);
            group.setStyle("content.type", (Object)"vector");
        }
        return group;
    }

    public static Node createUnVisibleStorageNode(TopoBaseContext context, String styleNodeId) {
        Node group = TopoServiceUtil.createUnVisibleStyleNode(context, styleNodeId);
        group.setClient("layout", (Object)"leftright");
        group.setStyle("vector.outline.alpha", 0.0);
        group.setStyle("vector.outline.width", 1.0);
        group.setStyle("icons.position", (Object)"right.right");
        group.setClient("iconHeight", 48.0);
        group.setClient("iconWidth", 48.0);
        group.setClient("ISSNAPPO", (Object)"FALSE");
        return group;
    }

    public static String convertHtmlString(String srcStr) {
        if (srcStr == null || srcStr.isEmpty()) {
            logger.debug((Object)"param is null", 1L);
            return srcStr;
        }
        return srcStr.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#40;", "(").replaceAll("&#41;", ")").replaceAll("&#37;", "%").replaceAll("&nbsp;", " ").replaceAll("&amp;", "&").replace("&#96;", "`");
    }

    public static Link getExistLinkBetweenNodes(Node from, Node to) {
        Link isExistLink = null;
        if (null == from || null == to) {
            logger.debug((Object)"param is null");
            return null;
        }
        List linkList = from.getFromLinks();
        if (linkList == null) {
            isExistLink = null;
        } else {
            for (Link link : linkList) {
                Node toNode = link.getToNode();
                if (!to.equals(toNode)) continue;
                isExistLink = link;
                break;
            }
        }
        return isExistLink;
    }

    public static boolean checkIsASM(int storageType) {
        logger.debug((Object)"storageType = %s", (long)storageType);
        return storageType == DrmEnumDefine.StorageTypeE.ASM_LIB.getValue() || storageType == DrmEnumDefine.StorageTypeE.ASM_LINK.getValue() || storageType == DrmEnumDefine.StorageTypeE.ASM_PRIMAL.getValue() || storageType == DrmEnumDefine.StorageTypeE.ASM_WINDOWS.getValue() || storageType == DrmEnumDefine.StorageTypeE.ASM_UDEV.getValue();
    }
}

