/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp.api;

import com.huawei.lego.com.south.snmp.abs.Property;
import com.huawei.lego.com.south.snmp.api.TableResponse;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;

class TextTableListener
implements TableListener {
    private TableResponse table = null;
    private Log logger = LogFactory.getInstance(this);
    private boolean finish;
    private boolean tmout = false;

    TextTableListener(TableResponse table) {
        this.table = table;
    }

    public void timeout() {
        this.tmout = true;
    }

    public TableResponse getTable() {
        return this.table;
    }

    public void setTable(TableResponse table) {
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(TableEvent event) {
        this.finish = true;
        Object object = event.getUserObject();
        synchronized (object) {
            event.getUserObject().notifyAll();
        }
    }

    public boolean next(TableEvent event) {
        if (this.tmout) {
            return false;
        }
        ArrayList<String> row = new ArrayList<String>();
        ArrayList<Property> rawDataRow = new ArrayList<Property>();
        if (event.getColumns().length == 0) {
            return true;
        }
        for (int i = 0; i < event.getColumns().length; ++i) {
            try {
                VariableBinding vba = event.getColumns()[i];
                if (vba == null) continue;
                String oid = vba.getOid().toString();
                String v = vba.getVariable().toString();
                int type = vba.getSyntax();
                row.add(v);
                rawDataRow.add(new Property(oid, v, type, event.getIndex().toString()));
                this.logger.debug((Object)("@@@@ Event @@@@@ oid:" + oid), 200L);
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Error when set Table." + ExceptionUtil.getErrorMessage(e)), 200L);
                break;
            }
        }
        this.table.addRow(row);
        this.table.addRawRow(rawDataRow);
        ((Counter32)event.getUserObject()).increment();
        return true;
    }

    public boolean isFinished() {
        return this.finish;
    }
}

