/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.exception;

import com.huawei.lego.core.sdk.exception.ExceptionInfor;
import com.huawei.lego.core.sdk.exception.ExceptionInforLoader;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Properties;

public class ExceptionLogDecorator
extends RuntimeException {
    private static final long serialVersionUID = -7330712415483341792L;
    private static final Log LOG = LogFactory.getInstance(ExceptionLogDecorator.class);

    public ExceptionLogDecorator(String message, Throwable cause) {
        super(message, cause);
        Class<?> clazz = cause.getClass();
        Properties prop = ExceptionInforLoader.getLoader().getProperties();
        LOG.error((Object)new ExceptionInfor(clazz, prop).toString(), null, 0L);
    }

    public ExceptionLogDecorator(String message) {
        super(message);
        LOG.error((Object)message, null, 0L);
    }

    public ExceptionLogDecorator(int errorCode) {
        LOG.error((Object)("Code: " + errorCode), null, 0L);
    }

    public ExceptionLogDecorator(Throwable cause) {
        super(cause);
        Class<?> clazz = cause.getClass();
        Properties prop = ExceptionInforLoader.getLoader().getProperties();
        LOG.error((Object)new ExceptionInfor(clazz, prop).toString(), null, 0L);
    }

    public ExceptionLogDecorator(int errorCode, Throwable exception) {
        super("Code: " + errorCode, exception);
        LOG.error((Object)("Code: " + errorCode), null, 0L);
    }

    public ExceptionLogDecorator(int errorCode, String info) {
        super("Code: " + errorCode + "\t" + info);
        LOG.error((Object)("Code: " + errorCode + "\t" + info), null, 0L);
    }
}

