/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelFileUtil
extends FileUtil {
    private static final int NUM_2 = 2;
    private static final int COLUMNWIDTH = 8000;
    private static final Log LOG = LogFactory.getInstance(ExcelFileUtil.class);
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataList) {
        this.writeFile(dataList, (String)null);
    }

    @Override
    public void closeFile() throws IOException {
        this.workbook.write((OutputStream)this.getWriteFileOut());
        this.getWriteFileOut().flush();
        this.getWriteFileOut().close();
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<List<String>>> dataList, List<String> sheetNames) {
        if (this.getWriteFileName() == null) {
            LOG.error("End to write file,cause file is empty.");
            return;
        }
        if (dataList.size() != sheetNames.size()) {
            LOG.warn("Failed to write file, cause param error.");
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Failed to write file, cause file:%s not found", this.getWriteFileName());
            return;
        }
        short defaultDataFmt = this.getDefaultDataFmt();
        for (int i = 0; i < sheetNames.size(); ++i) {
            HSSFSheet sheet = this.workbook.createSheet(sheetNames.get(i));
            int rowNum = this.writeTitle(sheet, this.getColTitles().get(i));
            this.writeData(dataList.get(i), null, sheet, rowNum, defaultDataFmt);
        }
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailPath) {
        if (this.getWriteFileName() == null) {
            LOG.error("End to write file,cause file is empty.");
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Failed to write file, cause file:%s not found", this.getWriteFileName());
            return;
        }
        HSSFSheet sheet = this.workbook.createSheet();
        int rowNum = this.writeTitle(sheet, this.getColTitle());
        short defaultDataFmt = this.getDefaultDataFmt();
        this.writeData(dataLst, detailPath, sheet, rowNum, defaultDataFmt);
    }

    private short getDefaultDataFmt() {
        VerifyUtil.checkObject(this.workbook);
        return this.workbook.createDataFormat().getFormat("text");
    }

    private void writeData(List<List<String>> dataLst, String detailPath, HSSFSheet sheet, int rowNum, short defaultDataFmt) {
        int rowNumOfSheet = rowNum + 1;
        for (List<String> lstStrs : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            this.processCell(lstStrs, row, sheet, detailPath, defaultDataFmt);
            ++rowNumOfSheet;
        }
    }

    private int writeTitle(HSSFSheet sheet, List<String> colTitle) {
        int rowNum = 0;
        int num = colTitle.size();
        if (!VerifyUtil.isEmpty(this.getTitle())) {
            HSSFRow rowTitle = sheet.createRow(0);
            HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
            cellTitle.setCellType(CellType.STRING);
            cellTitle.setCellValue(this.getTitle());
            ++rowNum;
        }
        HSSFRow rowColUsr = sheet.createRow(rowNum);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(++rowNum);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitlet = rowColTitle.createCell(i);
            cellColTitlet.setCellType(CellType.STRING);
            cellColTitlet.setCellValue(colTitle.get(i));
        }
        return rowNum;
    }

    private void processCell(List<String> lstStrs, HSSFRow row, HSSFSheet sheet, String detailPath, short defaultFmt) {
        for (int cellNumOfRow = 0; cellNumOfRow < lstStrs.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
            String logId;
            sheet.setColumnWidth(cellNumOfRow, 8000);
            HSSFCell cell = row.createCell(cellNumOfRow);
            cell.setCellType(CellType.STRING);
            HSSFCellStyle cellStyle = cell.getCellStyle();
            cellStyle.setDataFormat(defaultFmt);
            if (null != lstStrs.get(cellNumOfRow)) {
                cell.setCellValue(lstStrs.get(cellNumOfRow));
            } else {
                cell.setCellValue("");
            }
            if (VerifyUtil.isEmpty(detailPath) || (logId = lstStrs.get(lstStrs.size() - 1)) == null || cellNumOfRow != lstStrs.size() - 1) continue;
            HSSFCellStyle linkStyle = this.workbook.createCellStyle();
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Arial");
            font.setUnderline((byte)1);
            font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            linkStyle.setFont(font);
            String strVal = "";
            if (null != lstStrs.get(cellNumOfRow)) {
                strVal = lstStrs.get(cellNumOfRow);
            }
            cell.setCellStyle(linkStyle);
            cell.setCellFormula("HYPERLINK(\"" + detailPath + logId + ".txt\",\"" + strVal + "\")");
        }
    }
}

