/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.log;

import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.DefaultLogConfigurator;
import com.huawei.lego.core.sdk.log.LegoLogger;
import com.huawei.lego.core.sdk.log.Log;
import java.util.HashMap;
import java.util.Map;

public final class FELogFactory {
    public static final String PRODUCT_LEGO = "com.huawei.lego";
    private static Map<String, Log> logs = new HashMap<String, Log>();
    private static Map<Long, Map<String, CodeLog>> codeLogs = new HashMap<Long, Map<String, CodeLog>>();

    private FELogFactory() {
    }

    public static Log getInstance(String logName) {
        return FELogFactory.getInstance(logName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getInstance(String logName, boolean showLocSrc) {
        Log log = logs.get(logName);
        Map<String, Log> map = logs;
        synchronized (map) {
            if (log == null) {
                DefaultLogConfigurator.configurator(logName);
                log = new LegoLogger("com.huawei.lego." + logName);
                logs.put(logName, log);
            }
        }
        log.setShowLocSrc(showLocSrc);
        return log;
    }

    public static CodeLog getInstance(String logName, long logCode) {
        return FELogFactory.getInstance(logName, logCode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeLog getInstance(String logName, long logCode, boolean showLocSrc) {
        CodeLog codeLog = null;
        Map<String, CodeLog> codeLogMap = codeLogs.get(logCode);
        if (codeLogMap != null) {
            codeLog = codeLogMap.get(logName);
        }
        Map<Long, Map<String, CodeLog>> map = codeLogs;
        synchronized (map) {
            if (codeLog == null) {
                DefaultLogConfigurator.configurator(logName, logCode);
                codeLog = new LegoLogger("com.huawei.lego." + logName + logCode, logCode);
                FELogFactory.saveCodeLog(logCode, logName, codeLog);
            }
        }
        codeLog.setShowLocSrc(showLocSrc);
        return codeLog;
    }

    private static void saveCodeLog(long logCode, String logName, CodeLog codeLog) {
        Map<String, CodeLog> codeLogMap = codeLogs.get(logCode);
        if (codeLogMap == null) {
            codeLogMap = new HashMap<String, CodeLog>();
        }
        codeLogMap.put(logName, codeLog);
        codeLogs.put(logCode, codeLogMap);
    }
}

